/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.explosive.blast;

import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.api.edit.IWorldChangeAction;
import com.builtbroken.mc.api.edit.IWorldChangeAudio;
import com.builtbroken.mc.api.edit.IWorldChangeGraphics;
import com.builtbroken.mc.api.edit.IWorldEdit;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.explosive.IBlast;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.lib.world.edit.BlockEdit;
import com.builtbroken.mc.lib.world.edit.BlockEditResult;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class Blast<B extends Blast>
implements IWorldChangeAction,
IWorldPosition,
IWorldChangeAudio,
IWorldChangeGraphics,
IBlast {
    public World world;
    public double x;
    public double y;
    public double z;
    public double size = 1.0;
    public float eUnitPerBlock = 5.0f;
    public boolean killExplosion = false;
    public TriggerCause cause = new TriggerCause.TriggerCauseRedstone(ForgeDirection.UNKNOWN, 15);
    private NBTTagCompound additionBlastData;

    public Blast() {
    }

    public Blast(World world, int x, int y, int z, int size) {
        this.setLocation(world, x, y, z);
        this.setYield(size);
    }

    public B setLocation(World world, double x, double y, double z) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        return (B)this;
    }

    public B setYield(double size) {
        this.size = size;
        return (B)this;
    }

    public B setEnergyPerBlock(float f) {
        this.eUnitPerBlock = f;
        return (B)this;
    }

    public B setCause(TriggerCause cause) {
        this.cause = cause;
        return (B)this;
    }

    public B setAdditionBlastData(NBTTagCompound additionBlastData) {
        this.additionBlastData = additionBlastData;
        return (B)this;
    }

    public NBTTagCompound getAdditionBlastData() {
        return this.additionBlastData;
    }

    @Override
    public int shouldThreadAction() {
        return this.size > 4.0 ? 20 : -1;
    }

    public List<IWorldEdit> getEffectedBlocks() {
        ArrayList<IWorldEdit> list = new ArrayList<IWorldEdit>();
        this.getEffectedBlocks(list);
        return list;
    }

    public void getEffectedBlocks(List<IWorldEdit> list) {
    }

    @Override
    public void handleBlockPlacement(IWorldEdit vec) {
        if (vec != null && vec.hasChanged()) {
            if (vec instanceof BlockEdit && ((BlockEdit)vec).doItemDrop) {
                List<ItemStack> items = ((BlockEdit)vec).getDrops(this.getFortuneModifierForBlockDrop());
                if (vec.place() == BlockEditResult.PLACED) {
                    for (ItemStack item : items) {
                        if (item == null || item.func_77973_b() == null || item.field_77994_a <= 0) continue;
                        InventoryUtility.dropItemStack(this.world, ((BlockEdit)vec).xi(), ((BlockEdit)vec).yi(), ((BlockEdit)vec).zi(), item, 2, 1.0f);
                    }
                }
            } else {
                vec.place();
            }
        }
    }

    protected int getFortuneModifierForBlockDrop() {
        return 0;
    }

    @Override
    public void doEffectOther(boolean beforeBlocksPlaced) {
    }

    protected void damageEntities(List<Entity> entities, DamageSource source) {
        this.damageEntities(entities, source, 1.0f);
    }

    protected void damageEntities(List<Entity> entities, DamageSource source, float damageScale) {
        Vec3 vec3 = Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
        for (Entity entity : entities) {
            double deltaZ;
            double deltaY;
            double deltaX;
            double mag;
            double distanceScaled = entity.func_70011_f(this.x, this.y, this.z) / this.size;
            if (!(distanceScaled <= 1.0) || (mag = (double)MathHelper.func_76133_a((double)((deltaX = entity.field_70165_t - this.x) * deltaX + (deltaY = entity.field_70163_u + (double)entity.func_70047_e() - this.y) * deltaY + (deltaZ = entity.field_70161_v - this.z) * deltaZ))) == 0.0) continue;
            deltaX /= mag;
            deltaY /= mag;
            deltaZ /= mag;
            double blockDensity = this.world.func_72842_a(vec3, entity.field_70121_D);
            double force = (1.0 - distanceScaled) * blockDensity;
            if (source != null) {
                entity.func_70097_a(source, (float)((force * force + force) / 16.0 * this.size * (double)damageScale + 1.0));
            }
            double pushPercentage = EnchantmentProtection.func_92092_a((Entity)entity, (double)force);
            entity.field_70159_w += deltaX * pushPercentage;
            entity.field_70181_x += deltaY * pushPercentage;
            entity.field_70179_y += deltaZ * pushPercentage;
        }
    }

    @Override
    public void killAction(boolean willSave) {
        this.killExplosion = true;
    }

    protected boolean shouldKillAction() {
        return this.killExplosion || this.world == null || this.world.field_73011_w == null || DimensionManager.getWorld((int)this.world.field_73011_w.field_76574_g) == null;
    }

    @Override
    public World world() {
        return this.world;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public double z() {
        return this.z;
    }

    @Override
    public void playAudioForEdit(IWorldEdit blocks) {
    }

    @Override
    public void doStartAudio() {
        if (!this.world.field_72995_K) {
            this.world.func_72908_a(this.x, this.y, this.z, "random.explode", 4.0f, (float)((double)(1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * this.size));
        }
    }

    @Override
    public void doEndAudio() {
    }

    @Override
    public void displayEffectForEdit(IWorldEdit blocks) {
        if (!this.world.field_72995_K) {
            double posX = (float)blocks.x() + this.world.field_73012_v.nextFloat();
            double posY = (float)blocks.y() + this.world.field_73012_v.nextFloat();
            double posZ = (float)blocks.z() + this.world.field_73012_v.nextFloat();
            Pos pos = this.randomMotion(posX, posY, posZ);
            Engine.proxy.spawnParticle("explode", this.world, (posX + this.x * 1.0) / 2.0, (posY + this.y * 1.0) / 2.0, (posZ + this.z * 1.0) / 2.0, pos.x(), pos.y(), pos.z());
            Engine.proxy.spawnParticle("smoke", this.world, posX, posY, posZ, pos.x(), pos.y(), pos.z());
        }
    }

    protected final Pos randomMotion(double posX, double posY, double posZ) {
        double deltaX = posX - this.x;
        double deltaY = posY - this.y;
        double deltaZ = posZ - this.z;
        double mag = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
        deltaX /= mag;
        deltaY /= mag;
        deltaZ /= mag;
        double speedScale = 0.5 / (mag / this.size + 0.1);
        return new Pos(deltaX *= (speedScale *= (double)(this.world.field_73012_v.nextFloat() * this.world.field_73012_v.nextFloat() + 0.3f)), deltaY *= speedScale, deltaZ *= speedScale);
    }

    @Override
    public void doStartDisplay() {
        if (!this.world.field_72995_K) {
            if (this.size >= 2.0) {
                Engine.proxy.spawnParticle("hugeexplosion", this.world, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                Engine.proxy.spawnParticle("largeexplode", this.world, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void doEndDisplay() {
        if (this.world.field_72995_K) {
            if (this.size >= 2.0) {
                Engine.proxy.spawnParticle("hugeexplosion", this.world, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                Engine.proxy.spawnParticle("largeexplode", this.world, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean isCompleted() {
        return this.world == null || this.killExplosion;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass() == this.getClass() && obj instanceof Blast) {
            if (((Blast)obj).world != this.world) {
                return false;
            }
            if (((Blast)obj).x != this.x) {
                return false;
            }
            if (((Blast)obj).y != this.y) {
                return false;
            }
            if (((Blast)obj).z != this.z) {
                return false;
            }
            return ((Blast)obj).size == this.size;
        }
        return false;
    }
}

