/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.entity.damage;

import com.builtbroken.mc.prefab.entity.damage.DamageBleeding;
import com.builtbroken.mc.prefab.entity.damage.DamageElectrical;
import com.builtbroken.mc.prefab.entity.damage.DamageThermal;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;

public enum DamageSources {
    ELECTRIC(new DamageElectrical()),
    BLEEDING(new DamageBleeding()),
    THERMAL_INCREASE(new DamageThermal(true), new IEntityDamageSource(){

        @Override
        public DamageSource getSourceForEntity(Entity entity) {
            return new DamageThermal(true, (Object)entity);
        }
    }),
    THERMAL_DECREASE(new DamageThermal(false), new IEntityDamageSource(){

        @Override
        public DamageSource getSourceForEntity(Entity entity) {
            return new DamageThermal(false, (Object)entity);
        }
    });

    private DamageSource source;
    private IEntityDamageSource entitySource;

    private DamageSources(DamageSource source) {
        this.source = source;
    }

    private DamageSources(DamageSource source, IEntityDamageSource sourceEntity) {
        this(source);
        this.entitySource = sourceEntity;
    }

    public DamageSource getSource(Object cause) {
        if (cause instanceof Entity) {
            return this.entitySource.getSourceForEntity((Entity)cause);
        }
        return this.source;
    }

    public DamageSource getSource() {
        return this.source;
    }

    public static interface IEntityDamageSource {
        public DamageSource getSourceForEntity(Entity var1);
    }
}

