/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.energy;

import com.builtbroken.mc.api.energy.IEnergyBuffer;

public class EnergyBuffer
implements IEnergyBuffer {
    private final int maxStorage;
    private int energyStorage;

    public EnergyBuffer(int maxStorage) {
        this.maxStorage = maxStorage;
    }

    @Override
    public int addEnergyToStorage(int energy, boolean doAction) {
        if (energy > 0) {
            int roomLeft = this.getMaxBufferSize() - this.getEnergyStored();
            if (energy < roomLeft) {
                if (doAction) {
                    this.energyStorage += energy;
                }
                return energy;
            }
            if (doAction) {
                this.energyStorage = this.getMaxBufferSize();
            }
            return roomLeft;
        }
        return 0;
    }

    @Override
    public int removeEnergyFromStorage(int energy, boolean doAction) {
        if (energy > 0) {
            if (energy >= this.maxStorage) {
                if (doAction) {
                    this.energyStorage = 0;
                }
                return this.maxStorage;
            }
            if (doAction) {
                this.energyStorage -= energy;
            }
            return energy;
        }
        return 0;
    }

    @Override
    public int getMaxBufferSize() {
        return this.maxStorage;
    }

    @Override
    public int getEnergyStored() {
        return this.energyStorage;
    }
}

