/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.radar;

import com.builtbroken.mc.lib.transform.region.Cube;
import com.builtbroken.mc.lib.world.radar.RadarEntity;
import com.builtbroken.mc.lib.world.radar.RadarObject;
import com.builtbroken.mc.lib.world.radar.RadarTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.chunk.Chunk;

public class RadarMap {
    protected final int dimID;
    protected HashMap<ChunkCoordIntPair, List<RadarObject>> chunk_to_entities = new HashMap();
    protected List<RadarObject> allEntities = new ArrayList<RadarObject>();
    int ticks = 0;
    static final int UPDATE_DELAY = 20;

    public RadarMap(int dimID) {
        this.dimID = dimID;
    }

    public void update() {
        if (this.ticks++ >= 20 && this.chunk_to_entities.size() > 0) {
            this.ticks = 0;
            HashMap<RadarObject, ChunkCoordIntPair> removeList = new HashMap<RadarObject, ChunkCoordIntPair>();
            ArrayList<RadarObject> addList = new ArrayList<RadarObject>();
            for (Map.Entry<ChunkCoordIntPair, List<RadarObject>> entry : this.chunk_to_entities.entrySet()) {
                if (entry.getValue() == null) continue;
                for (RadarObject object : entry.getValue()) {
                    if (entry.getKey() == object.getChunkCoordIntPair()) continue;
                    removeList.put(object, entry.getKey());
                    if (!object.isValid()) continue;
                    addList.add(object);
                }
            }
            for (Map.Entry<Object, List<RadarObject<Object>>> entry : removeList.entrySet()) {
                this.allEntities.remove(entry.getKey());
                List<RadarObject> list = this.chunk_to_entities.get(entry.getValue());
                if (list != null) {
                    list.remove(entry.getKey());
                    if (list.size() > 0) {
                        this.chunk_to_entities.put((ChunkCoordIntPair)entry.getValue(), list);
                        continue;
                    }
                    this.chunk_to_entities.remove(entry.getValue());
                    continue;
                }
                this.chunk_to_entities.remove(entry.getValue());
            }
            addList.forEach(this::add);
            Iterator<RadarObject> it = this.allEntities.iterator();
            while (it.hasNext()) {
                RadarObject radarObject = it.next();
                if (!radarObject.isValid()) continue;
                it.remove();
            }
        }
    }

    public boolean add(Entity entity) {
        return this.add(new RadarEntity(entity));
    }

    public boolean add(TileEntity tile) {
        return this.add(new RadarTile(tile));
    }

    public boolean add(RadarObject object) {
        if (!this.allEntities.contains(object) && object.isValid()) {
            this.allEntities.add(object);
            ChunkCoordIntPair pair = this.getChunkValue((int)object.x(), (int)object.z());
            List<Object> list = this.chunk_to_entities.containsKey(pair) ? this.chunk_to_entities.get(pair) : new ArrayList();
            if (!list.contains(object)) {
                list.add(object);
                this.chunk_to_entities.put(pair, list);
                return true;
            }
        }
        return false;
    }

    public boolean remove(Entity entity) {
        return this.remove(new RadarEntity(entity));
    }

    public boolean remove(TileEntity tile) {
        return this.remove(new RadarTile(tile));
    }

    public boolean remove(RadarObject object) {
        ChunkCoordIntPair pair = this.getChunkValue((int)object.x(), (int)object.z());
        this.allEntities.remove(object);
        if (this.chunk_to_entities.containsKey(pair)) {
            List<RadarObject> list = this.chunk_to_entities.get(pair);
            boolean b = list.remove(object);
            if (list.isEmpty()) {
                this.chunk_to_entities.remove(pair);
            }
            return b;
        }
        return false;
    }

    public void remove(Chunk chunk) {
        ChunkCoordIntPair pair = chunk.func_76632_l();
        if (this.chunk_to_entities.containsKey(pair)) {
            for (RadarObject object : this.chunk_to_entities.get(pair)) {
                this.allEntities.remove(object);
            }
            this.chunk_to_entities.remove(pair);
        }
    }

    protected final ChunkCoordIntPair getChunkValue(int x, int z) {
        return new ChunkCoordIntPair(x >> 4, z >> 4);
    }

    public void unloadAll() {
        this.chunk_to_entities.clear();
    }

    public List<RadarObject> getRadarObjects(double x, double z, double distance) {
        return this.getRadarObjects(new Cube(x - distance, 0.0, z - distance, x + distance, 255.0, z + distance), true);
    }

    public List<RadarObject> getRadarObjects(Cube cube, boolean exact) {
        ArrayList<RadarObject> list = new ArrayList<RadarObject>();
        for (int chunkX = (cube.min().xi() >> 4) - 1; chunkX <= (cube.max().xi() >> 4) + 1; ++chunkX) {
            for (int chunkZ = (cube.min().zi() >> 4) - 1; chunkZ <= (cube.max().zi() >> 4) + 1; ++chunkZ) {
                List<RadarObject> objects;
                ChunkCoordIntPair p = new ChunkCoordIntPair(chunkX, chunkZ);
                if (!this.chunk_to_entities.containsKey(p) || (objects = this.chunk_to_entities.get(p)) == null) continue;
                if (exact) {
                    for (RadarObject object : objects) {
                        if (!object.isValid() || !cube.isWithin(object.x(), object.y(), object.z())) continue;
                        list.add(object);
                    }
                    continue;
                }
                list.addAll(objects);
            }
        }
        return list;
    }

    public int dimID() {
        return this.dimID;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RadarMap) {
            return ((RadarMap)object).dimID == this.dimID;
        }
        return false;
    }

    public String toString() {
        return "RadarMap[" + this.dimID + "]";
    }
}

