/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.heat;

import com.builtbroken.jlib.data.science.units.TemperatureUnit;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.world.edit.PlacementData;
import com.builtbroken.mc.lib.world.heat.BlockConversionData;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class HeatedBlockRegistry {
    public static HashMap<Block, BlockConversionData> warm_up_conversion = new HashMap();
    public static HashMap<Block, BlockConversionData> cool_down_conversion = new HashMap();
    public static HashMap<Material, Integer> default_melting_point_mat = new HashMap();
    public static HashMap<Material, Integer> default_temp_mat = new HashMap();
    public static HashMap<Integer, Integer> default_temp_dim = new HashMap();

    public static void addNewHeatingConversion(Block block, Block result, int kelvin) {
        HeatedBlockRegistry.addNewHeatingConversion(block, new PlacementData(result, -1), kelvin);
    }

    public static void addNewHeatingConversion(Block block, PlacementData result, int kelvin) {
        HeatedBlockRegistry.addNewHeatingConversion(new PlacementData(block, -1), result, kelvin);
    }

    public static void addNewHeatingConversion(PlacementData block, PlacementData result, int kelvin) {
        if (warm_up_conversion.containsKey(block.block())) {
            Engine.instance.logger().error("HeatedBlockRegistry: Block[" + (Object)((Object)block) + "] conversion to " + warm_up_conversion.get(block.block()) + " is being replaced by " + (Object)((Object)result));
        }
        warm_up_conversion.put(block.block(), new BlockConversionData(block, result, kelvin));
    }

    public static PlacementData getResult(Block block) {
        BlockConversionData conversion = HeatedBlockRegistry.getWarnUpData(block);
        if (conversion != null) {
            return conversion.resulting_block;
        }
        return null;
    }

    public static PlacementData getResultWarmUp(Block block, int temp) {
        BlockConversionData conversion = HeatedBlockRegistry.getWarnUpData(block);
        if (conversion != null && conversion.temp_kelvin <= temp) {
            return conversion.resulting_block;
        }
        return null;
    }

    public static PlacementData getResultCoolDown(Block block, int temp) {
        BlockConversionData conversion = HeatedBlockRegistry.getCoolDownData(block);
        if (conversion != null && conversion.temp_kelvin >= temp) {
            return conversion.resulting_block;
        }
        return null;
    }

    public static BlockConversionData getWarnUpData(Block block) {
        if (warm_up_conversion.containsKey(block)) {
            return warm_up_conversion.get(block);
        }
        return null;
    }

    public static BlockConversionData getCoolDownData(Block block) {
        if (cool_down_conversion.containsKey(block)) {
            return cool_down_conversion.get(block);
        }
        return null;
    }

    public static int getDefaultTemp(World world, Block block) {
        Material mat = block.func_149688_o();
        if (default_temp_mat.containsKey(mat)) {
            return default_temp_mat.get(mat);
        }
        if (default_temp_dim.containsKey(world.field_73011_w.field_76574_g)) {
            return default_temp_dim.get(world.field_73011_w.field_76574_g);
        }
        return 293;
    }

    public static void init(Configuration config) {
        config.setCategoryComment("Block_Heat_Conversions", "Conversion of one block into another when a lot of heat is added. 'Air' as an entry means the block turned into dust");
        HeatedBlockRegistry.addNewHeatingConversion(Blocks.field_150432_aD, Blocks.field_150355_j, (int)TemperatureUnit.Fahrenheit.conversion.toKelvin(32.0f));
        HeatedBlockRegistry.addNewHeatingConversion(Blocks.field_150343_Z, Blocks.field_150353_l, 1293);
        HeatedBlockRegistry.addNewHeatingConversion(Blocks.field_150348_b, Blocks.field_150353_l, 1293);
        HeatedBlockRegistry.addNewHeatingConversion((Block)Blocks.field_150349_c, Blocks.field_150346_d, 600);
        if (Block.field_149771_c instanceof FMLControlledNamespacedRegistry) {
            FMLControlledNamespacedRegistry reg = (FMLControlledNamespacedRegistry)Block.field_149771_c;
            for (Object obj : reg.typeSafeIterable()) {
                if (!(obj instanceof Block)) continue;
                String name = reg.func_148750_c(obj);
                Material mat = ((Block)obj).func_149688_o();
                int temp = 0;
                if (mat.func_76217_h()) {
                    temp = 600;
                }
                if (temp <= 0) continue;
                String conversion = config.getString(name, "Heat_Conversions", reg.func_148750_c((Object)Blocks.field_150350_a), "");
                if (reg.func_82594_a(conversion) != null) {
                    Object c_obj = reg.func_82594_a(conversion);
                    if (c_obj instanceof Block) {
                        if (warm_up_conversion.containsKey(obj)) continue;
                        HeatedBlockRegistry.addNewHeatingConversion((Block)obj, (Block)c_obj, 600);
                        continue;
                    }
                    Engine.instance.logger().error("Error c_obj is not an instance of a block");
                    continue;
                }
                Engine.instance.logger().error("Config entry for heat conversion " + name + " has an invalid conversion of " + conversion);
            }
        }
    }

    static {
        default_temp_dim.put(1, 327);
        default_temp_dim.put(0, 293);
        default_temp_dim.put(-1, 227);
        default_melting_point_mat.put(Material.field_151593_r, 600);
        default_melting_point_mat.put(Material.field_151580_n, 600);
        default_melting_point_mat.put(Material.field_151575_d, 800);
        default_melting_point_mat.put(Material.field_151576_e, 1200);
        default_melting_point_mat.put(Material.field_151571_B, 2000);
        default_melting_point_mat.put(Material.field_151574_g, 1900);
        default_melting_point_mat.put(Material.field_151573_f, 1900);
        default_melting_point_mat.put(Material.field_151586_h, 373);
        default_melting_point_mat.put(Material.field_151597_y, 273);
        default_melting_point_mat.put(Material.field_151588_w, 273);
        default_melting_point_mat.put(Material.field_151598_x, 273);
        default_melting_point_mat.put(Material.field_151596_z, 273);
        default_temp_mat.put(Material.field_151588_w, 253);
        default_temp_mat.put(Material.field_151598_x, 253);
        default_temp_mat.put(Material.field_151597_y, 253);
        default_temp_mat.put(Material.field_151596_z, 253);
    }
}

