/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.edit.thread;

import com.builtbroken.mc.api.edit.IWorldChangeAction;
import com.builtbroken.mc.api.edit.IWorldChangeLayeredAction;
import com.builtbroken.mc.api.edit.IWorldEdit;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.event.WorldChangeActionEvent;
import com.builtbroken.mc.api.process.IThreadProcess;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.world.edit.thread.WorldActionQue;
import com.builtbroken.mc.lib.world.edit.thread.action.WorldChangeActionPost;
import com.builtbroken.mc.lib.world.edit.thread.action.WorldEditQueue;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Collection;
import net.minecraftforge.common.MinecraftForge;

public class WCAThreadProcess
implements IThreadProcess {
    public final Location position;
    public final IWorldChangeAction blast;
    public final TriggerCause triggerCause;
    public int blocksPerTick = 200;
    private Collection<IWorldEdit> effectedBlocks;

    public WCAThreadProcess(Location vec, IWorldChangeAction blast, TriggerCause triggerCause) {
        this.position = vec;
        this.blast = blast;
        this.triggerCause = triggerCause;
        this.blocksPerTick = blast.shouldThreadAction();
    }

    @Override
    public void runProcess() {
        try {
            if (this.blast instanceof IWorldChangeLayeredAction && ((IWorldChangeLayeredAction)((Object)this.blast)).getLayers() > 1) {
                for (int i = 0; i < ((IWorldChangeLayeredAction)((Object)this.blast)).getLayers(); ++i) {
                    if (!((IWorldChangeLayeredAction)((Object)this.blast)).shouldContinueAction(i)) continue;
                    this.effectedBlocks = this.blast.getEffectedBlocks();
                    MinecraftForge.EVENT_BUS.post((Event)new WorldChangeActionEvent.FinishedCalculatingEffectEvent(this.position, this.effectedBlocks, this.blast, this.triggerCause));
                    WorldActionQue.addEditQue(new WorldEditQueue(this.position.world, this.blast, this.blocksPerTick, this.effectedBlocks));
                }
            } else {
                this.effectedBlocks = this.blast.getEffectedBlocks();
                MinecraftForge.EVENT_BUS.post((Event)new WorldChangeActionEvent.FinishedCalculatingEffectEvent(this.position, this.effectedBlocks, this.blast, this.triggerCause));
                WorldActionQue.addEditQue(new WorldEditQueue(this.position.world, this.blast, this.blocksPerTick, this.effectedBlocks));
            }
            WorldActionQue.addEditQue(new WorldChangeActionPost(this.blast));
        }
        catch (Exception e) {
            Engine.instance.logger().error("World Change action thread[" + this + "] has failed to execute correctly.", (Throwable)e);
        }
    }

    @Override
    public void killAction() {
        this.blast.killAction(false);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WCAThreadProcess) {
            if (((WCAThreadProcess)obj).position != this.position) {
                return false;
            }
            if (((WCAThreadProcess)obj).blast != this.blast) {
                return false;
            }
            if (((WCAThreadProcess)obj).triggerCause != this.triggerCause) {
                return false;
            }
        }
        return false;
    }
}

