/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.world.edit;

import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.world.edit.BlockEdit;
import com.builtbroken.mc.lib.world.edit.BlockEditResult;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class BlockEditMove
extends BlockEdit {
    public Location newMovementLocation;

    public BlockEditMove(NBTTagCompound nbt) {
        super(nbt);
        if (nbt.func_74764_b("newPos")) {
            this.newMovementLocation = new Location(nbt.func_74775_l("newPos"));
        }
    }

    public BlockEditMove(IWorldPosition vec, IWorldPosition newPos) {
        super(vec);
        this.newMovementLocation = new Location(newPos);
        this.logPrevBlock();
    }

    @Override
    protected BlockEditResult doPlace() {
        if (this.newMovementLocation != null) {
            BlockEditResult result;
            TileEntity entity = this.getTileEntity();
            NBTTagCompound tag = new NBTTagCompound();
            if (entity != null) {
                entity.func_145841_b(tag);
                tag.func_82580_o("x");
                tag.func_82580_o("y");
                tag.func_82580_o("z");
                tag.func_82580_o("id");
            }
            if ((result = super.doPlace()) == BlockEditResult.PLACED) {
                this.newMovementLocation.setBlock(this.prev_block, this.prev_meta);
                TileEntity tile = this.newMovementLocation.getTileEntity();
                if (tile != null) {
                    tile.func_145839_a(tag);
                    tile.field_145851_c = this.newMovementLocation.xi();
                    tile.field_145848_d = this.newMovementLocation.yi();
                    tile.field_145849_e = this.newMovementLocation.zi();
                }
            }
            return result;
        }
        return BlockEditResult.INVALID;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        super.writeNBT(nbt);
        if (this.newMovementLocation != null) {
            nbt.func_74782_a("newPos", (NBTBase)this.newMovementLocation.toNBT());
        }
        return nbt;
    }
}

