/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.transform.vector;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.jlib.data.vector.ITransform;
import com.builtbroken.jlib.data.vector.Pos3D;
import com.builtbroken.mc.lib.transform.rotation.EulerAngle;
import com.builtbroken.mc.lib.transform.vector.Point;
import com.builtbroken.mc.lib.transform.vector.Pos;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractPos<R extends AbstractPos>
extends Pos3D<R>
implements IPosition {
    public AbstractPos() {
        this(0.0, 0.0, 0.0);
    }

    public AbstractPos(double a) {
        this(a, a, a);
    }

    public AbstractPos(double x, double y, double z) {
        super(x, y, z);
    }

    public AbstractPos(double yaw, double pitch) {
        this(-Math.sin(Math.toRadians(yaw)), Math.sin(Math.toRadians(pitch)), -Math.cos(Math.toRadians(yaw)) * Math.cos(Math.toRadians(pitch)));
    }

    public AbstractPos(TileEntity tile) {
        this(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    public AbstractPos(Entity entity) {
        this(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public AbstractPos(IPos3D vec) {
        this(vec.x(), vec.y(), vec.z());
    }

    public AbstractPos(NBTTagCompound nbt) {
        this(nbt.func_74769_h("x"), nbt.func_74769_h("y"), nbt.func_74769_h("z"));
    }

    public AbstractPos(ByteBuf data) {
        this(data.readDouble(), data.readDouble(), data.readDouble());
    }

    public AbstractPos(MovingObjectPosition par1) {
        this(par1.field_72311_b, par1.field_72312_c, par1.field_72309_d);
    }

    public AbstractPos(ChunkCoordinates par1) {
        this(par1.field_71574_a, par1.field_71572_b, par1.field_71573_c);
    }

    public AbstractPos(ForgeDirection dir) {
        this(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    public AbstractPos(EnumFacing dir) {
        this(dir.func_82601_c(), dir.func_96559_d(), dir.func_82599_e());
    }

    public AbstractPos(Vec3 vec) {
        this(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public double angle(IPos3D other) {
        return Math.acos(((AbstractPos)this.cross(other)).magnitude() / (new Pos(other).magnitude() * this.magnitude()));
    }

    public double anglePreNorm(IPos3D other) {
        return Math.acos(((AbstractPos)this.cross(other)).magnitude());
    }

    public Vec3 toVec3() {
        return Vec3.func_72443_a((double)this.x(), (double)this.y(), (double)this.z());
    }

    public Point toVector2() {
        return new Point(this.x(), this.z());
    }

    public ForgeDirection toForgeDirection() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (this.xi() != dir.offsetX || this.yi() != dir.offsetY || this.zi() != dir.offsetZ) continue;
            return dir;
        }
        return ForgeDirection.UNKNOWN;
    }

    public EulerAngle toEulerAngle(IPos3D target) {
        return ((AbstractPos)this.sub(target)).toEulerAngle();
    }

    public EulerAngle toEulerAngle() {
        return new EulerAngle(Math.toDegrees(Math.atan2(this.x(), this.z())), Math.toDegrees(-Math.atan2(this.y(), Math.hypot(this.z(), this.x()))));
    }

    public IPos3D transform(ITransform transformer) {
        if (this instanceof IPos3D) {
            return transformer.transform((IPos3D)this);
        }
        return null;
    }

    public R add(ForgeDirection dir) {
        return (R)((Object)((AbstractPos)this.add(dir.offsetX, dir.offsetY, dir.offsetZ)));
    }

    public R add(EnumFacing face) {
        return (R)((Object)((AbstractPos)this.add(face.func_82601_c(), face.func_96559_d(), face.func_82599_e())));
    }

    public R add(Vec3 vec) {
        return (R)((Object)((AbstractPos)this.add(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c)));
    }

    public R sub(ForgeDirection dir) {
        return (R)((Object)((AbstractPos)this.sub(dir.offsetX, dir.offsetY, dir.offsetZ)));
    }

    public R sub(EnumFacing face) {
        return (R)((Object)((AbstractPos)this.sub(face.func_82601_c(), face.func_96559_d(), face.func_82599_e())));
    }

    public R sub(Vec3 vec) {
        return (R)((Object)((AbstractPos)this.add(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c)));
    }

    public double distance(Vec3 vec) {
        return this.distance(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public double distance(Entity entity) {
        return this.distance(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public R multiply(ForgeDirection dir) {
        return (R)((Object)((AbstractPos)this.multiply(dir.offsetX, dir.offsetY, dir.offsetZ)));
    }

    public R multiply(EnumFacing face) {
        return (R)((Object)((AbstractPos)this.multiply(face.func_82601_c(), face.func_96559_d(), face.func_82599_e())));
    }

    public R multiply(Vec3 vec) {
        return (R)((Object)((AbstractPos)this.multiply(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c)));
    }

    public R divide(ForgeDirection dir) {
        return (R)((Object)((AbstractPos)this.divide(dir.offsetX, dir.offsetY, dir.offsetZ)));
    }

    public R divide(EnumFacing face) {
        return (R)((Object)((AbstractPos)this.divide(face.func_82601_c(), face.func_96559_d(), face.func_82599_e())));
    }

    public R divide(Vec3 vec) {
        return (R)((Object)((AbstractPos)this.divide(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c)));
    }

    public NBTTagCompound toNBT() {
        return this.writeNBT(new NBTTagCompound());
    }

    public NBTTagCompound toIntNBT() {
        return this.writeIntNBT(new NBTTagCompound());
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74780_a("x", this.x());
        nbt.func_74780_a("y", this.y());
        nbt.func_74780_a("z", this.z());
        return nbt;
    }

    public NBTTagCompound writeIntNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("x", this.xi());
        nbt.func_74768_a("y", this.yi());
        nbt.func_74768_a("z", this.zi());
        return nbt;
    }

    public ByteBuf writeByteBuf(ByteBuf data) {
        data.writeDouble(this.x());
        data.writeDouble(this.y());
        data.writeDouble(this.z());
        return data;
    }

    public MovingObjectPosition rayTrace(World world, IPos3D dir, double dist) {
        return this.rayTrace(world, new Pos(this.x() + dir.x() * dist, this.y() + dir.y() * dist, this.z() + dir.z() * dist));
    }

    public MovingObjectPosition rayTrace(World world, IPos3D end) {
        MovingObjectPosition block = this.rayTraceBlocks(world, end);
        MovingObjectPosition entity = this.rayTraceEntities(world, end);
        if (block == null) {
            return entity;
        }
        if (entity == null) {
            return block;
        }
        Pos pos = new Pos(block.field_72307_f);
        Pos pos2 = new Pos(entity.field_72307_f);
        if (this.distance(pos) < this.distance(pos2)) {
            return block;
        }
        return entity;
    }

    public MovingObjectPosition rayTraceBlocks(World world, IPos3D end) {
        return world.func_72933_a(this.toVec3(), Vec3.func_72443_a((double)end.x(), (double)end.y(), (double)end.z()));
    }

    public MovingObjectPosition rayTraceEntities(World world, IPos3D end) {
        MovingObjectPosition closestEntityMOP = null;
        double closetDistance = 0.0;
        double checkDistance = this.distance(end);
        AxisAlignedBB scanRegion = AxisAlignedBB.func_72330_a((double)(-checkDistance), (double)(-checkDistance), (double)(-checkDistance), (double)checkDistance, (double)checkDistance, (double)checkDistance).func_72317_d(this.x(), this.y(), this.z());
        List checkEntities = world.func_72872_a(Entity.class, scanRegion);
        for (Object obj : checkEntities) {
            float border;
            AxisAlignedBB bounds;
            MovingObjectPosition hit;
            Entity entity = (Entity)obj;
            if (entity == null || !entity.func_70067_L() || entity.field_70121_D == null || (hit = (bounds = entity.field_70121_D.func_72314_b((double)(border = entity.func_70111_Y()), (double)border, (double)border)).func_72327_a(this.toVec3(), Vec3.func_72443_a((double)end.x(), (double)end.y(), (double)end.z()))) == null) continue;
            if (bounds.func_72318_a(this.toVec3())) {
                if (!(0.0 < closetDistance) && closetDistance != 0.0) continue;
                closestEntityMOP = new MovingObjectPosition(entity);
                closestEntityMOP.field_72307_f = hit.field_72307_f;
                closetDistance = 0.0;
                continue;
            }
            double dist = this.distance(new Pos(hit.field_72307_f));
            if (!(dist < closetDistance) && closetDistance != 0.0) continue;
            closestEntityMOP = new MovingObjectPosition(entity);
            closestEntityMOP.field_72307_f = hit.field_72307_f;
            closetDistance = dist;
        }
        return closestEntityMOP;
    }

    public boolean setBlock(World world, Block block) {
        return this.setBlock(world, block, 0);
    }

    public boolean setBlock(World world, Block block, int metadata) {
        return this.setBlock(world, block, metadata, 3);
    }

    public boolean setBlock(World world, Block block, int metadata, int notify) {
        if (world != null && block != null) {
            return world.func_147465_d(this.xi(), this.yi(), this.zi(), block, metadata, notify);
        }
        return false;
    }

    public boolean setBlockToAir(World world) {
        return world.func_147468_f(this.xi(), this.yi(), this.zi());
    }

    public boolean isAirBlock(World world) {
        return world.func_147437_c(this.xi(), this.yi(), this.zi());
    }

    public boolean isBlockFreezable(World world) {
        return world.func_72884_u(this.xi(), this.yi(), this.zi());
    }

    public boolean isReplaceable(World world) {
        Block block = this.getBlock((IBlockAccess)world);
        return block == null || block == Blocks.field_150350_a || block.isAir((IBlockAccess)world, this.xi(), this.yi(), this.zi()) || block.isReplaceable((IBlockAccess)world, this.xi(), this.yi(), this.zi());
    }

    public boolean canSeeSky(World world) {
        return world.func_72937_j(this.xi(), this.yi(), this.zi());
    }

    public boolean isBlockEqual(World world, Block block) {
        Block b = this.getBlock((IBlockAccess)world);
        return b != null && b == block;
    }

    public Block getBlock(IBlockAccess world) {
        if (world != null) {
            return world.func_147439_a(this.xi(), this.yi(), this.zi());
        }
        return null;
    }

    public int getBlockMetadata(IBlockAccess world) {
        if (world != null) {
            return world.func_72805_g(this.xi(), this.yi(), this.zi());
        }
        return 0;
    }

    public TileEntity getTileEntity(IBlockAccess world) {
        if (world != null) {
            return world.func_147438_o(this.xi(), this.yi(), this.zi());
        }
        return null;
    }

    public float getHardness(World world) {
        Block block = this.getBlock((IBlockAccess)world);
        if (block != null) {
            return block.func_149712_f(world, this.xi(), this.yi(), this.zi());
        }
        return 0.0f;
    }

    public float getResistance(Entity cause) {
        return this.getResistance(cause.field_70170_p, cause, this.x(), this.y(), this.z());
    }

    public float getResistanceToEntity(Entity cause) {
        return this.getBlock((IBlockAccess)cause.field_70170_p).func_149638_a(cause);
    }

    public float getResistanceToEntity(World world, Entity cause) {
        return this.getBlock((IBlockAccess)world).func_149638_a(cause);
    }

    public float getResistance(World world, Entity cause) {
        return this.getResistance(world, cause, cause.field_70165_t, cause.field_70163_u, cause.field_70161_v);
    }

    public float getResistance(World world, Entity cause, double xx, double yy, double zz) {
        return this.getBlock((IBlockAccess)world).getExplosionResistance(cause, world, this.xi(), this.yi(), this.zi(), xx, yy, zz);
    }

    public boolean isAboveBedrock() {
        return this.y() > 0.0;
    }

    public boolean isInsideMap() {
        return this.isAboveBedrock() && this.y() < 255.0;
    }

    public void markForUpdate(World world) {
        world.func_147471_g(this.xi(), this.yi(), this.zi());
    }

    public double func_82615_a() {
        return this.x();
    }

    public double func_82617_b() {
        return this.y();
    }

    public double func_82616_c() {
        return this.z();
    }
}

