/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.transform.rotation;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.jlib.data.vector.ITransform;
import com.builtbroken.mc.lib.transform.vector.Pos;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.Cloneable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u0001\u0003\u0001=\u0011!\"U;bi\u0016\u0014h.[8o\u0015\t\u0019A!\u0001\u0005s_R\fG/[8o\u0015\t)a!A\u0005ue\u0006t7OZ8s[*\u0011q\u0001C\u0001\u0004Y&\u0014'BA\u0005\u000b\u0003\ti7M\u0003\u0002\f\u0019\u0005Y!-^5mi\n\u0014xn[3o\u0015\u0005i\u0011aA2p[\u000e\u00011\u0003\u0002\u0001\u00111y\u0001\"!\u0005\f\u000e\u0003IQ!a\u0005\u000b\u0002\t1\fgn\u001a\u0006\u0002+\u0005!!.\u0019<b\u0013\t9\"C\u0001\u0004PE*,7\r\u001e\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\n\u00072|g.Z1cY\u0016\u0004\"a\b\u0014\u000e\u0003\u0001R!!\t\u0012\u0002\rY,7\r^8s\u0015\t\u0019C%\u0001\u0003eCR\f'BA\u0013\u000b\u0003\u0011QG.\u001b2\n\u0005\u001d\u0002#AC%Ue\u0006t7OZ8s[\")\u0011\u0006\u0001C\u0001U\u00051A(\u001b8jiz\"\u0012a\u000b\t\u0003Y\u0001i\u0011A\u0001\u0005\b]\u0001\u0001\r\u0011\"\u00010\u0003\u0005AX#\u0001\u0019\u0011\u0005e\t\u0014B\u0001\u001a\u001b\u0005\u0019!u.\u001e2mK\"9A\u0007\u0001a\u0001\n\u0003)\u0014!\u0002=`I\u0015\fHC\u0001\u001c:!\tIr'\u0003\u000295\t!QK\\5u\u0011\u001dQ4'!AA\u0002A\n1\u0001\u001f\u00132\u0011\u0019a\u0004\u0001)Q\u0005a\u0005\u0011\u0001\u0010\t\u0005\b}\u0001\u0001\r\u0011\"\u00010\u0003\u0005I\bb\u0002!\u0001\u0001\u0004%\t!Q\u0001\u0006s~#S-\u001d\u000b\u0003m\tCqAO \u0002\u0002\u0003\u0007\u0001\u0007\u0003\u0004E\u0001\u0001\u0006K\u0001M\u0001\u0003s\u0002BqA\u0012\u0001A\u0002\u0013\u0005q&A\u0001{\u0011\u001dA\u0005\u00011A\u0005\u0002%\u000bQA_0%KF$\"A\u000e&\t\u000fi:\u0015\u0011!a\u0001a!1A\n\u0001Q!\nA\n!A\u001f\u0011\t\u000f9\u0003\u0001\u0019!C\u0001_\u0005\tq\u000fC\u0004Q\u0001\u0001\u0007I\u0011A)\u0002\u000b]|F%Z9\u0015\u0005Y\u0012\u0006b\u0002\u001eP\u0003\u0003\u0005\r\u0001\r\u0005\u0007)\u0002\u0001\u000b\u0015\u0002\u0019\u0002\u0005]\u0004\u0003\"B\u0015\u0001\t\u00031FCA\u0016X\u0011\u0015AV\u000b1\u0001,\u0003)\tV/\u0019;fe:LwN\u001c\u0005\u0006S\u0001!\tA\u0017\u000b\u0004Wmk\u0006\"\u0002/Z\u0001\u0004\u0001\u0014!B1oO2,\u0007\"\u00020Z\u0001\u0004y\u0016\u0001B1ySN\u0004\"a\b1\n\u0005\u0005\u0004#AB%Q_N\u001cD\tC\u0003*\u0001\u0011\u00051\rF\u0003,I\u001aD'\u000eC\u0003fE\u0002\u0007\u0001'A\u0001e\u0011\u00159'\r1\u00011\u0003\t!\u0017\u0007C\u0003jE\u0002\u0007\u0001'\u0001\u0002ee!)1N\u0019a\u0001a\u0005\u0011Am\r\u0005\u0006[\u0002!\tA\\\u0001\u0004g\u0016$HCA\u0016p\u0011\u0015\u0001H\u000e1\u0001,\u0003\u0005\t\b\"B7\u0001\t\u0003\u0011H#B\u0016tiV4\b\"B3r\u0001\u0004\u0001\u0004\"B4r\u0001\u0004\u0001\u0004\"B5r\u0001\u0004\u0001\u0004\"B6r\u0001\u0004\u0001\u0004\"\u0002=\u0001\t\u0003I\u0018!D:fi\u0006\u0013x.\u001e8e\u0003bL7\u000f\u0006\u0004,urt\u0018\u0011\u0001\u0005\u0006w^\u0004\r\u0001M\u0001\u0003CbDQ!`<A\u0002A\n!!Y=\t\u000b}<\b\u0019\u0001\u0019\u0002\u0005\u0005T\bBBA\u0002o\u0002\u0007\u0001'A\u0007pe&<\u0017N\\1m\u0003:<G.\u001a\u0005\u0007q\u0002!\t!a\u0002\u0015\u000b-\nI!!\u0006\t\u000fy\u000b)\u00011\u0001\u0002\fA!\u0011QBA\t\u001b\t\tyA\u0003\u0002\"\t%!\u00111CA\b\u0005\r\u0001vn\u001d\u0005\u00079\u0006\u0015\u0001\u0019\u0001\u0019\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c\u0005AQ.\u001e7uSBd\u0017\u0010F\u0002,\u0003;Aa\u0001WA\f\u0001\u0004Y\u0003bBA\u0011\u0001\u0011\u0005\u00111E\u0001\u000ee&<\u0007\u000e^'vYRL\u0007\u000f\\=\u0015\u0007-\n)\u0003\u0003\u0004Y\u0003?\u0001\ra\u000b\u0005\u0007\u0003S\u0001A\u0011A\u0018\u0002\u00135\fwM\\5uk\u0012,\u0007bBA\u0017\u0001\u0011\u0005\u0011qF\u0001\n]>\u0014X.\u00197ju\u0016,\u0012a\u000b\u0005\u0007\u0003g\u0001A\u0011\t\u0016\u0002\u000b\rdwN\\3\t\r\u0015\u0001A\u0011IA\u001c)\u0011\tY!!\u000f\t\r\u0005\n)\u00041\u0001`\u0011\u001d\ti\u0004\u0001C!\u0003\u007f\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002J9\u0019\u0011$!\u0012\n\u0007\u0005\u001d#$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0017\niE\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000fR\u0002")
public class Quaternion
implements Cloneable,
ITransform {
    private double x = 1.0;
    private double y = 0.0;
    private double z = 0.0;
    private double w = 0.0;

    public double x() {
        return this.x;
    }

    public void x_$eq(double x$1) {
        this.x = x$1;
    }

    public double y() {
        return this.y;
    }

    public void y_$eq(double x$1) {
        this.y = x$1;
    }

    public double z() {
        return this.z;
    }

    public void z_$eq(double x$1) {
        this.z = x$1;
    }

    public double w() {
        return this.w;
    }

    public void w_$eq(double x$1) {
        this.w = x$1;
    }

    public Quaternion set(Quaternion q) {
        this.x_$eq(q.x());
        this.y_$eq(q.y());
        this.z_$eq(q.z());
        this.w_$eq(q.w());
        return this;
    }

    public Quaternion set(double d, double d1, double d2, double d3) {
        this.x_$eq(d1);
        this.y_$eq(d2);
        this.z_$eq(d3);
        this.w_$eq(d);
        return this;
    }

    public Quaternion setAroundAxis(double ax, double ay, double az, double originalAngle) {
        double angle = originalAngle;
        double d4 = Math.sin(angle *= 0.5);
        return this.set(Math.cos(angle), ax * d4, ay * d4, az * d4);
    }

    public Quaternion setAroundAxis(Pos axis, double angle) {
        return this.setAroundAxis(axis.x(), axis.y(), axis.z(), angle);
    }

    public Quaternion multiply(Quaternion Quaternion2) {
        double d = this.w() * Quaternion2.w() - this.x() * Quaternion2.x() - this.y() * Quaternion2.y() - this.z() * Quaternion2.z();
        double d1 = this.w() * Quaternion2.x() + this.x() * Quaternion2.w() - this.y() * Quaternion2.z() + this.z() * Quaternion2.y();
        double d2 = this.w() * Quaternion2.y() + this.x() * Quaternion2.z() + this.y() * Quaternion2.w() - this.z() * Quaternion2.x();
        double d3 = this.w() * Quaternion2.z() - this.x() * Quaternion2.y() + this.y() * Quaternion2.x() + this.z() * Quaternion2.w();
        this.w_$eq(d);
        this.x_$eq(d1);
        this.y_$eq(d2);
        this.z_$eq(d3);
        return this;
    }

    public Quaternion rightMultiply(Quaternion Quaternion2) {
        double d = this.w() * Quaternion2.w() - this.x() * Quaternion2.x() - this.y() * Quaternion2.y() - this.z() * Quaternion2.z();
        double d1 = this.w() * Quaternion2.x() + this.x() * Quaternion2.w() + this.y() * Quaternion2.z() - this.z() * Quaternion2.y();
        double d2 = this.w() * Quaternion2.y() - this.x() * Quaternion2.z() + this.y() * Quaternion2.w() + this.z() * Quaternion2.x();
        double d3 = this.w() * Quaternion2.z() + this.x() * Quaternion2.y() - this.y() * Quaternion2.x() + this.z() * Quaternion2.w();
        this.w_$eq(d);
        this.x_$eq(d1);
        this.y_$eq(d2);
        this.z_$eq(d3);
        return this;
    }

    public double magnitude() {
        return Math.sqrt(this.x() * this.x() + this.y() * this.y() + this.z() * this.z() + this.w() * this.w());
    }

    public Quaternion normalize() {
        double d = this.magnitude();
        if (d != 0.0) {
            d = 1.0 / d;
            this.x_$eq(this.x() * d);
            this.y_$eq(this.y() * d);
            this.z_$eq(this.z() * d);
            this.w_$eq(this.w() * d);
        }
        return this;
    }

    public Quaternion clone() {
        return new Quaternion(this);
    }

    public Pos transform(IPos3D vector) {
        double d = -this.x() * vector.x() - this.y() * vector.y() - this.z() * vector.z();
        double d1 = this.w() * vector.x() + this.y() * vector.z() - this.z() * vector.y();
        double d2 = this.w() * vector.y() - this.x() * vector.z() + this.z() * vector.x();
        double d3 = this.w() * vector.z() + this.x() * vector.y() - this.y() * vector.x();
        return new Pos(d1 * this.w() - d * this.x() - d2 * this.z() + d3 * this.y(), d2 * this.w() - d * this.y() + d1 * this.z() - d3 * this.x(), d3 * this.w() - d * this.z() - d1 * this.y() + d2 * this.x());
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return new StringBuilder().append((Object)"Quaternion[").append((Object)new BigDecimal(this.w(), cont)).append((Object)", ").append((Object)new BigDecimal(this.x(), cont)).append((Object)", ").append((Object)new BigDecimal(this.y(), cont)).append((Object)", ").append((Object)new BigDecimal(this.z(), cont)).append((Object)"]").toString();
    }

    public Quaternion() {
    }

    public Quaternion(Quaternion Quaternion2) {
        this();
        this.x_$eq(Quaternion2.x());
        this.y_$eq(Quaternion2.y());
        this.z_$eq(Quaternion2.z());
        this.w_$eq(Quaternion2.w());
    }

    public Quaternion(double angle, IPos3D axis) {
        this();
        this.setAroundAxis(axis.x(), axis.y(), axis.z(), angle);
    }

    public Quaternion(double d, double d1, double d2, double d3) {
        this();
        this.x_$eq(d1);
        this.y_$eq(d2);
        this.z_$eq(d3);
        this.w_$eq(d);
    }
}

