/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.transform.rotation;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.jlib.data.vector.ITransform;
import com.builtbroken.jlib.helpers.MathHelper;
import com.builtbroken.mc.core.network.IByteBufWriter;
import com.builtbroken.mc.lib.transform.rotation.AngleAxis;
import com.builtbroken.mc.lib.transform.rotation.Quaternion;
import com.builtbroken.mc.lib.transform.vector.Pos;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class EulerAngle
implements Cloneable,
ITransform,
IByteBufWriter {
    protected double yaw = 0.0;
    protected double pitch = 0.0;
    protected double roll = 0.0;

    public EulerAngle(double yaw, double pitch, double roll) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
    }

    public EulerAngle(double yaw, double pitch) {
        this(yaw, pitch, 0.0);
    }

    public EulerAngle(NBTTagCompound tag) {
        this.readFromNBT(tag);
    }

    public EulerAngle(ByteBuf data) {
        this.readByteBuf(data);
    }

    public EulerAngle(ForgeDirection direction) {
        switch (direction) {
            case DOWN: {
                this.pitch = -90.0;
                break;
            }
            case UP: {
                this.pitch = 90.0;
                break;
            }
            case NORTH: {
                this.yaw = 0.0;
                break;
            }
            case SOUTH: {
                this.yaw = 180.0;
                break;
            }
            case EAST: {
                this.yaw = -90.0;
                break;
            }
            case WEST: {
                this.yaw = 90.0;
            }
        }
    }

    public void set(double yaw, double pitch, double roll) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
    }

    public void set(int index, double value) {
        if (index == 0) {
            this.yaw = value;
        }
        if (index == 1) {
            this.pitch = value;
        }
        if (index == 2) {
            this.roll = value;
        }
    }

    public EulerAngle set(EulerAngle other) {
        this.yaw = other.yaw;
        this.pitch = other.pitch;
        this.roll = other.roll;
        return this;
    }

    public EulerAngle add(double v) {
        this.yaw += v;
        this.pitch += v;
        this.roll += v;
        return this;
    }

    public EulerAngle add(EulerAngle other) {
        this.yaw += other.yaw;
        this.pitch += other.pitch;
        this.roll += other.roll;
        return this;
    }

    public EulerAngle multiply(double v) {
        this.yaw *= v;
        this.pitch *= v;
        this.roll *= v;
        return this;
    }

    public EulerAngle multiply(float v) {
        this.yaw *= (double)v;
        this.pitch *= (double)v;
        this.roll *= (double)v;
        return this;
    }

    public EulerAngle multiply(EulerAngle other) {
        this.yaw *= other.yaw;
        this.pitch *= other.pitch;
        this.roll *= other.roll;
        return this;
    }

    public EulerAngle reciprocal() {
        this.yaw = 1.0 / this.yaw;
        this.pitch = 1.0 / this.pitch;
        this.roll = 1.0 / this.roll;
        return this;
    }

    public EulerAngle ceil() {
        this.yaw = Math.ceil(this.yaw);
        this.pitch = Math.ceil(this.pitch);
        this.roll = Math.ceil(this.roll);
        return this;
    }

    public EulerAngle floor() {
        this.yaw = Math.floor(this.yaw);
        this.pitch = Math.floor(this.pitch);
        this.roll = Math.floor(this.roll);
        return this;
    }

    public EulerAngle round() {
        this.yaw = Math.round(this.yaw);
        this.pitch = Math.round(this.pitch);
        this.roll = Math.round(this.roll);
        return this;
    }

    public EulerAngle max(EulerAngle other) {
        return new EulerAngle(Math.max(this.yaw, other.yaw), Math.max(this.pitch, other.pitch), Math.max(this.roll, other.roll));
    }

    public EulerAngle min(EulerAngle other) {
        return new EulerAngle(Math.min(this.yaw, other.yaw), Math.min(this.pitch, other.pitch), Math.min(this.roll, other.roll));
    }

    public EulerAngle absoluteDifference(EulerAngle other) {
        return new EulerAngle(Math.abs(this.yaw - other.yaw), Math.abs(this.pitch - other.pitch), Math.abs(this.roll - other.roll));
    }

    public boolean isWithin(EulerAngle other, double error) {
        return other != null && this.isYawWithin(other.yaw, error) && this.isPitchWithin(other.pitch, error) && this.isRollWithin(other.roll, error);
    }

    public boolean isYawWithin(double yaw, double error) {
        double delta = this.distanceYaw(yaw);
        return delta <= error;
    }

    public boolean isPitchWithin(double pitch, double error) {
        double delta = this.distancePitch(pitch);
        return delta <= error;
    }

    public boolean isRollWithin(double roll, double error) {
        double delta = this.distanceRoll(roll);
        return delta <= error;
    }

    public final double distanceYaw(double yaw) {
        return Math.abs(this.yaw - yaw);
    }

    public final double distancePitch(double pitch) {
        return Math.abs(this.pitch - pitch);
    }

    public final double distanceRoll(double roll) {
        return Math.abs(this.roll - roll);
    }

    public IPos3D transform(IPos3D vector) {
        return new Pos(vector).transform(this.toQuaternion());
    }

    @Deprecated
    public IPos3D toVector() {
        return new Pos(-Math.sin(this.yaw) * Math.cos(this.pitch), Math.sin(this.pitch), -Math.cos(this.yaw) * Math.cos(this.pitch));
    }

    public Pos toPos() {
        return new Pos(-Math.sin(this.yaw) * Math.cos(this.pitch), Math.sin(this.pitch), -Math.cos(this.yaw) * Math.cos(this.pitch));
    }

    public AngleAxis toAngleAxis() {
        double c1 = Math.cos(this.yaw / 2.0);
        double s1 = Math.sin(this.yaw / 2.0);
        double c2 = Math.cos(this.pitch / 2.0);
        double s2 = Math.sin(this.pitch / 2.0);
        double c3 = Math.cos(this.roll / 2.0);
        double s3 = Math.sin(this.roll / 2.0);
        double c1c2 = c1 * c2;
        double s1s2 = s1 * s2;
        double w = c1c2 * c3 - s1s2 * s3;
        double x = c1c2 * s3 + s1s2 * c3;
        double y = s1 * c2 * c3 + c1 * s2 * s3;
        double z = c1 * s2 * c3 - s1 * c2 * s3;
        double angle = 2.0 * Math.acos(w);
        Pos axis = new Pos(x, y, z);
        axis = axis.magnitudeSquared() < 0.001 ? new Pos(0.0, 0.0, -1.0) : (Pos)axis.normalize();
        return new AngleAxis(angle, axis);
    }

    public Quaternion toQuaternion() {
        double c1 = Math.cos(Math.toRadians(this.yaw) / 2.0);
        double s1 = Math.sin(Math.toRadians(this.yaw) / 2.0);
        double c2 = Math.cos(Math.toRadians(this.pitch) / 2.0);
        double s2 = Math.sin(Math.toRadians(this.pitch) / 2.0);
        double c3 = Math.cos(Math.toRadians(this.roll) / 2.0);
        double s3 = Math.sin(Math.toRadians(this.roll) / 2.0);
        double c1c2 = c1 * c2;
        double s1s2 = s1 * s2;
        double w = c1c2 * c3 - s1s2 * s3;
        double x = c1c2 * s3 + s1s2 * c3;
        double y = s1 * c2 * c3 + c1 * s2 * s3;
        double z = c1 * s2 * c3 - s1 * c2 * s3;
        return new Quaternion(w, x, y, z);
    }

    public double[] toArray() {
        return new double[]{this.yaw, this.pitch, this.roll};
    }

    public EulerAngle clone() {
        return new EulerAngle(this.yaw, this.pitch, this.roll);
    }

    public String toString() {
        return "EulerAngle[" + this.yaw + "," + this.pitch + "," + this.roll + "]";
    }

    @Deprecated
    public void writeByteBuf(ByteBuf data) {
        data.writeDouble(this.yaw);
        data.writeDouble(this.pitch);
        data.writeDouble(this.roll);
    }

    @Override
    public ByteBuf writeBytes(ByteBuf data) {
        data.writeDouble(this.yaw);
        data.writeDouble(this.pitch);
        data.writeDouble(this.roll);
        return data;
    }

    public void readByteBuf(ByteBuf data) {
        this.yaw = data.readDouble();
        this.pitch = data.readDouble();
        this.roll = data.readDouble();
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74780_a("yaw", this.yaw);
        nbt.func_74780_a("pitch", this.pitch);
        nbt.func_74780_a("roll", this.roll);
        return nbt;
    }

    public NBTTagCompound toNBT() {
        return this.writeNBT(new NBTTagCompound());
    }

    public EulerAngle readFromNBT(NBTTagCompound nbt) {
        this.yaw = nbt.func_74769_h("yaw");
        this.pitch = nbt.func_74769_h("pitch");
        this.roll = nbt.func_74769_h("roll");
        return this;
    }

    public EulerAngle clampTo360() {
        this.yaw = this.clampAngleTo360(this.yaw);
        this.pitch = this.clampAngleTo360(this.pitch);
        this.roll = this.clampAngleTo360(this.roll);
        return this;
    }

    public EulerAngle lerp(EulerAngle aim, double deltaTime) {
        this.yaw = MathHelper.lerp((double)this.yaw, (double)aim.yaw, (double)deltaTime);
        this.pitch = MathHelper.lerp((double)this.pitch, (double)aim.pitch, (double)deltaTime);
        this.roll = MathHelper.lerp((double)this.roll, (double)aim.roll, (double)deltaTime);
        return this;
    }

    public EulerAngle moveTowards(EulerAngle aim, double speed, double deltaTime) {
        this.moveYaw(aim.yaw, speed, deltaTime);
        this.movePitch(aim.pitch, speed, deltaTime);
        this.moveRoll(aim.roll, speed, deltaTime);
        return this;
    }

    public EulerAngle moveYaw(double desiredYaw, double speed, double deltaTime) {
        double d2;
        double delta = Math.abs(desiredYaw - this.yaw);
        if (delta < speed || speed < 0.0) {
            this.yaw = desiredYaw;
            return this;
        }
        double d = Math.abs(desiredYaw - (this.yaw + speed));
        this.yaw = d < (d2 = Math.abs(desiredYaw - (this.yaw - speed))) ? MathHelper.lerp((double)this.yaw, (double)(this.yaw + speed), (double)deltaTime) : MathHelper.lerp((double)this.yaw, (double)(this.yaw - speed), (double)deltaTime);
        return this;
    }

    public EulerAngle movePitch(double desiredPitch, double speed, double deltaTime) {
        double d2;
        double delta = Math.abs(desiredPitch - this.pitch);
        if (delta < speed || speed < 0.0) {
            this.pitch = desiredPitch;
            return this;
        }
        double d = Math.abs(desiredPitch - (this.pitch + speed));
        this.pitch = d < (d2 = Math.abs(desiredPitch - (this.pitch - speed))) ? MathHelper.lerp((double)this.pitch, (double)(this.pitch + speed), (double)deltaTime) : MathHelper.lerp((double)this.pitch, (double)(this.pitch - speed), (double)deltaTime);
        return this;
    }

    public EulerAngle moveRoll(double desiredRoll, double speed, double deltaTime) {
        double d2;
        double delta = Math.abs(desiredRoll - this.roll);
        if (delta < speed || speed < 0.0) {
            this.roll = desiredRoll;
            return this;
        }
        double d = Math.abs(desiredRoll - (this.roll + speed));
        this.roll = d < (d2 = Math.abs(desiredRoll - (this.roll - speed))) ? MathHelper.lerp((double)this.roll, (double)(this.roll + speed), (double)deltaTime) : MathHelper.lerp((double)this.roll, (double)(this.roll - speed), (double)deltaTime);
        return this;
    }

    private final double clampAngleTo360(double value) {
        return this.clampAngle(value, -360.0, 360.0);
    }

    private final double clampAngle(double value, double min, double max) {
        double result;
        for (result = value % 360.0; result < min; result += 360.0) {
        }
        while (result > max) {
            result -= 360.0;
        }
        return result;
    }

    public double yaw() {
        return this.yaw;
    }

    public double pitch() {
        return this.pitch;
    }

    public double roll() {
        return this.roll;
    }

    public boolean isZero() {
        return this.isYawZero() && this.isPitchZero() && this.isRollZero();
    }

    public boolean isYawZero() {
        return this.yaw <= 1.0E-5 && this.yaw >= -1.0E-5;
    }

    public boolean isPitchZero() {
        return this.pitch <= 1.0E-5 && this.pitch >= -1.0E-5;
    }

    public boolean isRollZero() {
        return this.roll <= 1.0E-5 && this.roll >= -1.0E-5;
    }

    @Deprecated
    public void yaw_$eq(double v) {
        this.yaw = v;
    }

    @Deprecated
    public void pitch_$eq(double v) {
        this.pitch = v;
    }

    @Deprecated
    public void roll_$eq(double v) {
        this.roll = v;
    }

    public void setYaw(double v) {
        this.yaw = v;
    }

    public void setPitch(double v) {
        this.pitch = v;
    }

    public void setRoll(double v) {
        this.roll = v;
    }
}

