/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.render;

import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.lib.world.WorldUtility;
import cpw.mods.fml.client.FMLClientHandler;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderUtility {
    public static final ResourceLocation PARTICLE_RESOURCE = new ResourceLocation("textures/particle/particles.png");
    public static final HashMap<String, ResourceLocation> resourceCahce = new HashMap();
    public static final HashMap<String, IIcon> loadedIconMap = new HashMap();
    public static RenderBlocks renderBlocks = new RenderBlocks();

    public static ResourceLocation getResource(String domain, String name) {
        String cacheName = domain + ":" + name;
        if (!resourceCahce.containsKey(cacheName)) {
            resourceCahce.put(cacheName, new ResourceLocation(domain, name));
        }
        return resourceCahce.get(cacheName);
    }

    public static void setTerrainTexture() {
        RenderUtility.setSpriteTexture(0);
    }

    public static void setSpriteTexture(ItemStack itemStack) {
        RenderUtility.setSpriteTexture(itemStack.func_94608_d());
    }

    public static void setSpriteTexture(int sprite) {
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(RenderUtility.getSpriteTexture(sprite));
    }

    public static ResourceLocation getSpriteTexture(int sprite) {
        return FMLClientHandler.instance().getClient().field_71446_o.func_130087_a(sprite);
    }

    public static void registerIcon(String name, TextureMap textureMap) {
        loadedIconMap.put(name, textureMap.func_94245_a(name));
    }

    public static IIcon getIcon(String name) {
        return loadedIconMap.get(name);
    }

    public static void enableBlending() {
        GL11.glShadeModel((int)7425);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }

    public static void disableBlending() {
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)2848);
        GL11.glDisable((int)2881);
        GL11.glDisable((int)3042);
    }

    public static void enableLighting() {
        RenderHelper.func_74519_b();
    }

    public static void disableLighting() {
        RenderHelper.func_74518_a();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
    }

    public static void disableLightmap() {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    public static void enableLightmap() {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glEnable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    public static void renderNormalBlockAsItem(Block block, int metadata, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        block.func_149683_g();
        renderer.func_147775_a(block);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 0, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 1, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 2, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 3, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 4, metadata));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 5, metadata));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public static void renderFloatingText(String text, Pos position) {
        RenderUtility.renderFloatingText(text, position, 0xFFFFFF);
    }

    public static void renderFloatingText(String text, Pos position, int color) {
        RenderUtility.renderFloatingText(text, position.x(), position.y(), position.z(), color);
    }

    public static void renderFloatingText(String text, double x, double y, double z, int color) {
        RenderManager renderManager = RenderManager.field_78727_a;
        FontRenderer fontRenderer = renderManager.func_78716_a();
        float scale = 0.027f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-scale), (float)(-scale), (float)scale);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.field_78398_a;
        int yOffset = 0;
        GL11.glDisable((int)3553);
        tessellator.func_78382_b();
        int stringMiddle = fontRenderer.func_78256_a(text) / 2;
        tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 0.5f);
        tessellator.func_78377_a((double)(-stringMiddle - 1), (double)(-1 + yOffset), 0.0);
        tessellator.func_78377_a((double)(-stringMiddle - 1), (double)(8 + yOffset), 0.0);
        tessellator.func_78377_a((double)(stringMiddle + 1), (double)(8 + yOffset), 0.0);
        tessellator.func_78377_a((double)(stringMiddle + 1), (double)(-1 + yOffset), 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        fontRenderer.func_78276_b(text, -fontRenderer.func_78256_a(text) / 2, yOffset, color);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        fontRenderer.func_78276_b(text, -fontRenderer.func_78256_a(text) / 2, yOffset, color);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public static void renderText(String text, int side, float maxScale, double x, double y, double z) {
        RenderUtility.renderText(text, ForgeDirection.getOrientation((int)side), maxScale, x, y, z);
    }

    public static void renderText(String text, ForgeDirection side, float maxScale, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glPolygonOffset((float)-10.0f, (float)-10.0f);
        GL11.glEnable((int)32823);
        float displayWidth = 1.0f;
        float displayHeight = 1.0f;
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glPushMatrix();
        switch (side) {
            case SOUTH: {
                GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                GL11.glTranslatef((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GL11.glTranslatef((float)0.0f, (float)1.0f, (float)1.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glTranslatef((float)1.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
        GL11.glTranslatef((float)(displayWidth / 2.0f), (float)1.0f, (float)(displayHeight / 2.0f));
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        FontRenderer fontRenderer = FMLClientHandler.instance().getClient().field_71466_p;
        int requiredWidth = Math.max(fontRenderer.func_78256_a(text), 1);
        int requiredHeight = fontRenderer.field_78288_b + 2;
        float scaler = 0.8f;
        float scaleX = displayWidth / (float)requiredWidth;
        float scaleY = displayHeight / (float)requiredHeight;
        float scale = Math.min(maxScale, Math.min(scaleX, scaleY) * scaler);
        GL11.glScalef((float)scale, (float)(-scale), (float)scale);
        GL11.glDepthMask((boolean)false);
        int realHeight = (int)Math.floor(displayHeight / scale);
        int realWidth = (int)Math.floor(displayWidth / scale);
        int offsetX = (realWidth - requiredWidth) / 2;
        int offsetY = (realHeight - requiredHeight) / 2;
        GL11.glDisable((int)2896);
        fontRenderer.func_78276_b("\u00a7f" + text, offsetX - realWidth / 2, 1 + offsetY - realHeight / 2, 1);
        GL11.glEnable((int)2896);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)32823);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public static void renderText(String text, float scaler, float maxScale) {
        GL11.glPushMatrix();
        GL11.glPolygonOffset((float)-10.0f, (float)-10.0f);
        GL11.glEnable((int)32823);
        float displayWidth = 1.0f;
        float displayHeight = 1.0f;
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        FontRenderer fontRenderer = FMLClientHandler.instance().getClient().field_71466_p;
        int requiredWidth = Math.max(fontRenderer.func_78256_a(text), 1);
        float scaleX = displayWidth / (float)requiredWidth;
        float scaleY = displayHeight / (float)fontRenderer.field_78288_b;
        float scale = Math.min(maxScale, Math.min(scaleX, scaleY) * scaler);
        GL11.glScalef((float)scale, (float)(-scale), (float)scale);
        GL11.glDepthMask((boolean)false);
        int realHeight = (int)Math.floor(displayHeight / scale);
        int realWidth = (int)Math.floor(displayWidth / scale);
        int offsetX = (realWidth - requiredWidth) / 2;
        int offsetY = (realHeight - fontRenderer.field_78288_b) / 2;
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        fontRenderer.func_78276_b("\u00a7f" + text, offsetX - realWidth / 2, 2 + offsetY - realHeight / 2, 1);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        fontRenderer.func_78276_b("\u00a7f" + text, offsetX - realWidth / 2, 2 + offsetY - realHeight / 2, 1);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)32823);
        GL11.glPopMatrix();
    }

    public static void rotateFacesOnRenderer(ForgeDirection rotation, RenderBlocks renderer, boolean fullRotation) {
        if (fullRotation) {
            switch (rotation) {
                case DOWN: {
                    renderer.field_147871_s = 3;
                    renderer.field_147869_t = 3;
                    renderer.field_147875_q = 3;
                    renderer.field_147873_r = 3;
                    break;
                }
                case EAST: {
                    renderer.field_147867_u = 1;
                    renderer.field_147865_v = 2;
                    renderer.field_147873_r = 1;
                    renderer.field_147875_q = 2;
                    break;
                }
                case NORTH: {
                    renderer.field_147869_t = 2;
                    renderer.field_147871_s = 1;
                    break;
                }
                case SOUTH: {
                    renderer.field_147867_u = 3;
                    renderer.field_147865_v = 3;
                    renderer.field_147869_t = 1;
                    renderer.field_147871_s = 2;
                    break;
                }
                case UNKNOWN: {
                    break;
                }
                case UP: {
                    break;
                }
                case WEST: {
                    renderer.field_147867_u = 2;
                    renderer.field_147865_v = 1;
                    renderer.field_147873_r = 2;
                    renderer.field_147875_q = 1;
                    break;
                }
            }
        } else {
            switch (rotation) {
                case EAST: {
                    renderer.field_147867_u = 1;
                    break;
                }
                case WEST: {
                    renderer.field_147867_u = 2;
                    break;
                }
                case SOUTH: {
                    renderer.field_147867_u = 3;
                    break;
                }
            }
        }
    }

    public static void resetFacesOnRenderer(RenderBlocks renderer) {
        renderer.field_147867_u = 0;
        renderer.field_147865_v = 0;
        renderer.field_147875_q = 0;
        renderer.field_147869_t = 0;
        renderer.field_147871_s = 0;
        renderer.field_147867_u = 0;
        renderer.field_147873_r = 0;
        renderer.field_147842_e = false;
    }

    @Deprecated
    public static void renderInventoryBlock(RenderBlocks renderer, Block block, ForgeDirection rotation) {
        RenderUtility.renderInventoryBlock(renderer, block, rotation, -1);
    }

    @Deprecated
    public static void renderInventoryBlock(RenderBlocks renderer, Block block, ForgeDirection rotation, int colorMultiplier) {
        RenderUtility.renderInventoryBlock(renderer, block, rotation == null ? 0 : rotation.ordinal(), colorMultiplier, null);
    }

    public static void renderInventoryBlock(RenderBlocks renderer, Block block, int meta) {
        RenderUtility.renderInventoryBlock(renderer, block, meta, -1);
    }

    public static void renderInventoryBlock(RenderBlocks renderer, Block block, int meta, int colorMultiplier) {
        RenderUtility.renderInventoryBlock(renderer, block, meta, colorMultiplier, null);
    }

    public static void renderInventoryBlock(RenderBlocks renderer, Block block, int metadata, int colorMultiplier, Set<ForgeDirection> enabledSides) {
        Tessellator tessellator = Tessellator.field_78398_a;
        block.func_149683_g();
        renderer.func_147775_a(block);
        if (colorMultiplier > -1) {
            float r = (float)(colorMultiplier >> 16 & 0xFF) / 255.0f;
            float g = (float)(colorMultiplier >> 8 & 0xFF) / 255.0f;
            float b = (float)(colorMultiplier & 0xFF) / 255.0f;
            GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        }
        GL11.glPushMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        if (enabledSides == null || enabledSides.contains(ForgeDirection.DOWN)) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            renderer.func_147768_a(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 0, metadata));
            tessellator.func_78381_a();
        }
        if (enabledSides == null || enabledSides.contains(ForgeDirection.UP)) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            renderer.func_147806_b(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 1, metadata));
            tessellator.func_78381_a();
        }
        if (enabledSides == null || enabledSides.contains(ForgeDirection.SOUTH)) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            renderer.func_147761_c(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 2, metadata));
            tessellator.func_78381_a();
        }
        if (enabledSides == null || enabledSides.contains(ForgeDirection.NORTH)) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            renderer.func_147734_d(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 3, metadata));
            tessellator.func_78381_a();
        }
        if (enabledSides == null || enabledSides.contains(ForgeDirection.WEST)) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderer.func_147798_e(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 4, metadata));
            tessellator.func_78381_a();
        }
        if (enabledSides == null || enabledSides.contains(ForgeDirection.EAST)) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            renderer.func_147764_f(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 5, metadata));
            tessellator.func_78381_a();
        }
        GL11.glPopMatrix();
    }

    public static void renderCube(double x1, double y1, double z1, double x2, double y2, double z2, Block block) {
        RenderUtility.renderCube(x1, y1, z1, x2, y2, z2, block, null);
    }

    public static void renderCube(double x1, double y1, double z1, double x2, double y2, double z2, Block block, IIcon overrideTexture) {
        RenderUtility.renderCube(x1, y1, z1, x2, y2, z2, block, overrideTexture, 0);
    }

    public static void renderCube(double x1, double y1, double z1, double x2, double y2, double z2, Block block, IIcon overrideTexture, int meta) {
        GL11.glPushMatrix();
        Tessellator t = Tessellator.field_78398_a;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderBlocks.func_147782_a(x1, y1, z1, x2, y2, z2);
        t.func_78382_b();
        IIcon useTexture = overrideTexture != null ? overrideTexture : block.func_149691_a(0, meta);
        t.func_78375_b(0.0f, -1.0f, 0.0f);
        renderBlocks.func_147768_a(block, 0.0, 0.0, 0.0, useTexture);
        useTexture = overrideTexture != null ? overrideTexture : block.func_149691_a(1, meta);
        t.func_78375_b(0.0f, 1.0f, 0.0f);
        renderBlocks.func_147806_b(block, 0.0, 0.0, 0.0, useTexture);
        useTexture = overrideTexture != null ? overrideTexture : block.func_149691_a(2, meta);
        t.func_78375_b(0.0f, 0.0f, -1.0f);
        renderBlocks.func_147761_c(block, 0.0, 0.0, 0.0, useTexture);
        useTexture = overrideTexture != null ? overrideTexture : block.func_149691_a(3, meta);
        t.func_78375_b(0.0f, 0.0f, 1.0f);
        renderBlocks.func_147734_d(block, 0.0, 0.0, 0.0, useTexture);
        useTexture = overrideTexture != null ? overrideTexture : block.func_149691_a(4, meta);
        t.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderBlocks.func_147798_e(block, 0.0, 0.0, 0.0, useTexture);
        useTexture = overrideTexture != null ? overrideTexture : block.func_149691_a(5, meta);
        t.func_78375_b(1.0f, 0.0f, 0.0f);
        renderBlocks.func_147764_f(block, 0.0, 0.0, 0.0, useTexture);
        t.func_78381_a();
        GL11.glPopMatrix();
    }

    public static void rotateFaceBlockToSide(ForgeDirection placementSide) {
        switch (placementSide) {
            case DOWN: {
                GL11.glTranslatef((float)0.0f, (float)-0.45f, (float)0.0f);
                break;
            }
            case UP: {
                GL11.glTranslatef((float)0.0f, (float)0.45f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.45f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.45f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glTranslatef((float)-0.45f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GL11.glTranslatef((float)0.45f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    public static void rotateFaceToSideNoTranslate(ForgeDirection placementSide) {
        switch (placementSide) {
            case DOWN: {
                break;
            }
            case UP: {
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    public static void rotateFaceBlockToSideOutwards(ForgeDirection placementSide) {
        switch (placementSide) {
            case DOWN: {
                GL11.glTranslatef((float)0.0f, (float)0.45f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case UP: {
                GL11.glTranslatef((float)0.0f, (float)-0.45f, (float)0.0f);
                break;
            }
            case NORTH: {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.45f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case SOUTH: {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.45f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glTranslatef((float)0.45f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GL11.glTranslatef((float)-0.45f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
    }

    public static void rotateBlockBasedOnDirection(ForgeDirection direction) {
        switch (direction) {
            default: {
                GL11.glRotatef((float)WorldUtility.getAngleFromForgeDirection(direction), (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case DOWN: {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case UP: {
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
    }

    public static void rotateBlockBasedOnDirectionUp(ForgeDirection direction) {
        switch (direction) {
            default: {
                GL11.glRotatef((float)WorldUtility.getAngleFromForgeDirection(direction), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case DOWN: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            case UP: 
        }
    }

    public static void bind(String name) {
        RenderUtility.bind(RenderUtility.getResource("minecraft", name));
    }

    public static void bind(String domain, String name) {
        RenderUtility.bind(RenderUtility.getResource(domain, name));
    }

    public static void bind(ResourceLocation location) {
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(location);
    }
}

