/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.modflags;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.ISave;
import com.builtbroken.mc.lib.access.AccessProfile;
import com.builtbroken.mc.lib.access.IProfileContainer;
import com.builtbroken.mc.lib.modflags.RegionManager;
import com.builtbroken.mc.lib.transform.region.Cube;
import com.builtbroken.mc.lib.transform.vector.Location;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class Region
implements ISave,
IProfileContainer {
    public List<Cube> segments = new ArrayList<Cube>();
    public List<EntityPlayer> players_in_region = new ArrayList<EntityPlayer>();
    public List<String> flags = new ArrayList<String>();
    public AccessProfile profile;
    public final String name;

    public Region(String name) {
        this.name = name;
    }

    public boolean doesContainPoint(IPos3D pos) {
        for (Cube cube : this.segments) {
            if (!cube.isWithin(pos)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        if (nbt.func_74764_b("segments")) {
            NBTTagList list = nbt.func_150295_c("segments", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.segments.add(new Cube(list.func_150305_b(i)));
            }
        }
        if (nbt.func_74764_b("profile")) {
            this.setAccessProfile(new AccessProfile(nbt.func_74775_l("profile")));
        }
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        if (this.segments.size() > 0) {
            NBTTagList list = new NBTTagList();
            for (Cube cube : this.segments) {
                list.func_74742_a((NBTBase)cube.toNBT());
            }
            nbt.func_74782_a("segments", (NBTBase)list);
        }
        NBTTagCompound tag = new NBTTagCompound();
        this.profile.save(tag);
        nbt.func_74782_a("profile", (NBTBase)tag);
        return nbt;
    }

    @Override
    public AccessProfile getAccessProfile() {
        if (this.profile == null) {
            this.profile = RegionManager.generateDefaultAccessProfile();
        }
        return this.profile;
    }

    @Override
    public void setAccessProfile(AccessProfile profile) {
        this.profile = profile;
    }

    @Override
    public boolean canAccess(String username) {
        return this.getAccessProfile().getUserAccess(username).getGroup() != null;
    }

    @Override
    public boolean hasNode(EntityPlayer player, String node) {
        return this.profile != null && this.getAccessProfile().hasNode(player, node);
    }

    @Override
    public boolean hasNode(String username, String node) {
        return this.profile != null && this.getAccessProfile().hasNode(username, node);
    }

    @Override
    public void onProfileChange() {
    }

    public boolean isCloseToAnyCorner(Location location, int distance) {
        for (Cube cube : this.segments) {
            if (!cube.isCloseToAnyCorner(location, distance)) continue;
            return true;
        }
        return false;
    }
}

