/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.mod.loadable;

import com.builtbroken.jlib.type.Pair;
import com.builtbroken.mc.lib.mod.loadable.ILoadable;
import com.builtbroken.mc.lib.mod.loadable.ILoadableProxy;
import com.builtbroken.mc.lib.mod.loadable.LoadWithMod;
import cpw.mods.fml.common.Loader;
import java.util.HashMap;
import java.util.Map;

public class LoadableHandler {
    private HashMap<ILoadable, Pair<Boolean, Boolean>> loadables = new HashMap();
    private LoadPhase phase = LoadPhase.PRELAUNCH;

    public void applyModule(Class<?> clazz) {
        this.applyModule(clazz, true);
    }

    public void applyModule(Class<?> clazz, boolean load2) {
        if (load2) {
            String id;
            if (clazz.getAnnotation(LoadWithMod.class) != null && !Loader.isModLoaded((String)(id = clazz.getAnnotation(LoadWithMod.class).mod_id()))) {
                return;
            }
            try {
                Object module = clazz.newInstance();
                if (module instanceof ILoadableProxy) {
                    ILoadableProxy subProxy = (ILoadableProxy)module;
                    if (subProxy.shouldLoad()) {
                        this.loadables.put(subProxy, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
                    }
                } else if (module instanceof ILoadable) {
                    this.loadables.put((ILoadable)module, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void applyModule(ILoadable module) {
        this.loadables.put(module, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
        switch (this.phase) {
            case DONE: {
                break;
            }
            case POSTINIT: {
                module.preInit();
                module.init();
                module.postInit();
                break;
            }
            case INIT: {
                module.preInit();
                module.init();
                break;
            }
        }
    }

    public void preInit() {
        this.phase = LoadPhase.PREINIT;
        for (Map.Entry<ILoadable, Pair<Boolean, Boolean>> proxy : this.loadables.entrySet()) {
            proxy.getKey().preInit();
            proxy.getValue().setLeft((Object)true);
        }
    }

    public void init() {
        this.phase = LoadPhase.INIT;
        for (Map.Entry<ILoadable, Pair<Boolean, Boolean>> proxy : this.loadables.entrySet()) {
            if (!((Boolean)proxy.getValue().left()).booleanValue()) {
                proxy.getValue().setLeft((Object)true);
                proxy.getKey().preInit();
            }
            proxy.getKey().init();
            proxy.getValue().setRight((Object)true);
        }
    }

    public void postInit() {
        this.phase = LoadPhase.POSTINIT;
        for (Map.Entry<ILoadable, Pair<Boolean, Boolean>> proxy : this.loadables.entrySet()) {
            if (!((Boolean)proxy.getValue().left()).booleanValue()) {
                proxy.getValue().setLeft((Object)true);
                proxy.getKey().preInit();
            }
            if (!((Boolean)proxy.getValue().right()).booleanValue()) {
                proxy.getValue().setRight((Object)true);
                proxy.getKey().init();
            }
            proxy.getKey().postInit();
        }
        this.phase = LoadPhase.DONE;
    }

    public static enum LoadPhase {
        PRELAUNCH,
        PREINIT,
        INIT,
        POSTINIT,
        DONE;

    }
}

