/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.mod.compat.ic;

import com.builtbroken.mc.lib.energy.EnergyHandler;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.tile.IEnergyStorage;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class ICHandler
extends EnergyHandler {
    public static double TO_UE;
    public static double FROM_UE;

    public ICHandler() {
        super("IndustrialCraft", "Energy Unit", "eu", 10.0);
        TO_UE = this.toForgienEnergy;
        FROM_UE = this.toUEEnergy;
    }

    @Override
    public double receiveEnergy(Object handler, ForgeDirection direction, double energy, boolean doReceive) {
        if (handler instanceof IEnergyStorage) {
            double provided = energy * this.toForgienEnergy;
            int energyStored = ((IEnergyStorage)handler).getStored();
            int space = ((IEnergyStorage)handler).getCapacity() - energyStored;
            if (!doReceive) {
                return Math.min(provided, (double)space) * this.toUEEnergy;
            }
            if ((double)space > provided) {
                int newStored = ((IEnergyStorage)handler).addEnergy((int)provided);
                return (double)(newStored - energyStored) * this.toUEEnergy;
            }
            int newStored = ((IEnergyStorage)handler).addEnergy(space);
            return (double)(newStored - energyStored) * this.toUEEnergy;
        }
        if (handler instanceof IEnergySink && ((IEnergySink)handler).acceptsEnergyFrom(null, direction)) {
            if (!doReceive) {
                return ((IEnergySink)handler).getDemandedEnergy() * this.toUEEnergy;
            }
            return ((IEnergySink)handler).injectEnergy(direction, energy * this.toForgienEnergy, (double)this.getVoltageForTier(((IEnergySink)handler).getSinkTier())) * this.toUEEnergy;
        }
        return 0.0;
    }

    @Override
    public double extractEnergy(Object handler, ForgeDirection direction, double energy, boolean doExtract) {
        if (!(handler instanceof IEnergyStorage) && handler instanceof IEnergySource && ((IEnergySource)handler).emitsEnergyTo(null, direction)) {
            double request = energy * this.toForgienEnergy;
            double e = Math.min(request, ((IEnergySource)handler).getOfferedEnergy());
            ((IEnergySource)handler).drawEnergy(e);
            return e * this.toUEEnergy;
        }
        return 0.0;
    }

    @Override
    public double chargeItem(ItemStack itemStack, double joules, boolean docharge) {
        return 0.0;
    }

    @Override
    public double dischargeItem(ItemStack itemStack, double joules, boolean doDischarge) {
        return 0.0;
    }

    @Override
    public boolean doIsHandler(Object obj, ForgeDirection dir) {
        return obj instanceof IEnergySink || obj instanceof IEnergyEmitter;
    }

    @Override
    public boolean doIsHandler(Object obj) {
        return obj instanceof IEnergySink || obj instanceof IEnergyEmitter;
    }

    @Override
    public boolean doIsEnergyContainer(Object obj) {
        return obj instanceof IEnergyStorage;
    }

    @Override
    public boolean canConnect(Object obj, ForgeDirection direction, Object source) {
        return obj instanceof IEnergyAcceptor;
    }

    @Override
    public ItemStack getItemWithCharge(ItemStack itemStack, double energy) {
        return null;
    }

    @Override
    public double getEnergy(Object obj, ForgeDirection direction) {
        if (obj instanceof IEnergyStorage) {
            return (double)((IEnergyStorage)obj).getStored() * this.toUEEnergy;
        }
        if (obj instanceof IEnergySource) {
            return ((IEnergySource)obj).getOfferedEnergy() * this.toUEEnergy;
        }
        return obj instanceof IEnergySink ? ((IEnergySink)obj).getDemandedEnergy() * this.toUEEnergy : 0.0;
    }

    @Override
    public double getMaxEnergy(Object obj, ForgeDirection direction) {
        if (obj instanceof IEnergyStorage) {
            return (double)((IEnergyStorage)obj).getCapacity() * this.toUEEnergy;
        }
        if (obj instanceof IEnergySource) {
            return ((IEnergySource)obj).getOfferedEnergy() * this.toUEEnergy;
        }
        return obj instanceof IEnergySink ? ((IEnergySink)obj).getDemandedEnergy() * this.toUEEnergy : 0.0;
    }

    @Override
    public double getEnergyItem(ItemStack is) {
        return 0.0;
    }

    @Override
    public double getMaxEnergyItem(ItemStack is) {
        return 0.0;
    }

    @Override
    public double clearEnergy(Object handler, boolean doAction) {
        if (!doAction) {
            return this.getEnergy(handler, null);
        }
        int e = 0;
        if (handler instanceof IEnergyStorage) {
            e = ((IEnergyStorage)handler).getStored();
            ((IEnergyStorage)handler).setStored(0);
        } else {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                e = (int)((double)e + this.extractEnergy(handler, dir, 2.147483647E9, doAction));
            }
        }
        return (double)e * this.toUEEnergy;
    }

    private int getVoltageForTier(int tier) {
        switch (tier) {
            case 1: {
                return 32;
            }
            case 2: {
                return 128;
            }
            case 3: {
                return 512;
            }
            case 4: {
                return 2048;
            }
        }
        return 8;
    }
}

