/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.helper;

import com.builtbroken.jlib.data.science.units.UnitHelper;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.transform.vector.Point;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;

public class NBTUtility {
    public static boolean saveData(File file, NBTTagCompound data) {
        try {
            File tempFile = new File(file.getParent(), file.getName() + "_tmp.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)new FileOutputStream(tempFile));
            if (file.exists()) {
                file.delete();
            }
            tempFile.renameTo(file);
            return true;
        }
        catch (Exception e) {
            Engine.instance.logger().fatal("Failed to save " + file.getName() + ".dat!");
            e.printStackTrace();
            return false;
        }
    }

    public static boolean saveData(File saveDirectory, String filename, NBTTagCompound data) {
        return NBTUtility.saveData(new File(saveDirectory, filename + ".dat"), data);
    }

    public static boolean saveData(String filename, NBTTagCompound data) {
        return NBTUtility.saveData(NBTUtility.getSaveDirectory(MinecraftServer.func_71276_C().func_71270_I()), filename, data);
    }

    public static NBTTagCompound loadData(File file) {
        try {
            if (file == null) {
                throw new FileNotFoundException("File is null so can not be found");
            }
            if (file.exists()) {
                return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
            }
            Engine.instance.logger().info("Save file " + file + "\n\tdoes not exist in the save folder! Generating new NBT data in it's place.");
            return new NBTTagCompound();
        }
        catch (FileNotFoundException e) {
            Engine.instance.logger().error("Save Loader Error, File not found " + file, (Throwable)e);
            return new NBTTagCompound();
        }
        catch (IOException e) {
            Engine.instance.logger().error("Save Loader Error, Failed to read " + file, (Throwable)e);
            return new NBTTagCompound();
        }
    }

    public static NBTTagCompound loadData(File saveDirectory, String filename) {
        return NBTUtility.loadData(new File(saveDirectory, filename + ".dat"));
    }

    public static NBTTagCompound loadData(String filename) {
        return NBTUtility.loadData(NBTUtility.getSaveDirectory(MinecraftServer.func_71276_C().func_71270_I()), filename);
    }

    public static File getSaveDirectory() {
        return NBTUtility.getSaveDirectory(MinecraftServer.func_71276_C().func_71270_I());
    }

    public static File getSaveDirectory(String worldName) {
        File parent = NBTUtility.getBaseDirectory();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            parent = new File(NBTUtility.getBaseDirectory(), "saves" + File.separator);
        }
        return new File(parent, worldName + File.separator);
    }

    public static File getBaseDirectory() {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            FMLClientHandler.instance().getClient();
            return FMLClientHandler.instance().getClient().field_71412_D;
        }
        return new File(".");
    }

    public static NBTTagCompound getNBTTagCompound(ItemStack itemStack) {
        if (itemStack != null) {
            if (itemStack.func_77978_p() == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            return itemStack.func_77978_p();
        }
        return null;
    }

    public static NBTTagCompound saveObject(NBTTagCompound tag, String key, Object value) {
        if (value instanceof Float) {
            tag.func_74776_a(key, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            tag.func_74780_a(key, ((Double)value).doubleValue());
        } else if (value instanceof Integer) {
            tag.func_74768_a(key, ((Integer)value).intValue());
        } else if (value instanceof String) {
            tag.func_74778_a(key, (String)value);
        } else if (value instanceof Short) {
            tag.func_74777_a(key, ((Short)value).shortValue());
        } else if (value instanceof Byte) {
            tag.func_74774_a(key, ((Byte)value).byteValue());
        } else if (value instanceof Long) {
            tag.func_74772_a(key, ((Long)value).longValue());
        } else if (value instanceof Boolean) {
            tag.func_74778_a(key, "NBT:SAVE:BOOLEAN:" + value);
        } else if (value instanceof NBTBase) {
            tag.func_74782_a(key, (NBTBase)value);
        } else if (value instanceof String) {
            tag.func_74778_a(key, (String)value);
        } else if (value instanceof byte[]) {
            tag.func_74773_a(key, (byte[])value);
        } else if (value instanceof int[]) {
            tag.func_74783_a(key, (int[])value);
        } else if (value instanceof NBTTagCompound) {
            tag.func_74782_a(key, (NBTBase)((NBTTagCompound)value));
        } else if (value instanceof Point) {
            tag.func_74778_a(key, "NBT:SAVE:VECTOR:2:" + ((Point)value).x() + ":" + ((Point)value).y());
        } else if (value instanceof Pos) {
            tag.func_74778_a(key, "NBT:SAVE:VECTOR:3:" + ((Pos)((Object)value)).x() + ":" + ((Pos)((Object)value)).y() + ":" + ((Pos)((Object)value)).z());
        }
        return tag;
    }

    public static NBTTagCompound saveObject(String key, Object value) {
        return NBTUtility.saveObject(new NBTTagCompound(), key, value);
    }

    public static Object loadObject(NBTTagCompound tag, String key) {
        if (tag != null && key != null) {
            NBTBase saveTag = tag.func_74781_a(key);
            if (saveTag instanceof NBTTagFloat) {
                return Float.valueOf(tag.func_74760_g(key));
            }
            if (saveTag instanceof NBTTagDouble) {
                return tag.func_74769_h(key);
            }
            if (saveTag instanceof NBTTagInt) {
                return tag.func_74762_e(key);
            }
            if (saveTag instanceof NBTTagString) {
                String str = tag.func_74779_i(key);
                if (str.startsWith("NBT:SAVE:")) {
                    str.replaceAll("NBT:SAVE:", "");
                    if (str.startsWith("BOOLEAN:")) {
                        str.replaceAll("BOOLEAN:", "");
                        if (str.equalsIgnoreCase("true")) {
                            return true;
                        }
                        if (str.equalsIgnoreCase("false")) {
                            return false;
                        }
                    }
                    if (str.startsWith("VECTOR:")) {
                        str.replaceAll("VECTOR:", "");
                        String[] nums = str.split(":");
                        if (UnitHelper.tryToParseDouble((Object)nums[0]) == 2.0) {
                            return new Point(UnitHelper.tryToParseDouble((Object)nums[1]), UnitHelper.tryToParseDouble((Object)nums[2]));
                        }
                        if (UnitHelper.tryToParseDouble((Object)nums[0]) == 3.0) {
                            return new Pos(UnitHelper.tryToParseDouble((Object)nums[1]), UnitHelper.tryToParseDouble((Object)nums[2]), UnitHelper.tryToParseDouble((Object)nums[3]));
                        }
                    }
                    return null;
                }
                return str;
            }
            if (saveTag instanceof NBTTagShort) {
                return tag.func_74765_d(key);
            }
            if (saveTag instanceof NBTTagByte) {
                return tag.func_74771_c(key);
            }
            if (saveTag instanceof NBTTagLong) {
                return tag.func_74763_f(key);
            }
            if (saveTag instanceof NBTBase) {
                return tag.func_74781_a(key);
            }
            if (saveTag instanceof NBTTagByteArray) {
                return tag.func_74770_j(key);
            }
            if (saveTag instanceof NBTTagIntArray) {
                return tag.func_74759_k(key);
            }
            if (saveTag instanceof NBTTagCompound) {
                return tag.func_74775_l(key);
            }
        }
        return null;
    }

    public static NBTTagCompound saveProfile(NBTTagCompound nbt, GameProfile profile) {
        nbt.func_74778_a("UUID", profile.getId().toString());
        nbt.func_74778_a("username", profile.getName());
        return nbt;
    }

    public static GameProfile loadProfile(NBTTagCompound nbt) {
        GameProfile profile;
        if (nbt.func_74779_i("UUID").split("-").length == 5 && (profile = new GameProfile(UUID.fromString(nbt.func_74779_i("UUID")), nbt.func_74779_i("username"))).isComplete()) {
            return profile;
        }
        return null;
    }

    public static boolean doTagsMatch(NBTTagCompound tag, NBTTagCompound tag2) {
        if (tag == null && tag2 == null) {
            return true;
        }
        if (tag != null && tag2 == null) {
            return false;
        }
        if (tag == null && tag2 != null) {
            return false;
        }
        return tag.equals((Object)tag2);
    }
}

