/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.helper;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.helper.wrapper.StringWrapper;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class LanguageUtility {
    private static StringWrapper.WrappedString wrap(String str) {
        return new StringWrapper.WrappedString(str);
    }

    public static String getLocal(String key) {
        if (key == null || key.isEmpty()) {
            if (Engine.runningAsDev) {
                Engine.instance.logger().error("LanguageUtility.getLocal(" + key + ")", (Throwable)new RuntimeException());
            }
            return "error.key.empty";
        }
        return LanguageUtility.wrap(key).getLocal();
    }

    public static String getLocalName(String key) {
        if (key == null || key.isEmpty()) {
            if (Engine.runningAsDev) {
                Engine.instance.logger().error("LanguageUtility.getLocalName(" + key + ")", (Throwable)new RuntimeException());
            }
            return "error.key.empty";
        }
        return LanguageUtility.wrap(key + (!key.endsWith(".name") ? ".name" : "")).getLocal();
    }

    public static Integer getLangSetting(String key, int backup) {
        block3: {
            String result = LanguageUtility.getLocal(key);
            if (result != null && !result.isEmpty()) {
                try {
                    return Integer.parseInt(key);
                }
                catch (NumberFormatException e) {
                    if (!Engine.runningAsDev) break block3;
                    Engine.instance.logger().error("LanguageUtility.getLangSetting(" + key + ")", (Throwable)e);
                }
            }
        }
        return backup;
    }

    public static IChatComponent getLocalChat(String key) {
        String translation = LanguageUtility.getLocalName(key);
        if (translation == null || translation.isEmpty()) {
            if (Engine.runningAsDev) {
                Engine.instance.logger().error("LanguageUtility.getLocalChat(" + key + ")", (Throwable)new RuntimeException());
            }
            return new ChatComponentText("error.translation.empty");
        }
        return new ChatComponentText(translation);
    }

    public static void addChatToPlayer(EntityPlayer player, String key) {
        if (player != null) {
            player.func_146105_b(LanguageUtility.getLocalChat(key));
        } else if (Engine.runningAsDev) {
            Engine.instance.logger().error("LanguageUtility.addChatToPlayer(Null Player, " + key + ")", (Throwable)new RuntimeException());
        }
    }

    public static List<String> splitStringPerWord(String string, int characters) {
        return LanguageUtility.wrap(string).listWrap(characters);
    }

    public static String[] splitStringPerWordIntoArray(String string, int characters) {
        return LanguageUtility.wrap(string).wrap(characters);
    }

    public static String capitalizeFirst(String str) {
        return LanguageUtility.wrap(str).capitalizeFirst();
    }

    public static String decapitalizeFirst(String str) {
        return LanguageUtility.wrap(str).decapitalizeFirst();
    }

    public static String toCamelCase(String str) {
        return LanguageUtility.wrap(str).toCamelCase();
    }

    public static String toPascalCase(String str) {
        return LanguageUtility.wrap(str).toPascalCase();
    }

    public static String camelToLowerUnderscore(String str) {
        return LanguageUtility.wrap(str).camelToLowerUnderscore();
    }

    public static String camelToReadable(String str) {
        return LanguageUtility.wrap(str).camelToReadable();
    }

    public static String underscoreToCamel(String str) {
        return LanguageUtility.wrap(str).underscoreToCamel();
    }

    public static String toProperCase(String str) {
        return LanguageUtility.wrap(str).toProperCase();
    }
}

