/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.lib.helper;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.helper.ReflectionUtility;
import com.builtbroken.mc.lib.transform.vector.Pos;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class BlockUtility {
    private static HashMap<Block, Float> BLOCK_HARDNESS = new HashMap();
    private static HashMap<Block, Float> BLOCK_RESISTANCE = new HashMap();
    public static final String[] CHUNK_RELIGHT_BLOCK = new String[]{"relightBlock", "func_76615_h"};
    public static final String[] CHUNK_PROPOGATE_SKY_LIGHT_OCCLUSION = new String[]{"propagateSkylightOcclusion", "func_76595_e"};

    public static float getBlockResistance(Block block) {
        if (BLOCK_RESISTANCE.containsKey(block)) {
            return BLOCK_RESISTANCE.get(block).floatValue();
        }
        try {
            Field field = ReflectionUtility.getMCField(Block.class, "blockResistance", "field_149781_w");
            BLOCK_RESISTANCE.put(block, Float.valueOf(field.getFloat(block)));
            return BLOCK_RESISTANCE.get(block).floatValue();
        }
        catch (Exception e) {
            Engine.instance.logger().info("Failed to reflect into Block.class to get block resistance");
            Engine.instance.logger().catching((Throwable)e);
            return 0.0f;
        }
    }

    public static float getBlockHardness(Block block) {
        if (BLOCK_HARDNESS.containsKey(block)) {
            return BLOCK_HARDNESS.get(block).floatValue();
        }
        try {
            Field field = ReflectionUtility.getMCField(Block.class, "blockHardness", "field_149782_v");
            BLOCK_HARDNESS.put(block, Float.valueOf(field.getFloat(block)));
            return BLOCK_HARDNESS.get(block).floatValue();
        }
        catch (Exception e) {
            Engine.instance.logger().info("Failed to reflect into Block.class to get block hardness");
            Engine.instance.logger().catching((Throwable)e);
            return 0.0f;
        }
    }

    public static float getBlockHardness(ItemStack stack) {
        return BlockUtility.getBlockHardness(Block.func_149634_a((Item)stack.func_77973_b()));
    }

    public static void setBlockSneaky(World world, Pos position, Block block, int metadata, TileEntity tileEntity) {
        if (block != null && world != null) {
            Chunk chunk = world.func_72964_e(position.xi() >> 4, position.zi() >> 4);
            Pos chunkPosition = new Pos(position.xi() & 0xF, position.yi() & 0xF, position.zi() & 0xF);
            int heightMapIndex = chunkPosition.zi() << 4 | chunkPosition.xi();
            if (position.yi() >= chunk.field_76638_b[heightMapIndex] - 1) {
                chunk.field_76638_b[heightMapIndex] = -999;
            }
            int heightMapValue = chunk.field_76634_f[heightMapIndex];
            world.func_147475_p(position.xi(), position.yi(), position.zi());
            ExtendedBlockStorage extendedBlockStorage = chunk.func_76587_i()[position.yi() >> 4];
            if (extendedBlockStorage == null) {
                chunk.func_76587_i()[position.yi() >> 4] = extendedBlockStorage = new ExtendedBlockStorage(position.yi() >> 4 << 4, !world.field_73011_w.field_76576_e);
            }
            extendedBlockStorage.func_150818_a(chunkPosition.xi(), chunkPosition.yi(), chunkPosition.zi(), block);
            extendedBlockStorage.func_76654_b(chunkPosition.xi(), chunkPosition.yi(), chunkPosition.zi(), metadata);
            if (position.yi() >= heightMapValue) {
                chunk.func_76603_b();
            } else {
                if (chunk.func_76629_c(chunkPosition.xi(), position.yi(), chunkPosition.zi(), 0) > 0) {
                    if (position.yi() >= heightMapValue) {
                        BlockUtility.relightBlock(chunk, (Pos)((Pos)chunkPosition.clone()).add(new Pos(0.0, 1.0, 0.0)));
                    }
                } else if (position.yi() == heightMapValue - 1) {
                    BlockUtility.relightBlock(chunk, chunkPosition);
                }
                BlockUtility.propagateSkylightOcclusion(chunk, chunkPosition);
            }
            chunk.field_76643_l = true;
            world.func_147451_t(position.xi(), position.yi(), position.zi());
            if (tileEntity != null) {
                world.func_147455_a(position.xi(), position.yi(), position.zi(), tileEntity);
            }
            world.func_147471_g(position.xi(), position.yi(), position.zi());
        }
    }

    public static void relightBlock(Chunk chunk, Pos position) {
        try {
            Method m = ReflectionHelper.findMethod(Chunk.class, null, (String[])CHUNK_RELIGHT_BLOCK, (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE});
            m.invoke((Object)chunk, position.xi(), position.yi(), position.zi());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void propagateSkylightOcclusion(Chunk chunk, Pos position) {
        try {
            Method m = ReflectionHelper.findMethod(Chunk.class, null, (String[])CHUNK_PROPOGATE_SKY_LIGHT_OCCLUSION, (Class[])new Class[]{Integer.TYPE, Integer.TYPE});
            m.invoke((Object)chunk, position.xi(), position.zi());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

