/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.registry;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.registry.CommonRegistryProxy;
import com.builtbroken.mc.core.registry.implement.IPostInit;
import com.builtbroken.mc.core.registry.implement.IRecipeContainer;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.prefab.tile.BlockTile;
import com.builtbroken.mc.prefab.tile.Tile;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;

public class ModManager {
    @SidedProxy(clientSide="com.builtbroken.mc.core.registry.ClientRegistryProxy", serverSide="com.builtbroken.mc.core.registry.CommonRegistryProxy")
    public static CommonRegistryProxy proxy;
    public final WeakHashMap<Block, String> blocks = new WeakHashMap();
    public final WeakHashMap<Item, String> items = new WeakHashMap();
    private final ArrayList temp_registry_list = new ArrayList();
    public String modPrefix;
    public CreativeTabs defaultTab;

    public ModManager setPrefix(String modPrefix) {
        this.modPrefix = modPrefix;
        if (!modPrefix.endsWith(":")) {
            this.modPrefix = this.modPrefix + ":";
        }
        return this;
    }

    public ModManager setTab(CreativeTabs defaultTab) {
        this.defaultTab = defaultTab;
        return this;
    }

    public BlockTile newBlock(Class<? extends Tile> spatialClass, Object ... args) {
        return this.newBlock(null, spatialClass, args);
    }

    public BlockTile newBlock(String name, Class<? extends Tile> spatialClass, Object ... args) {
        try {
            Tile spatial;
            if (args != null && args.length > 0) {
                ArrayList paramTypes = new ArrayList();
                for (Object arg : args) {
                    paramTypes.add(arg.getClass());
                }
                spatial = spatialClass.getConstructor(paramTypes.toArray(new Class[paramTypes.size()])).newInstance(new Object[0]);
            } else {
                spatial = spatialClass.newInstance();
            }
            return this.newBlock(name, spatial);
        }
        catch (Exception e) {
            throw new RuntimeException(this.name() + " Tile [" + spatialClass.getSimpleName() + "] failed to be created:", e);
        }
    }

    public BlockTile newBlock(Tile spatial) {
        return this.newBlock(null, spatial);
    }

    public BlockTile newBlock(String name, Tile spatial) {
        String actual_name = name;
        this.debug("-----------------------------------------------------------");
        this.debug(" Creating new spatial block name='" + name + "'  Tile='" + spatial + "'");
        if (actual_name == null || actual_name.isEmpty()) {
            if (spatial.name != null && !spatial.name.isEmpty()) {
                actual_name = spatial.name;
            } else {
                Engine.instance.logger().warn(this.name() + " Tile: " + spatial + " has no defined name to register with and could cause issues with world loading. In order to prevent the game from crashing we are falling back to using the class name.");
                actual_name = LanguageUtility.decapitalizeFirst(spatial.getClass().getSimpleName().replace("Tile", ""));
            }
        }
        BlockTile block = new BlockTile(spatial, this.modPrefix, this.defaultTab);
        spatial.setBlock(block);
        block = this.newBlock(actual_name, block, spatial.itemBlock);
        this.temp_registry_list.add(spatial);
        Tile newTile = spatial.newTile();
        this.debug("\t NewTile='" + newTile + "'");
        if (newTile != null) {
            this.registerTile(actual_name, (Block)block, spatial, newTile);
        }
        this.debug("-----------------------------------------------------------");
        return block;
    }

    public void registerTile(String actual_name, Block block, Tile spatial, Tile newTile) {
        this.registerTileEntity(actual_name, block, newTile);
        if (newTile.getClass() != spatial.getClass()) {
            this.temp_registry_list.add(newTile);
        }
        if (spatial.renderTileEntity) {
            this.debug("\tDetected tile renderer");
            proxy.registerDummyRenderer(newTile.getClass());
        }
    }

    public void registerTileEntity(String actual_name, Block block, TileEntity tile) {
        this.debug("\tRegistering tile " + tile + " with name " + actual_name);
        proxy.registerTileEntity(actual_name, this.modPrefix, block, tile);
    }

    public Block newBlock(Class<? extends Block> blockClazz, Class<? extends ItemBlock> itemBlockClass) {
        return this.newBlock(blockClazz.getSimpleName(), (Block)blockClazz, itemBlockClass);
    }

    public Block newBlock(Class<? extends Block> blockClazz) {
        return this.newBlock(blockClazz.getSimpleName(), (Block)blockClazz);
    }

    public Block newBlock(String name, Class<? extends Block> blockClazz) {
        return this.newBlock(name, (Block)blockClazz, null);
    }

    public Block newBlock(String name, Class<? extends Block> blockClazz, Class<? extends ItemBlock> itemBlockClass) {
        try {
            return this.newBlock(name, blockClazz.newInstance(), itemBlockClass);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(this.name() + " Failed to create block from class " + blockClazz, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(this.name() + " Failed to access class " + blockClazz, e);
        }
    }

    public <C extends Block> C newBlock(String name, C block) {
        return this.newBlock(name, block, null);
    }

    public <C extends Block> C newBlock(String name, C block, Class<? extends ItemBlock> itemBlock) {
        if (name == null || name.isEmpty()) {
            name = LanguageUtility.decapitalizeFirst(block.getClass().getSimpleName().replace("Block", ""));
        }
        proxy.registerBlock(this, name, this.modPrefix, block, itemBlock);
        this.blocks.put(block, name);
        this.temp_registry_list.add(block);
        return block;
    }

    public <C extends Item> C newItem(Class<C> clazz, Object ... args) {
        return this.newItem(null, clazz, args);
    }

    public <C extends Item> C newItem(String name, Class<C> clazz, Object ... args) {
        try {
            Item item;
            if (args != null && args.length > 0) {
                ArrayList paramTypes = new ArrayList();
                for (Object arg : args) {
                    paramTypes.add(arg.getClass());
                }
                item = (Item)clazz.getConstructor(paramTypes.toArray(new Class[paramTypes.size()])).newInstance(new Object[0]);
            } else {
                item = (Item)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return (C)this.newItem(name, item);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(this.name() + "Failed to create item [" + name + "] due to invalid constructor", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(this.name() + "Failed to create item [" + name + "]", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(this.name() + "Failed to create item [" + name + "] due to access issue", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(this.name() + "Failed to create item [" + name + "] when invoking constructor", e);
        }
    }

    public <C extends Item> C newItem(C item) {
        return this.newItem((String)null, item);
    }

    public <C extends Item> C newItem(String name, C item) {
        block3: {
            block2: {
                if (name == null) break block2;
                if (!name.isEmpty()) break block3;
            }
            Engine.instance.logger().debug(this.name() + " Registry name was not provided for item " + item + " using class name to prevent game from crashing. This may cause world loading issues in the future.");
            name = LanguageUtility.decapitalizeFirst(item.getClass().getSimpleName().replace("Item", ""));
        }
        proxy.registerItem(this, name, this.modPrefix, item);
        this.items.put(item, name);
        this.temp_registry_list.add(item);
        return item;
    }

    public void fireInit() {
        for (Object object : this.temp_registry_list) {
            proxy.onRegistry(object);
        }
    }

    public void firePostInit() {
        for (Object object : this.temp_registry_list) {
            if (!(object instanceof IPostInit)) continue;
            ((IPostInit)object).onPostInit();
        }
        for (Object object : this.temp_registry_list) {
            if (!(object instanceof IRecipeContainer)) continue;
            ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
            ((IRecipeContainer)object).genRecipes(recipes);
            for (IRecipe recipe : recipes) {
                if (recipe.func_77571_b() != null) {
                    if (recipe.func_77571_b().func_77973_b() != null) {
                        if (recipe.func_77571_b().func_77976_d() > 0) {
                            GameRegistry.addRecipe((IRecipe)recipe);
                            continue;
                        }
                        if (!Engine.runningAsDev) continue;
                        throw new IllegalArgumentException("Recipe[" + recipe + "] output's stack size is less than 1");
                    }
                    if (!Engine.runningAsDev) continue;
                    throw new IllegalArgumentException("Recipe[" + recipe + "] output's item is null");
                }
                if (!Engine.runningAsDev) continue;
                throw new IllegalArgumentException("Recipe[" + recipe + "] output is null");
            }
        }
    }

    public String name() {
        return "ModManager[" + (this.modPrefix == null || this.modPrefix.isEmpty() ? Integer.valueOf(this.hashCode()) : this.modPrefix) + "]";
    }

    public void debug(String s) {
        if (Engine.runningAsDev) {
            Engine.instance.logger().info(this.name() + s);
        }
    }
}

