/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.network.packet;

import com.builtbroken.mc.core.handler.RenderSelection;
import com.builtbroken.mc.core.network.packet.AbstractPacket;
import com.builtbroken.mc.lib.transform.region.Cube;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

public class PacketSelectionData
extends AbstractPacket {
    List<Cube> cubes;
    List<Cube> regions;
    Cube selection;

    public PacketSelectionData() {
    }

    public PacketSelectionData(Cube selection, List<Cube> cubes, List<Cube> regions) {
        this.selection = selection;
        this.cubes = cubes;
        this.regions = regions;
        if (this.selection == null) {
            this.selection = new Cube();
        }
        if (this.cubes == null) {
            this.cubes = new ArrayList<Cube>();
        }
        if (this.regions == null) {
            this.regions = new ArrayList<Cube>();
        }
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.selection.writeBytes(buffer);
        buffer.writeInt(this.cubes.size());
        for (Cube cube : this.cubes) {
            cube.writeBytes(buffer);
        }
        buffer.writeInt(this.regions.size());
        for (Cube cube : this.regions) {
            cube.writeBytes(buffer);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        int i;
        RenderSelection.cube_render_list.clear();
        RenderSelection.region_render_list.clear();
        RenderSelection.selection = new Cube(buffer);
        int count = buffer.readInt();
        if (count > 0) {
            for (i = 0; i < count; ++i) {
                RenderSelection.cube_render_list.add(new Cube(buffer));
            }
        }
        if ((count = buffer.readInt()) > 0) {
            for (i = 0; i < count; ++i) {
                RenderSelection.region_render_list.add(new Cube(buffer));
            }
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        this.handle(player);
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        this.handle(player);
    }

    public void handle(EntityPlayer player) {
    }
}

