/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.network.netty;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.packet.AbstractPacket;
import com.builtbroken.mc.core.network.packet.PacketBiomeData;
import com.builtbroken.mc.core.network.packet.PacketEntity;
import com.builtbroken.mc.core.network.packet.PacketPlayerItem;
import com.builtbroken.mc.core.network.packet.PacketPlayerItemMode;
import com.builtbroken.mc.core.network.packet.PacketSelectionData;
import com.builtbroken.mc.core.network.packet.PacketSpawnEnderStream;
import com.builtbroken.mc.core.network.packet.PacketSpawnParticle;
import com.builtbroken.mc.core.network.packet.PacketSpawnParticleCircle;
import com.builtbroken.mc.core.network.packet.PacketSpawnParticleStream;
import com.builtbroken.mc.core.network.packet.PacketTile;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

public class ResonantChannelHandler
extends FMLIndexedMessageToMessageCodec<AbstractPacket> {
    public boolean silenceStackTrace = false;

    public ResonantChannelHandler() {
        this.addDiscriminator(0, PacketTile.class);
        this.addDiscriminator(1, PacketEntity.class);
        this.addDiscriminator(2, PacketPlayerItem.class);
        this.addDiscriminator(3, PacketPlayerItemMode.class);
        this.addDiscriminator(4, PacketSelectionData.class);
        this.addDiscriminator(5, PacketSpawnParticle.class);
        this.addDiscriminator(6, PacketSpawnEnderStream.class);
        this.addDiscriminator(7, PacketSpawnParticleCircle.class);
        this.addDiscriminator(8, PacketBiomeData.class);
        this.addDiscriminator(9, PacketSpawnParticleStream.class);
    }

    public void encodeInto(ChannelHandlerContext ctx, AbstractPacket packet, ByteBuf target) throws Exception {
        try {
            packet.encodeInto(ctx, target);
        }
        catch (Exception e) {
            if (!this.silenceStackTrace) {
                Engine.instance.logger().error("Failed to encode packet " + packet, (Throwable)e);
            }
            Engine.instance.logger().error("Failed to encode packet " + packet + " E: " + e.getMessage());
        }
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, AbstractPacket packet) {
        try {
            packet.decodeInto(ctx, source);
        }
        catch (Exception e) {
            if (!this.silenceStackTrace) {
                Engine.instance.logger().error("Failed to decode packet " + packet, (Throwable)e);
            }
            Engine.instance.logger().error("Failed to decode packet " + packet + " E: " + e.getMessage());
        }
    }
}

