/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.deps;

import com.builtbroken.mc.core.deps.Dep;
import com.builtbroken.mc.core.deps.FileDownloader;
import com.builtbroken.mc.core.deps.MavenDep;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.FMLInjectionData;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class DepDownloader {
    private File modsDir;
    private File v_modsDir;
    private LaunchClassLoader loader = (LaunchClassLoader)DepDownloader.class.getClassLoader();
    protected List<Dep> depsToLoad = new ArrayList<Dep>();

    public DepDownloader() {
        String mc_version = (String)FMLInjectionData.data()[4];
        File mc_directory = (File)FMLInjectionData.data()[6];
        this.modsDir = new File(mc_directory, "mods");
        this.v_modsDir = new File(mc_directory, "mods/" + mc_version);
        if (!this.v_modsDir.exists()) {
            this.v_modsDir.mkdirs();
        }
    }

    public void start() {
        for (Dep dep : this.depsToLoad) {
            int reply;
            File file = new File(dep.getOutputFolderPath(), dep.getFileName());
            boolean found = false;
            File newestFile = null;
            for (File nextFile : this.v_modsDir.listFiles()) {
                try {
                    if (!nextFile.getName().contains(dep.getGenericFileName())) continue;
                    if (nextFile.getName().equals(file.getName()) || dep.isNewerVersion(nextFile.getName())) {
                        if (newestFile != null) {
                            newestFile.delete();
                        }
                        newestFile = file;
                        found = true;
                        continue;
                    }
                    nextFile.delete();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to parse file " + nextFile.getName() + ". Crashing game to prevent more issues, try deleting the file manually and restarting the game", e);
                }
            }
            if (found) continue;
            if (!(GraphicsEnvironment.isHeadless() || System.getProperty("confirmDownloadDeps") != null && System.getProperty("confirmDownloadDeps").equalsIgnoreCase("yes") || (reply = JOptionPane.showConfirmDialog(null, "Missing required version of " + dep.getGenericFileName() + " for Voltz Engine. Do you want to download?\nIf you click no the game will close as it will crash without this file.", "Missing dependency", 0)) == 0)) {
                FMLCommonHandler.instance().exitJava(1, false);
                return;
            }
            FileDownloader.downloadDep(dep);
            this.addClasspath(file);
        }
    }

    private void addClasspath(File file) {
        try {
            this.loader.addURL(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void load() {
        DepDownloader downloader = new DepDownloader();
        downloader.depsToLoad.add(new MavenDep("http://api.dmodoomsirius.me/", "com/builtbroken/codinglib", "CodingLib", "0", "0", "4", "28", "universal"));
        downloader.start();
    }
}

