/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.content.resources.load;

import com.builtbroken.mc.api.recipe.MachineRecipeType;
import com.builtbroken.mc.core.content.resources.DefinedGenItems;
import com.builtbroken.mc.core.content.resources.GenMaterial;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.prefab.recipe.item.MRItemStack;
import com.builtbroken.mc.prefab.recipe.item.MRLoaderItemStack;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class SmeltingRecipeLoad
extends MRLoaderItemStack {
    public SmeltingRecipeLoad() {
        super(MachineRecipeType.ITEM_CRUSHER.INTERNAL_NAME);
    }

    @Override
    protected void generateRecipes(List<MRItemStack> recipes) {
        for (GenMaterial mat : GenMaterial.values()) {
            ArrayList ingots;
            if (mat == GenMaterial.UNKNOWN || (ingots = OreDictionary.getOres((String)("ingot" + LanguageUtility.capitalizeFirst(mat.name().toLowerCase())))).isEmpty()) continue;
            ItemStack ingotStack = (ItemStack)ingots.get(0);
            if (ingotStack == null) {
                int i = 1;
                while (ingotStack == null && i < ingots.size()) {
                    ingotStack = (ItemStack)ingots.get(i);
                }
            }
            if (ingotStack == null) continue;
            if (DefinedGenItems.RUBBLE.item != null && !DefinedGenItems.RUBBLE.ignoreMaterials.contains((Object)mat)) {
                GameRegistry.addSmelting((ItemStack)DefinedGenItems.RUBBLE.stack(mat), (ItemStack)ingotStack, (float)0.01f);
            }
            if (DefinedGenItems.DUST.item != null && !DefinedGenItems.DUST.ignoreMaterials.contains((Object)mat)) {
                GameRegistry.addSmelting((ItemStack)DefinedGenItems.DUST.stack(mat), (ItemStack)ingotStack, (float)0.02f);
            }
            if (DefinedGenItems.DUST_IMPURE.item == null || DefinedGenItems.DUST_IMPURE.ignoreMaterials.contains((Object)mat)) continue;
            GameRegistry.addSmelting((ItemStack)DefinedGenItems.DUST_IMPURE.stack(mat), (ItemStack)ingotStack, (float)0.02f);
        }
    }
}

