/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.commands.permissions;

import com.builtbroken.mc.api.IVirtualObject;
import com.builtbroken.mc.core.commands.permissions.PermissionsRegistry;
import com.builtbroken.mc.core.handler.SaveManager;
import com.builtbroken.mc.lib.access.AccessGroup;
import com.builtbroken.mc.lib.access.AccessProfile;
import com.builtbroken.mc.lib.access.AccessUser;
import com.builtbroken.mc.lib.access.IProfileContainer;
import com.builtbroken.mc.lib.helper.NBTUtility;
import com.builtbroken.mc.lib.mod.loadable.AbstractLoadable;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class GroupProfileHandler
extends AbstractLoadable
implements IVirtualObject,
IProfileContainer {
    public static final GroupProfileHandler GLOBAL = new GroupProfileHandler();
    public static boolean enablePermissions = true;
    public AccessProfile profile;

    @Override
    public void init() {
        if (enablePermissions) {
            MinecraftForge.EVENT_BUS.register((Object)GLOBAL);
        }
    }

    @Override
    public void postInit() {
    }

    @Override
    public File getSaveFile() {
        return new File(NBTUtility.getSaveDirectory(), "ve/permissions/global.dat");
    }

    @Override
    public void setSaveFile(File file) {
    }

    @Override
    public boolean shouldSaveForWorld(World world) {
        return world != null && world.field_73011_w.field_76574_g == 0;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        if (nbt.func_74764_b("profile")) {
            this.profile = new AccessProfile(nbt.func_74775_l("profile"));
        } else {
            this.generateNew();
        }
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        nbt.func_74778_a("ve_version", "0.19.0.217b217");
        if (this.profile != null) {
            nbt.func_74782_a("profile", (NBTBase)this.profile.save(new NBTTagCompound()));
        }
        return nbt;
    }

    public void generateNew() {
        this.profile = new AccessProfile();
        AccessGroup owner_group = new AccessGroup("Owner", new AccessUser[0]);
        owner_group.addNode(PermissionsRegistry.ALL);
        AccessGroup admin_group = new AccessGroup("Admin", new AccessUser[0]);
        admin_group.addNode("root.minecraft.difficulty");
        admin_group.addNode("root.minecraft.setworldspawn");
        admin_group.addNode("root.minecraft.give");
        admin_group.addNode("root.minecraft.gamemode");
        admin_group.addNode("root.minecraft.summon");
        admin_group.addNode("root.minecraft.spawnpoint");
        AccessGroup mod_group = new AccessGroup("Moderator", new AccessUser[0]);
        mod_group.addNode("root.minecraft.whitelist");
        mod_group.addNode("root.minecraft.ban-ip");
        mod_group.addNode("root.minecraft.pardon-ip");
        mod_group.addNode("root.minecraft.time");
        mod_group.addNode("root.minecraft.save-all");
        mod_group.addNode("root.minecraft.pardon");
        mod_group.addNode("root.minecraft.ban");
        mod_group.addNode("root.minecraft.weather");
        mod_group.addNode("root.minecraft.toggledownfall");
        mod_group.addNode("root.minecraft.tp");
        AccessGroup dev_group = new AccessGroup("Dev", new AccessUser[0]);
        dev_group.addNode("root.minecraft.debug");
        AccessGroup media_group = new AccessGroup("Media", new AccessUser[0]);
        media_group.addNode("root.minecraft.seed");
        AccessGroup user_group = new AccessGroup("User", new AccessUser[0]);
        user_group.addNode("root.minecraft.help");
        user_group.addNode("root.minecraft.me");
        user_group.addNode("root.minecraft.tell");
        owner_group.setToExtend(admin_group);
        admin_group.setToExtend(mod_group);
        mod_group.setToExtend(user_group);
        dev_group.setToExtend(user_group);
        media_group.setToExtend(user_group);
        this.profile.addGroup(owner_group);
        this.profile.addGroup(admin_group);
        this.profile.addGroup(mod_group);
        this.profile.addGroup(dev_group);
        this.profile.addGroup(user_group);
    }

    @Override
    public boolean shouldLoad() {
        return FMLCommonHandler.instance().getEffectiveSide().isServer();
    }

    public boolean canExecuteCommand(ICommandSender sender, ICommand command, String[] args) {
        if (sender instanceof EntityPlayer) {
            AccessUser user = this.getAccessProfile().getUserAccess((EntityPlayer)sender);
            String node = PermissionsRegistry.getNodeFor(command, args);
            return user.hasNode(node);
        }
        return command.func_71519_b(sender);
    }

    @Override
    public AccessProfile getAccessProfile() {
        if (this.profile == null) {
            this.load(NBTUtility.loadData(this.getSaveFile()));
            SaveManager.register(this);
        }
        return this.profile;
    }

    @Override
    public void setAccessProfile(AccessProfile profile) {
    }

    @Override
    public boolean canAccess(String username) {
        return true;
    }

    @Override
    public boolean hasNode(EntityPlayer player, String node) {
        return this.profile != null && this.getAccessProfile().hasNode(player, node);
    }

    @Override
    public boolean hasNode(String username, String node) {
        return this.profile != null && this.getAccessProfile().hasNode(username, node);
    }

    @Override
    public void onProfileChange() {
    }

    static {
        SaveManager.registerClass("permissionHandler", GroupProfileHandler.class);
    }
}

