/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core.asm.template;

import com.builtbroken.mc.core.EngineCoreMod;
import com.builtbroken.mc.core.asm.template.InjectionTemplate;
import com.builtbroken.mc.core.asm.template.TemplateManager;
import com.builtbroken.mc.lib.asm.ASMHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

public class ClassTransformer
implements IClassTransformer {
    public static final List<String> permittedClassPaths = new ArrayList<String>();
    public static final List<String> permittedPrefixClass = new ArrayList<String>();

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        block10: {
            try {
                if (!this.shouldProcess(transformedName) || TemplateManager.templates.isEmpty()) {
                    return bytes;
                }
                boolean changed = false;
                ClassNode cnode = ASMHelper.createClassNode(bytes);
                if (cnode != null && cnode.visibleAnnotations != null) {
                    for (AnnotationNode nodes : cnode.visibleAnnotations) {
                        if (!nodes.desc.equals("Lcom/builtbroken/mc/api/InjectTemplate;")) continue;
                        String flags = null;
                        if (nodes.values != null && nodes.values.size() >= 2) {
                            flags = (String)nodes.values.get(1);
                        }
                        changed |= this.injectTemplate(cnode, flags);
                        break;
                    }
                }
                if (!changed) break block10;
                byte[] data = ASMHelper.createBytes(cnode, 2);
                if (System.getProperty("development") != null && System.getProperty("development").equalsIgnoreCase("true")) {
                    try {
                        File file = new File(".", "asmTestFolder/" + name + ".class");
                        if (!file.getParentFile().exists()) {
                            file.mkdirs();
                        }
                        FileOutputStream fos = new FileOutputStream(file);
                        fos.write(data);
                        fos.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return data;
            }
            catch (Exception e) {
                throw new RuntimeException("TemplateClassTransformer: Failed to process class " + transformedName, e);
            }
        }
        return bytes;
    }

    private boolean injectTemplate(ClassNode cnode, String flags) {
        boolean changed = false;
        if (flags == null || flags.equals("")) {
            for (InjectionTemplate template : TemplateManager.templates.values()) {
                if (template == null) continue;
                changed |= template.patch(cnode, false);
                EngineCoreMod.logger.info("TemplateClassTransformer: Injected " + template.className + " API into: " + cnode.name);
            }
        } else {
            String[] separatedFlags;
            for (String templateKey : separatedFlags = flags.split(";")) {
                InjectionTemplate template;
                if (InjectionTemplate.getTemplate(templateKey) == null || (template = InjectionTemplate.getTemplate(templateKey)) == null) continue;
                changed |= template.patch(cnode, false);
                EngineCoreMod.logger.info("TemplateClassTransformer: Injected " + template.className + " API into: " + cnode.name);
            }
        }
        return changed;
    }

    private boolean shouldProcess(String name) {
        if (name != null && !name.isEmpty()) {
            for (String path : permittedClassPaths) {
                if (!permittedClassPaths.equals(name) && !name.startsWith(path)) continue;
                String className = name.replace(".class", "").substring(name.lastIndexOf(".") + 1, name.length());
                for (String prefix : permittedPrefixClass) {
                    if (!className.startsWith(prefix)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static {
        permittedClassPaths.add("com.builtbroken");
        permittedPrefixClass.add("Tile");
        permittedPrefixClass.add("TileEntity");
    }
}

