/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.core;

import com.builtbroken.mc.core.CommonProxy;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.commands.CommandVE;
import com.builtbroken.mc.core.commands.permissions.GroupProfileHandler;
import com.builtbroken.mc.core.commands.permissions.PermissionsCommandManager;
import com.builtbroken.mc.core.commands.permissions.sub.CommandDumpPermissions;
import com.builtbroken.mc.core.commands.permissions.sub.CommandGroups;
import com.builtbroken.mc.core.commands.permissions.sub.CommandNewGroup;
import com.builtbroken.mc.core.commands.permissions.sub.CommandRemoveGroup;
import com.builtbroken.mc.core.commands.permissions.sub.GSCList;
import com.builtbroken.mc.core.commands.permissions.sub.GSCPerm;
import com.builtbroken.mc.core.commands.permissions.sub.GSCUser;
import com.builtbroken.mc.core.commands.permissions.sub.USCList;
import com.builtbroken.mc.lib.helper.ReflectionUtility;
import cpw.mods.fml.common.FMLCommonHandler;
import java.lang.reflect.Field;
import net.minecraft.server.MinecraftServer;

public class ServerProxy
extends CommonProxy {
    @Override
    public void init() {
        super.init();
        GroupProfileHandler.enablePermissions = Engine.instance.getConfig().getBoolean("EnablePermissionSystem", "Commands", Engine.runningAsDev, "Enabled Voltz Engine built in command permission system that works much like Bukkit's PermissionEx Plugin");
        if (GroupProfileHandler.enablePermissions) {
            Engine.instance.logger().info("Overriding MC's CommandManager");
            Field field = ReflectionUtility.getMCField(MinecraftServer.class, "commandManager", "field_71321_q");
            try {
                ReflectionUtility.setFinalField(FMLCommonHandler.instance().getMinecraftServerInstance(), field, (Object)new PermissionsCommandManager());
                Engine.instance.logger().info("New command manager set to " + FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D());
            }
            catch (NoSuchFieldException e) {
                Engine.instance.logger().error("Failed to override command manager as the field was not found");
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                Engine.instance.logger().error("Failed to override command manager as our access was blocked");
                e.printStackTrace();
            }
        }
        if (FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D() instanceof PermissionsCommandManager) {
            CommandVE.INSTANCE.addToNewCommand(new CommandNewGroup());
            CommandVE.INSTANCE.addToRemoveCommand(new CommandRemoveGroup());
            CommandVE.INSTANCE.addToDumpCommand(new CommandDumpPermissions());
            CommandVE.INSTANCE.addToAddUserCommand(new GSCUser(false));
            CommandVE.INSTANCE.addToRemoveUserCommand(new GSCUser(true));
            CommandVE.INSTANCE.addToAddPermCommand(new GSCPerm(false));
            CommandVE.INSTANCE.addToRemovePermCommand(new GSCPerm(true));
            CommandVE.INSTANCE.addCommand(new CommandGroups());
            CommandVE.INSTANCE.addToGroupCommand(new GSCList());
            CommandVE.INSTANCE.addToUserCommand(new USCList());
        }
    }
}

