/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.client;

import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.api.explosive.ITexturedExplosiveHandler;
import com.builtbroken.mc.api.items.explosives.IExplosiveContainerItem;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.world.explosive.ExplosiveRegistry;
import com.builtbroken.mc.prefab.items.ItemStackWrapper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.TextureStitchEvent;

public class ExplosiveRegistryClient {
    public static final HashMap<ItemStackWrapper, IIcon> EX_CORNER_ICONS = new HashMap();
    public static final HashMap<ItemStackWrapper, String> EX_CORNER_RESOURCES = new HashMap();
    @SideOnly(value=Side.CLIENT)
    public static IIcon missing_corner_icon;

    public static IIcon getCornerIconFor(ItemStack stack) {
        ItemStack item = stack;
        if (item.func_77973_b() instanceof IExplosiveContainerItem) {
            item = ((IExplosiveContainerItem)item.func_77973_b()).getExplosiveStack(stack);
        }
        if (item != null) {
            IIcon icon;
            IExplosiveHandler handler = ExplosiveRegistry.get(item);
            if (handler instanceof ITexturedExplosiveHandler && (icon = ((ITexturedExplosiveHandler)handler).getBottomLeftCornerIcon(item)) != null) {
                return icon;
            }
            ItemStackWrapper wrapper = new ItemStackWrapper(item);
            if (EX_CORNER_ICONS.containsKey(wrapper)) {
                return EX_CORNER_ICONS.get(wrapper);
            }
        }
        return missing_corner_icon;
    }

    public static void registerIcon(ItemStack item, String resource) {
        ItemStackWrapper wrapper = new ItemStackWrapper(item);
        if (!EX_CORNER_RESOURCES.containsKey(wrapper)) {
            EX_CORNER_RESOURCES.put(wrapper, resource);
        } else {
            Engine.logger().error("Something attempt to register an existing resource location for loading ex icons", (Throwable)new RuntimeException());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onStitch(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 0) {
            for (IExplosiveHandler iExplosiveHandler : ExplosiveRegistry.getExplosives()) {
                if (!(iExplosiveHandler instanceof ITexturedExplosiveHandler)) continue;
                ((ITexturedExplosiveHandler)iExplosiveHandler).registerExplosiveHandlerIcons((IIconRegister)event.map, true);
            }
        } else if (event.map.func_130086_a() == 1) {
            for (IExplosiveHandler iExplosiveHandler : ExplosiveRegistry.getExplosives()) {
                if (!(iExplosiveHandler instanceof ITexturedExplosiveHandler)) continue;
                ((ITexturedExplosiveHandler)iExplosiveHandler).registerExplosiveHandlerIcons((IIconRegister)event.map, false);
            }
            EX_CORNER_ICONS.clear();
            for (Map.Entry entry : EX_CORNER_RESOURCES.entrySet()) {
                EX_CORNER_ICONS.put((ItemStackWrapper)entry.getKey(), event.map.func_94245_a((String)entry.getValue()));
            }
            missing_corner_icon = event.map.func_94245_a("voltzengine:ex.icon.missing");
        }
    }
}

