/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.api.event;

import net.minecraft.entity.Entity;
import net.minecraft.world.Explosion;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TriggerCause {
    public final String triggerName;
    public float effectScaleChange = 1.0f;

    public TriggerCause(String name) {
        this.triggerName = name;
    }

    public static class TriggerCauseRedstone
    extends TriggerCauseSide {
        public final int strength;

        public TriggerCauseRedstone(ForgeDirection side, int strength) {
            super("redstone", side);
            this.strength = strength;
        }
    }

    public static class TriggerCauseFire
    extends TriggerCauseSide {
        public TriggerCauseFire(ForgeDirection side) {
            super("fire", side);
        }
    }

    public static class TriggerCauseExplosion
    extends TriggerCause {
        public final Explosion source;

        public TriggerCauseExplosion(Explosion source) {
            super("explosion");
            this.source = source;
        }
    }

    public static class TriggerCauseEntity
    extends TriggerCause {
        public final Entity source;

        public TriggerCauseEntity(Entity source) {
            this("entity", source);
        }

        public TriggerCauseEntity(String name, Entity source) {
            super(name);
            this.source = source;
        }
    }

    public static class TriggerCauseSide
    extends TriggerCause {
        public final ForgeDirection triggeredSide;

        public TriggerCauseSide(String name, ForgeDirection side) {
            super(name);
            this.triggeredSide = side;
        }
    }
}

