/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.renderers.player.renderhooks;

import com.InfinityRaider.AgriCraft.renderers.player.renderhooks.PlayerEffectRenderer;
import com.InfinityRaider.AgriCraft.renderers.player.renderhooks.PlayerEffectRendererButterfly;
import com.InfinityRaider.AgriCraft.renderers.player.renderhooks.PlayerEffectRendererEntityBat;
import com.InfinityRaider.AgriCraft.renderers.player.renderhooks.PlayerEffectRendererEntityDragon;
import com.InfinityRaider.AgriCraft.renderers.player.renderhooks.PlayerEffectRendererNavi;
import com.InfinityRaider.AgriCraft.renderers.player.renderhooks.PlayerEffectRendererOrbs;
import com.InfinityRaider.AgriCraft.renderers.player.renderhooks.PlayerEffectRendererParticlesEnchanted;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class RenderPlayerHooks {
    private static final String[] modIds = new String[]{"3DManeuverGear", "AgriCraft", "Elemancy", "ModularArmour"};
    private HashMap<String, PlayerEffectRenderer> activeEffectRenderers;
    private static boolean hasInit = false;

    public RenderPlayerHooks() {
        if (!hasInit) {
            hasInit = true;
            this.init();
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("hasInit", true);
            for (String modid : modIds) {
                if (modid.equals("AgriCraft")) continue;
                FMLInterModComms.sendMessage((String)modid, (String)"renderHooks", (NBTTagCompound)tag);
            }
        }
    }

    public static void onIMCMessage(FMLInterModComms.IMCMessage message) {
        if (hasInit) {
            return;
        }
        if (!message.isNBTMessage()) {
            return;
        }
        if (message.key.equals("renderHooks")) {
            for (String id : modIds) {
                if (!id.equals(message.getSender())) continue;
                hasInit = true;
                return;
            }
        }
    }

    private void init() {
        this.registerPlayerEffectRenderer(new PlayerEffectRendererOrbs());
        this.registerPlayerEffectRenderer(new PlayerEffectRendererNavi());
        this.registerPlayerEffectRenderer(new PlayerEffectRendererParticlesEnchanted());
        this.registerPlayerEffectRenderer(new PlayerEffectRendererEntityDragon());
        this.registerPlayerEffectRenderer(new PlayerEffectRendererEntityBat());
        this.registerPlayerEffectRenderer(new PlayerEffectRendererButterfly());
    }

    private void registerPlayerEffectRenderer(PlayerEffectRenderer renderer) {
        if (this.activeEffectRenderers == null) {
            this.activeEffectRenderers = new HashMap();
        }
        for (String name : renderer.getDisplayNames()) {
            this.activeEffectRenderers.put(name, renderer);
        }
    }

    @SubscribeEvent
    public void RenderPlayerEffects(RenderPlayerEvent.Specials.Post event) {
        if (this.activeEffectRenderers.containsKey(event.entityPlayer.getDisplayName()) && !event.entityPlayer.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            GL11.glPushMatrix();
            this.activeEffectRenderers.get(event.entityPlayer.getDisplayName()).renderEffects(event.entityPlayer, event.renderer, event.partialRenderTick);
            GL11.glPopMatrix();
        }
    }
}

