/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.init;

import com.InfinityRaider.AgriCraft.AgriCraft;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.handler.VillageCreationHandler;
import com.InfinityRaider.AgriCraft.handler.VillagerTradeHandler;
import com.InfinityRaider.AgriCraft.world.StructureGreenhouse;
import com.InfinityRaider.AgriCraft.world.StructureGreenhouseIrrigated;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.util.Collection;
import net.minecraft.world.gen.structure.MapGenStructureIO;

public class WorldGen {
    private static int villagerId;

    public static void init() {
        if (!ConfigurationHandler.disableWorldGen) {
            if (ConfigurationHandler.villagerEnabled) {
                Collection usedIds = VillagerRegistry.getRegisteredVillagers();
                int id = 5;
                while (usedIds.contains(id)) {
                    ++id;
                }
                WorldGen.registerVillager(id);
            }
            MapGenStructureIO.func_143031_a(StructureGreenhouse.class, (String)"AgriCraft:Greenhouse");
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageCreationHandler.GreenhouseHandler());
            if (!ConfigurationHandler.disableIrrigation) {
                MapGenStructureIO.func_143031_a(StructureGreenhouseIrrigated.class, (String)"AgriCraft:GreenhouseIrrigated");
                VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageCreationHandler.GreenhouseIrrigatedHandler());
            }
        }
    }

    public static int getVillagerId() {
        return villagerId;
    }

    private static void registerVillager(int id) {
        VillagerRegistry.instance().registerVillagerId(id);
        VillagerRegistry.instance().registerVillageTradeHandler(id, (VillagerRegistry.IVillageTradeHandler)new VillagerTradeHandler());
        AgriCraft.proxy.registerVillagerSkin(id, "textures/entities/villager.png");
        villagerId = id;
    }
}

