/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.utils.fluids;

import buildcraftAdditions.api.networking.ISyncObject;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class Tank
extends FluidTank
implements ISyncObject {
    protected final String name;

    public Tank(int capacity, TileEntity tile, String name) {
        super(capacity);
        this.tile = tile;
        this.name = name;
    }

    public Tank(int capacity) {
        this(capacity, null, "");
    }

    public boolean isEmpty() {
        return this.fluid == null || this.fluid.amount <= 0;
    }

    public boolean isFull() {
        return this.fluid != null && this.fluid.amount >= this.capacity;
    }

    public int getFreeSpace() {
        return this.getCapacity() - this.getFluidAmount();
    }

    public Fluid getFluidType() {
        if (this.fluid == null) {
            return null;
        }
        return this.fluid.getFluid();
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack drained = null;
        if (this.fluid != null && this.fluid.isFluidEqual(resource)) {
            drained = this.drain(resource.amount, doDrain);
        }
        return drained;
    }

    public String toString() {
        return this.name + ": " + this.getFluidAmount() + " / " + this.capacity + " mB" + (this.fluid != null ? " of " + this.fluid.getLocalizedName() : "");
    }

    @Override
    public void writeToByteBuff(ByteBuf buf) {
        buf.writeInt(this.fluid != null ? this.fluid.getFluidID() : -1);
        buf.writeInt(this.getFluidAmount());
        ByteBufUtils.writeTag((ByteBuf)buf, this.fluid != null ? this.fluid.tag : null);
    }

    @Override
    public void readFromByteBuff(ByteBuf buf) {
        int id = buf.readInt();
        int amount = buf.readInt();
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        if (id < 0 || amount <= 0) {
            this.setFluid(null);
        } else {
            this.setFluid(new FluidStack(FluidRegistry.getFluid((int)id), amount, tag));
        }
    }
}

