/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.utils.fluids;

import buildcraftAdditions.utils.fluids.IFluidAcceptor;
import buildcraftAdditions.utils.fluids.Tank;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class RestrictedTank
extends Tank {
    protected final IFluidAcceptor acceptor;

    public RestrictedTank(String name, int capacity, TileEntity tile, IFluidAcceptor acceptor) {
        super(capacity, tile, name);
        this.acceptor = acceptor;
    }

    public void setFluid(FluidStack fluid) {
        if (this.acceptor.accepts(fluid)) {
            super.setFluid(fluid);
        }
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.acceptor.accepts(resource)) {
            return super.fill(resource, doFill);
        }
        return 0;
    }

    public boolean canFill(Fluid fluid) {
        return this.acceptor.accepts(new FluidStack(fluid, 1));
    }

    @Override
    public String toString() {
        return super.toString() + ", Restrictions: [" + this.acceptor.getDescription() + "]";
    }
}

