/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.utils.fluids;

import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.CraftingResult;
import buildcraft.api.recipes.IFlexibleCrafter;
import buildcraft.api.recipes.IFlexibleRecipe;
import buildcraftAdditions.BuildcraftAdditions;
import buildcraftAdditions.api.recipe.BCARecipeManager;
import buildcraftAdditions.blocks.FluidBlockBase;
import buildcraftAdditions.core.BucketHandler;
import buildcraftAdditions.core.Logger;
import buildcraftAdditions.items.ItemBucketBCA;
import buildcraftAdditions.items.itemBlocks.ItemBlockFluid;
import buildcraftAdditions.utils.DummyFlexibleCrafter;
import buildcraftAdditions.utils.Utils;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class RefineryRecipeConverter {
    public static FluidStack[] inputs;
    public static FluidStack[] outputs;
    public static FluidStack[] gasses;

    public static void doYourThing() {
        int teller = 0;
        int fluids = FluidRegistry.getRegisteredFluids().size();
        CraftingResult[] results = new CraftingResult[fluids];
        inputs = new FluidStack[fluids];
        outputs = new FluidStack[fluids];
        gasses = new FluidStack[fluids];
        Collection recipes = BuildcraftRecipeRegistry.refinery.getRecipes();
        for (IFlexibleRecipe recipe : recipes) {
            DummyFlexibleCrafter dummy = new DummyFlexibleCrafter();
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                if (fluid == null) continue;
                dummy.input.setFluid(new FluidStack(fluid, 1000));
                dummy.output.setFluid(null);
                CraftingResult currentResult = recipe.craft((IFlexibleCrafter)dummy, false);
                if (currentResult == null) continue;
                results[teller] = currentResult;
                dummy.output.fill(((FluidStack)currentResult.crafted).copy(), true);
                RefineryRecipeConverter.outputs[teller] = dummy.output.getFluid();
                RefineryRecipeConverter.inputs[teller] = new FluidStack(dummy.input.getFluid(), 1000 - dummy.input.getFluidAmount());
                ++teller;
                Logger.info("Buildcraft refinery recipe detected, input: " + dummy.input.getFluid().getLocalizedName() + ", output: " + dummy.output.getFluid().getLocalizedName());
            }
        }
        for (int t = 0; t < teller; ++t) {
            BCAGasFluid fluid = new BCAGasFluid(((FluidStack)results[t].crafted).getFluid().getName() + "Gas", ((FluidStack)results[t].crafted).getFluid());
            fluid.setDensity(-50);
            fluid.setGaseous(true);
            fluid.setIcons(((FluidStack)results[t].crafted).getFluid().getStillIcon(), ((FluidStack)results[t].crafted).getFluid().getFlowingIcon());
            fluid.setTemperature(results[t].energyCost);
            fluid.setUnlocalizedName(((FluidStack)results[t].crafted).getFluid().getUnlocalizedName().replaceFirst("fluid\\.", "") + ".gas");
            fluid.setViscosity(5);
            FluidRegistry.registerFluid((Fluid)fluid);
            RefineryRecipeConverter.gasses[t] = new FluidStack((Fluid)fluid, RefineryRecipeConverter.outputs[t].amount);
            FluidBlockBase fluidBlock = new FluidBlockBase(fluid);
            GameRegistry.registerBlock((Block)fluidBlock, ItemBlockFluid.class, (String)(fluid.getName() + "Block"));
            fluid.setBlock((Block)fluidBlock);
            ItemBucketBCA bucket = new ItemBucketBCA(fluid);
            BucketHandler.registerBucket(fluid, new ItemStack((Item)bucket));
            if (inputs[t].getFluid().getBlock() == null) {
                fluidBlock = new FluidBlockBase(inputs[t].getFluid());
                GameRegistry.registerBlock((Block)fluidBlock, (String)(inputs[t].getFluid().getName() + "Block"));
            }
            BCARecipeManager.cooling.addRecipe(new FluidStack((Fluid)fluid, 1), new FluidStack(outputs[t], 1), (float)results[t].energyCost / 2000.0f);
            BCARecipeManager.refinery.addRecipe(inputs[t], new FluidStack((Fluid)fluid, RefineryRecipeConverter.outputs[t].amount), results[t].energyCost);
        }
        BuildcraftAdditions.proxy.registerBucketRenderer();
    }

    public static class BCAGasFluid
    extends Fluid {
        private final FluidStack fluid;

        public BCAGasFluid(String fluidName, Fluid fluid) {
            super(fluidName);
            this.fluid = new FluidStack(fluid, 1000);
        }

        public int getColor() {
            return 11580342;
        }

        public String getLocalizedName(FluidStack stack) {
            return Utils.localizeFormatted("fluid.gas.name", this.fluid.getLocalizedName());
        }
    }
}

