/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.utils.fluids;

import buildcraftAdditions.utils.fluids.IFluidAcceptor;
import buildcraftAdditions.utils.fluids.RestrictedTank;
import java.util.ArrayList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BlacklistedTank
extends RestrictedTank {
    public BlacklistedTank(String name, int capacity, TileEntity tile, final Fluid ... fluids) {
        super(name, capacity, tile, new IFluidAcceptor(){

            @Override
            public boolean accepts(FluidStack fluidStack) {
                if (fluidStack == null) {
                    return false;
                }
                Fluid fluid = fluidStack.getFluid();
                if (fluid == null) {
                    return false;
                }
                if (fluids == null) {
                    return true;
                }
                for (Fluid f : fluids) {
                    if (f == null || f.getID() != fluid.getID()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public String getDescription() {
                ArrayList<String> list = new ArrayList<String>();
                if (fluids != null) {
                    for (Fluid f : fluids) {
                        if (f == null) continue;
                        list.add(f.getName());
                    }
                }
                list.trimToSize();
                return "Blacklist: " + list.toString();
            }

            public String toString() {
                return this.getDescription();
            }
        });
    }
}

