/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.utils;

import buildcraft.api.transport.IInjectable;
import buildcraftAdditions.api.configurableOutput.EnumPriority;
import buildcraftAdditions.api.configurableOutput.SideConfiguration;
import buildcraftAdditions.reference.enums.EnumMachineUpgrades;
import buildcraftAdditions.tileEntities.interfaces.IUpgradableMachine;
import buildcraftAdditions.utils.Location;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class Utils {
    public static final String[] COLOR_NAMES = new String[]{"white", "orange", "magenta", "lightBlue", "yellow", "lime", "pink", "gray", "lightGray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    public static final String[] CHATCOLORS = new String[]{"white", "gold", "light_purple", "aqua", "yellow", "green", "light_purple", "dark_gray", "gray", "dark_aqua", "dark_purple", "dark_blue", "dark_red", "dark_green", "red", "black"};

    public static FluidStack getFluidStackFromItemStack(ItemStack itemStack) {
        if (itemStack.field_77990_d == null || !itemStack.func_77978_p().func_150297_b("Fluid", 10)) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.func_77978_p().func_74775_l("Fluid"));
    }

    public static ForgeDirection get2dOrientation(EntityLivingBase entityliving) {
        ForgeDirection[] orientationTable = new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.EAST};
        int orientationIndex = MathHelper.func_76128_c((double)(((double)entityliving.field_70177_z + 45.0) / 90.0)) & 3;
        return orientationTable[orientationIndex];
    }

    public static ForgeDirection get3dOrientation(EntityLivingBase entity) {
        if (entity.field_70125_A < -45.5f) {
            return ForgeDirection.UP;
        }
        if (entity.field_70125_A > 45.5f) {
            return ForgeDirection.DOWN;
        }
        return Utils.get2dOrientation(entity);
    }

    public static int[] createSlotArray(int first, int count) {
        int[] slots = new int[count];
        for (int k = first; k < first + count; ++k) {
            slots[k - first] = k;
        }
        return slots;
    }

    public static String localize(String key) {
        return ("" + StatCollector.func_74838_a((String)key)).trim();
    }

    public static String localizeFormatted(String key, Object ... objects) {
        return ("" + StatCollector.func_74837_a((String)key, (Object[])objects)).trim();
    }

    public static String localizeAllFormatted(String key, String ... strings) {
        Object[] objects = new Object[strings != null ? strings.length : 0];
        if (strings != null) {
            for (int i = 0; i < objects.length; ++i) {
                String string = strings[i];
                if (string == null) continue;
                objects[i] = Utils.localize(string);
            }
        }
        return Utils.localizeFormatted(key, objects);
    }

    public static String getRFInfoTooltip(int energy, int maxEnergy) {
        int percent = maxEnergy > 0 ? (int)((double)energy / (double)maxEnergy * 100.0) : 0;
        String color = "";
        color = percent >= 75 ? color + EnumChatFormatting.DARK_GREEN : (percent >= 60 ? color + EnumChatFormatting.GREEN : (percent >= 45 ? color + EnumChatFormatting.YELLOW : (percent >= 30 ? color + EnumChatFormatting.GOLD : (percent >= 15 ? color + EnumChatFormatting.RED : color + EnumChatFormatting.DARK_RED))));
        return color + Utils.localizeFormatted("rf.info", energy, maxEnergy);
    }

    public static String getRFPercentTooltip(int energy, int maxEnergy) {
        int percent = maxEnergy > 0 ? (int)((double)energy / (double)maxEnergy * 100.0) : 0;
        String color = "";
        color = percent >= 75 ? color + EnumChatFormatting.DARK_GREEN : (percent >= 60 ? color + EnumChatFormatting.GREEN : (percent >= 45 ? color + EnumChatFormatting.YELLOW : (percent >= 30 ? color + EnumChatFormatting.GOLD : (percent >= 15 ? color + EnumChatFormatting.RED : color + EnumChatFormatting.DARK_RED))));
        return color + percent + "%";
    }

    public static String colorText(String text, EnumChatFormatting color) {
        return ("" + color + text).trim();
    }

    public static String decapitalizeFirstChar(String string) {
        return !Strings.isNullOrEmpty((String)string) ? Character.toLowerCase(string.charAt(0)) + string.substring(1) : null;
    }

    public static void dropInventory(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            if (tile instanceof IInventory) {
                IInventory inventory = (IInventory)tile;
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    Utils.dropItemstack(world, x, y, z, inventory.func_70301_a(i));
                    inventory.func_70299_a(i, null);
                }
            }
            if (tile instanceof IUpgradableMachine) {
                IUpgradableMachine machine = (IUpgradableMachine)tile;
                Set<EnumMachineUpgrades> upgrades = machine.getInstalledUpgrades();
                for (int i = 0; i < (upgrades != null ? upgrades.size() : 0); ++i) {
                    machine.removeUpgrade();
                }
            }
        }
    }

    public static void dropItemstack(World world, int x, int y, int z, ItemStack stack) {
        if (!world.field_72995_K && stack != null && stack.field_77994_a > 0 && stack.func_77973_b() != null) {
            float rx = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float ry = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float rz = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), stack.func_77946_l());
            float factor = 0.05f;
            entityItem.field_70159_w = world.field_73012_v.nextGaussian() * (double)factor;
            entityItem.field_70181_x = world.field_73012_v.nextGaussian() * (double)factor + 0.2000000029802322;
            entityItem.field_70179_y = world.field_73012_v.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
        }
    }

    public static void dropItemstacksAtEntity(Entity entity, List<ItemStack> stacks) {
        if (!stacks.isEmpty()) {
            for (ItemStack stack : stacks) {
                Utils.dropItemstackAtEntity(entity, stack);
            }
        }
    }

    public static void dropItemstackAtEntity(Entity entity, ItemStack stack) {
        if (!entity.field_70170_p.field_72995_K) {
            EntityItem entityItem = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u + (double)(entity.func_70047_e() / 2.0f), entity.field_70161_v, stack.func_77946_l());
            entity.field_70170_p.func_72838_d((Entity)entityItem);
            if (entity instanceof EntityPlayer) {
                entityItem.func_70100_b_((EntityPlayer)entity);
            }
        }
    }

    public static void addToPlayerInv(EntityPlayer player, ItemStack stack) {
        if (stack != null && stack.field_77994_a > 0 && stack.func_77973_b() != null && !player.field_71071_by.func_70441_a(stack.func_77946_l())) {
            player.func_71019_a(stack.func_77946_l(), false);
        }
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static boolean areItemStacksEqualRecipe(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.func_77973_b() == stack2.func_77973_b() && (stack1.func_77960_j() == stack2.func_77960_j() || stack1.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == Short.MAX_VALUE || stack1.func_77973_b().func_77645_m());
    }

    public static boolean areItemStacksMergeable(ItemStack existingStack, ItemStack stackToAdd) {
        return existingStack == null || stackToAdd == null || existingStack != null && stackToAdd != null && existingStack.func_77969_a(stackToAdd) && ItemStack.func_77970_a((ItemStack)existingStack, (ItemStack)stackToAdd);
    }

    public static boolean areItemStacksMergeableStrict(ItemStack existingStack, ItemStack stackToAdd) {
        return existingStack == null || stackToAdd == null || existingStack != null && stackToAdd != null && existingStack.func_77969_a(stackToAdd) && ItemStack.func_77970_a((ItemStack)existingStack, (ItemStack)stackToAdd) && existingStack.field_77994_a + stackToAdd.field_77994_a <= existingStack.func_77976_d();
    }

    public static ItemStack outputStack(Location from, ItemStack output, SideConfiguration configuration) {
        if (from == null || output == null || output.func_77973_b() == null || output.field_77994_a <= 0 || configuration == null) {
            return output;
        }
        for (EnumPriority priority : EnumPriority.values()) {
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                Location location = from.copy();
                if (configuration.getPriority(direction) != priority || !configuration.canSend(direction)) continue;
                location.move(direction);
                TileEntity tile = location.getTileEntity();
                if (tile instanceof IInjectable) {
                    IInjectable injectable = (IInjectable)tile;
                    if (output == null || !injectable.canInjectItems(direction.getOpposite())) continue;
                    int leftOver = injectable.injectItem(output.func_77946_l(), true, direction.getOpposite(), null);
                    output.field_77994_a -= leftOver;
                    if (output.field_77994_a > 0) continue;
                    output = null;
                    continue;
                }
                if (!(tile instanceof IInventory)) continue;
                IInventory outputInventory = (IInventory)tile;
                ISidedInventory sidedInventory = null;
                if (tile instanceof ISidedInventory) {
                    sidedInventory = (ISidedInventory)tile;
                }
                HashSet allowedSlots = Sets.newHashSet();
                for (int slot = 0; slot < outputInventory.func_70302_i_(); ++slot) {
                    allowedSlots.add(slot);
                }
                if (sidedInventory != null) {
                    HashSet accessibleSlotsSet = Sets.newHashSet();
                    int[] accessibleSlots = sidedInventory.func_94128_d(direction.getOpposite().ordinal());
                    if (accessibleSlots != null) {
                        for (int slot : accessibleSlots) {
                            accessibleSlotsSet.add(slot);
                        }
                    }
                    allowedSlots.retainAll(accessibleSlotsSet);
                }
                int stackLimit = outputInventory.func_70297_j_();
                Iterator iterator = allowedSlots.iterator();
                while (iterator.hasNext()) {
                    int toMove;
                    ItemStack stack;
                    int slot = (Integer)iterator.next();
                    if (output == null || output.func_77973_b() == null || output.field_77994_a <= 0 || sidedInventory != null && !sidedInventory.func_102007_a(slot, output, direction.getOpposite().ordinal()) || !Utils.areItemStacksMergeable(stack = outputInventory.func_70301_a(slot), output)) continue;
                    if (stack == null) {
                        toMove = stackLimit;
                        stack = output.func_77946_l();
                        stack.field_77994_a = 0;
                    } else {
                        toMove = stackLimit - stack.field_77994_a;
                    }
                    if (toMove > output.field_77994_a) {
                        toMove = output.field_77994_a;
                    }
                    stack.field_77994_a += toMove;
                    output.field_77994_a -= toMove;
                    outputInventory.func_70299_a(slot, stack);
                    outputInventory.func_70296_d();
                    if (output.field_77994_a > 0) continue;
                    output = null;
                }
            }
        }
        return output;
    }

    public static boolean harvestBlock(World world, int x, int y, int z, EntityPlayer player) {
        BlockEvent.BreakEvent event;
        int meta;
        Block block;
        if (world.func_147437_c(x, y, z)) {
            return false;
        }
        EntityPlayerMP playerMP = null;
        if (player instanceof EntityPlayerMP) {
            playerMP = (EntityPlayerMP)player;
        }
        if (!ForgeHooks.canHarvestBlock((Block)(block = world.func_147439_a(x, y, z)), (EntityPlayer)player, (int)(meta = world.func_72805_g(x, y, z)))) {
            return false;
        }
        if (playerMP != null && (event = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)playerMP.field_71134_c.func_73081_b(), (EntityPlayerMP)playerMP, (int)x, (int)y, (int)z)).isCanceled()) {
            return false;
        }
        if (player.field_71075_bZ.field_75098_d) {
            if (!world.field_72995_K) {
                block.func_149681_a(world, x, y, z, meta, player);
            } else {
                world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) | meta << 12);
            }
            if (block.removedByPlayer(world, player, x, y, z, false)) {
                block.func_149664_b(world, x, y, z, meta);
            }
            if (!world.field_72995_K && playerMP != null) {
                playerMP.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
            } else {
                Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C07PacketPlayerDigging(2, x, y, z, Minecraft.func_71410_x().field_71476_x.field_72310_e));
            }
            return true;
        }
        if (!world.field_72995_K) {
            block.func_149681_a(world, x, y, z, meta, player);
            if (block.removedByPlayer(world, player, x, y, z, true)) {
                block.func_149664_b(world, x, y, z, meta);
                block.func_149636_a(world, player, x, y, z, meta);
            }
            if (playerMP != null) {
                playerMP.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
            }
        } else {
            world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) | meta << 12);
            if (block.removedByPlayer(world, player, x, y, z, true)) {
                block.func_149664_b(world, x, y, z, meta);
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C07PacketPlayerDigging(2, x, y, z, Minecraft.func_71410_x().field_71476_x.field_72310_e));
        }
        return true;
    }

    public static List<ItemStack> getDropsForCapsule(int tier) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        switch (tier) {
            case 3: {
                list.add(new ItemStack(Items.field_151045_i));
                list.add(new ItemStack(Items.field_151045_i));
                list.add(new ItemStack(Items.field_151045_i));
                list.add(new ItemStack(Items.field_151045_i));
                list.add(new ItemStack(Items.field_151045_i));
                list.add(new ItemStack(Items.field_151045_i));
                list.add(new ItemStack(Items.field_151166_bC));
                list.add(new ItemStack(Items.field_151166_bC));
            }
            case 2: {
                list.add(new ItemStack(Items.field_151043_k));
                list.add(new ItemStack(Items.field_151043_k));
                list.add(new ItemStack(Items.field_151043_k));
                list.add(new ItemStack(Items.field_151043_k));
                list.add(new ItemStack(Items.field_151043_k));
                list.add(new ItemStack(Items.field_151043_k));
                list.add(new ItemStack(Items.field_151045_i));
                list.add(new ItemStack(Items.field_151045_i));
            }
            case 1: {
                list.add(new ItemStack(Items.field_151043_k));
                list.add(new ItemStack(Items.field_151043_k));
                list.add(new ItemStack(Items.field_151042_j));
                list.add(new ItemStack(Items.field_151042_j));
                list.add(new ItemStack(Items.field_151042_j));
                list.add(new ItemStack(Items.field_151042_j));
                list.add(new ItemStack(Items.field_151042_j));
                list.add(new ItemStack(Items.field_151042_j));
                list.add(new ItemStack(Blocks.field_150451_bX));
            }
        }
        Random random = new Random();
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (!list.isEmpty()) {
            for (ItemStack stack : list) {
                if (!random.nextBoolean()) continue;
                drops.add(stack);
            }
        }
        return drops;
    }
}

