/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.utils;

import net.minecraftforge.common.util.ForgeDirection;

public class RotationUtils {
    public static ForgeDirection[] rotateDirections(int rotationIndex, ForgeDirection ... directions) {
        int length = directions.length;
        ForgeDirection[] rotatedDirections = new ForgeDirection[length];
        for (int t = 0; t < length; ++t) {
            rotatedDirections[t] = RotationUtils.rotatateDirection(directions[t], rotationIndex);
        }
        return rotatedDirections;
    }

    public static ForgeDirection rotatateDirection(ForgeDirection direction, int rotationIndex) {
        switch (rotationIndex) {
            case 0: {
                return direction;
            }
            case 1: {
                if (direction == ForgeDirection.NORTH) {
                    return ForgeDirection.EAST;
                }
                if (direction == ForgeDirection.EAST) {
                    return ForgeDirection.SOUTH;
                }
                if (direction == ForgeDirection.SOUTH) {
                    return ForgeDirection.WEST;
                }
                if (direction == ForgeDirection.WEST) {
                    return ForgeDirection.NORTH;
                }
                return direction;
            }
            case 2: {
                if (direction == ForgeDirection.UP || direction == ForgeDirection.DOWN) {
                    return direction;
                }
                return direction.getOpposite();
            }
            case 3: {
                if (direction == ForgeDirection.NORTH) {
                    return ForgeDirection.WEST;
                }
                if (direction == ForgeDirection.EAST) {
                    return ForgeDirection.NORTH;
                }
                if (direction == ForgeDirection.SOUTH) {
                    return ForgeDirection.EAST;
                }
                if (direction == ForgeDirection.WEST) {
                    return ForgeDirection.SOUTH;
                }
                return direction;
            }
        }
        return direction;
    }
}

