/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.utils;

import buildcraftAdditions.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    public static final ResourceLocation MC_BLOCK_SHEET = TextureMap.field_110575_b;
    public static final ResourceLocation MC_ITEM_SHEET = TextureMap.field_110576_c;

    public static TextureManager textureManager() {
        return Minecraft.func_71410_x().func_110434_K();
    }

    public static void bindTexture(ResourceLocation texture) {
        RenderUtils.textureManager().func_110577_a(texture);
    }

    public static void drawFluid(FluidStack fluid, int level, int x, int y, int width, int height) {
        int i;
        if (fluid == null || fluid.getFluid() == null) {
            return;
        }
        IIcon icon = fluid.getFluid().getIcon(fluid);
        RenderUtils.bindTexture(MC_BLOCK_SHEET);
        Utils.setGLColorFromInt(fluid.getFluid().getColor(fluid));
        int fullX = width / 16;
        int fullY = height / 16;
        int lastX = width - fullX * 16;
        int lastY = height - fullY * 16;
        int fullLvl = (height - level) / 16;
        int lastLvl = height - level - fullLvl * 16;
        for (i = 0; i < fullX; ++i) {
            for (int j = 0; j < fullY; ++j) {
                if (j < fullLvl) continue;
                RenderUtils.drawCutIcon(icon, x + i * 16, y + j * 16, 16, 16, j == fullLvl ? (float)lastLvl : 0.0f);
            }
        }
        for (i = 0; i < fullX; ++i) {
            RenderUtils.drawCutIcon(icon, x + i * 16, y + fullY * 16, 16, lastY, fullLvl == fullY ? (float)lastLvl : 0.0f);
        }
        for (i = 0; i < fullY; ++i) {
            if (i < fullLvl) continue;
            RenderUtils.drawCutIcon(icon, x + fullX * 16, y + i * 16, lastX, 16, i == fullLvl ? (float)lastLvl : 0.0f);
        }
        RenderUtils.drawCutIcon(icon, x + fullX * 16, y + fullY * 16, lastX, lastY, fullLvl == fullY ? (float)lastLvl : 0.0f);
    }

    public static void drawCutIcon(IIcon icon, int x, int y, int width, int height, float cut) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78374_a((double)x, (double)(y + height), 0.0, (double)icon.func_94209_e(), (double)icon.func_94207_b((double)height));
        tess.func_78374_a((double)(x + width), (double)(y + height), 0.0, (double)icon.func_94214_a((double)width), (double)icon.func_94207_b((double)height));
        tess.func_78374_a((double)(x + width), (double)((float)y + cut), 0.0, (double)icon.func_94214_a((double)width), (double)icon.func_94207_b((double)cut));
        tess.func_78374_a((double)x, (double)((float)y + cut), 0.0, (double)icon.func_94209_e(), (double)icon.func_94207_b((double)cut));
        tess.func_78381_a();
    }

    public static IIcon registerIcon(IIconRegister register, String name) {
        return register.func_94245_a("bcadditions:" + name);
    }

    public static void drawImage(ResourceLocation image, int x, int y, int width, int height) {
        RenderUtils.bindTexture(image);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78374_a((double)x, (double)(y + height), 0.0, 0.0, 1.0);
        tess.func_78374_a((double)(x + width), (double)(y + height), 0.0, 1.0, 1.0);
        tess.func_78374_a((double)(x + width), (double)y, 0.0, 1.0, 0.0);
        tess.func_78374_a((double)x, (double)y, 0.0, 0.0, 0.0);
        tess.func_78381_a();
    }
}

