/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.utils;

import buildcraftAdditions.BuildcraftAdditions;
import buildcraftAdditions.tileEntities.interfaces.IOwnableMachine;
import cpw.mods.fml.common.FMLCommonHandler;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.UsernameCache;

public class PlayerUtils {
    private static final String hex = "[0-9a-fA-F]";
    private static final Pattern uuidPattern = Pattern.compile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");

    public static UUID getPlayerUUID(EntityPlayer player) {
        return player != null && player.func_146103_bH() != null ? PlayerUtils.getPlayerUUID(player.func_146103_bH().getName()) : null;
    }

    public static String getPlayerUUIDString(EntityPlayer player) {
        return player != null && player.func_146103_bH() != null ? PlayerUtils.getUUIDString(PlayerUtils.getPlayerUUID(player.func_146103_bH().getName())) : null;
    }

    public static UUID getPlayerUUID(String name) {
        if (name != null && !name.isEmpty()) {
            for (Map.Entry entry : UsernameCache.getMap().entrySet()) {
                if (entry == null || entry.getValue() == null || !((String)entry.getValue()).equalsIgnoreCase(name)) continue;
                return (UUID)entry.getKey();
            }
        }
        return null;
    }

    public static String getPlayerName(UUID uuid) {
        String name = null;
        if (uuid != null) {
            name = UsernameCache.getLastKnownUsername((UUID)uuid);
        }
        return name != null ? name : "";
    }

    public static String getUUIDString(UUID uuid) {
        return uuid != null ? uuid.toString() : "";
    }

    public static UUID getUUID(String uuid) {
        return PlayerUtils.isUUIDString(uuid) ? UUID.fromString(uuid) : null;
    }

    public static boolean playerMatches(UUID uuid, String name) {
        UUID playerUUID = PlayerUtils.getPlayerUUID(name);
        return playerUUID != null && playerUUID.equals(uuid);
    }

    public static boolean playerMatches(IOwnableMachine tile, String name) {
        UUID playerUUID = PlayerUtils.getPlayerUUID(name);
        return playerUUID != null && playerUUID.equals(tile.getOwner());
    }

    public static boolean playerMatches(UUID uuid, EntityPlayer player) {
        UUID playerUUID = PlayerUtils.getPlayerUUID(player);
        return playerUUID != null && playerUUID.equals(uuid);
    }

    public static boolean playerMatches(IOwnableMachine tile, EntityPlayer player) {
        UUID playerUUID = PlayerUtils.getPlayerUUID(player);
        return playerUUID != null && playerUUID.equals(tile.getOwner());
    }

    public static boolean playerMatches(String uuid, String name) {
        UUID playerUUID = PlayerUtils.getPlayerUUID(name);
        return playerUUID != null && playerUUID.equals(PlayerUtils.getUUID(uuid));
    }

    public static boolean playerMatches(String uuid, EntityPlayer player) {
        UUID playerUUID = PlayerUtils.getPlayerUUID(player);
        return playerUUID != null && playerUUID.equals(PlayerUtils.getUUID(uuid));
    }

    public static EntityPlayer getPlayer(String name) {
        return PlayerUtils.getPlayer(PlayerUtils.getPlayerUUID(name));
    }

    public static EntityPlayer getPlayer(UUID uuid) {
        if (uuid != null) {
            List list;
            if (PlayerUtils.playerMatches(uuid, BuildcraftAdditions.proxy.getClientPlayer())) {
                return BuildcraftAdditions.proxy.getClientPlayer();
            }
            List list2 = FMLCommonHandler.instance().getMinecraftServerInstance() != null && FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab() != null && FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().field_72404_b != null ? FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().field_72404_b : (list = BuildcraftAdditions.proxy.getClientWorld() != null && BuildcraftAdditions.proxy.getClientWorld().func_72910_y() != null ? BuildcraftAdditions.proxy.getClientWorld().func_72910_y() : null);
            if (list != null) {
                for (Object object : list) {
                    EntityPlayer player;
                    if (object == null || !(object instanceof EntityPlayer) || !PlayerUtils.playerMatches(uuid, player = (EntityPlayer)object)) continue;
                    return player;
                }
            }
        }
        return null;
    }

    public static boolean isUUIDString(String uuid) {
        return uuid != null && uuidPattern.matcher(uuid).matches();
    }

    public static void writeToNBT(NBTTagCompound nbt, UUID uuid) {
        nbt.func_74778_a("owner", PlayerUtils.getUUIDString(uuid));
    }

    public static UUID readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("owner", 8)) {
            String owner = nbt.func_74779_i("owner");
            if (PlayerUtils.isUUIDString(owner)) {
                return PlayerUtils.getUUID(owner);
            }
            return PlayerUtils.getPlayerUUID(owner);
        }
        return null;
    }

    public static void writeToByteBuff(ByteBuf buf, UUID uuid) {
        String s = PlayerUtils.getUUIDString(uuid);
        buf.writeInt(s.length());
        for (int i = 0; i < s.length(); ++i) {
            buf.writeChar((int)s.charAt(i));
        }
    }

    public static UUID readFromByteBuff(ByteBuf buf) {
        String s = "";
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            s = s + buf.readChar();
        }
        return PlayerUtils.getUUID(s);
    }
}

