/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.utils;

import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Location {
    public final World world;
    public int x;
    public int y;
    public int z;

    public Location(World world, int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.world = world;
    }

    public Location(TileEntity entity) {
        this.world = entity.func_145831_w();
        this.x = entity.field_145851_c;
        this.y = entity.field_145848_d;
        this.z = entity.field_145849_e;
    }

    public Location copy() {
        return new Location(this.world, this.x, this.y, this.z);
    }

    public Location move(ForgeDirection direction) {
        return this.move(direction, 1);
    }

    public Location move(ForgeDirection direction, int blocks) {
        this.x += direction.offsetX * blocks;
        this.y += direction.offsetY * blocks;
        this.z += direction.offsetZ;
        return this;
    }

    public Location move(ForgeDirection ... directions) {
        for (ForgeDirection direction : directions) {
            this.move(direction);
        }
        return this;
    }

    public TileEntity getTileEntity() {
        return this.world.func_147438_o(this.x, this.y, this.z);
    }

    public Block getBlock() {
        return this.world.func_147439_a(this.x, this.y, this.z);
    }

    public void setBlock(Block block) {
        this.world.func_147449_b(this.x, this.y, this.z, block);
    }

    public void setMetadata(int meta) {
        this.world.func_72921_c(this.x, this.y, this.z, meta, 2);
    }

    public int getMeatadata() {
        return this.world.func_72805_g(this.x, this.y, this.z);
    }

    public void addTileEntity(TileEntity entity) {
        this.world.func_147455_a(this.x, this.y, this.z, entity);
    }

    public void removeTileEntity() {
        this.world.func_147475_p(this.x, this.y, this.z);
    }

    public void scheduleBlockUpdate(int delay) {
        this.world.func_147464_a(this.x, this.y, this.z, this.getBlock(), delay);
    }

    public boolean isSameLocation(Location location) {
        return this.world.field_73011_w.field_76574_g == location.world.field_73011_w.field_76574_g && this.x == location.x && this.y == location.y && this.z == location.z;
    }

    public void neighbourUpdate() {
        this.world.func_147460_e(this.x, this.y, this.z, this.getBlock());
    }
}

