/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities.varHelpers;

import buildcraftAdditions.api.nbt.INBTSaveable;
import buildcraftAdditions.api.networking.ISyncObject;
import buildcraftAdditions.reference.enums.EnumMachineUpgrades;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;

public class Upgrades
implements ISyncObject,
INBTSaveable {
    private final EnumSet<EnumMachineUpgrades> upgrades;
    private final EnumSet<EnumMachineUpgrades> whitelist;
    private final EnumSet<EnumMachineUpgrades> blacklist;
    private byte maxUpgrades;

    public Upgrades(int maxUpgrades) {
        this.maxUpgrades = (byte)(0xFF & maxUpgrades);
        this.upgrades = EnumSet.noneOf(EnumMachineUpgrades.class);
        this.whitelist = EnumSet.noneOf(EnumMachineUpgrades.class);
        this.blacklist = EnumSet.noneOf(EnumMachineUpgrades.class);
    }

    public Upgrades installUpgrade(EnumMachineUpgrades upgrade) {
        this.upgrades.add(upgrade);
        return this;
    }

    public boolean canInstallUpgrade(EnumMachineUpgrades upgrade) {
        return !(this.upgrades.size() >= this.maxUpgrades || this.upgrades.contains((Object)upgrade) && !upgrade.canBeInstalledMultipleTimes() || this.blacklist.contains((Object)upgrade) || !this.whitelist.isEmpty() && !this.whitelist.contains((Object)upgrade));
    }

    public Upgrades blacklistUpgrade(EnumMachineUpgrades upgrade) {
        this.blacklist.add(upgrade);
        return this;
    }

    public Upgrades whitelistUpgrade(EnumMachineUpgrades upgrade) {
        this.whitelist.add(upgrade);
        return this;
    }

    public Set<EnumMachineUpgrades> getUpgrades() {
        return ImmutableSet.copyOf(this.upgrades);
    }

    public boolean hasUpgrade(EnumMachineUpgrades upgrade) {
        return this.upgrades.contains((Object)upgrade);
    }

    public EnumMachineUpgrades removeUpgrade() {
        if (this.upgrades.size() == 0) {
            return null;
        }
        EnumMachineUpgrades upgrade = null;
        Iterator it = this.upgrades.iterator();
        while (it.hasNext()) {
            upgrade = (EnumMachineUpgrades)((Object)it.next());
        }
        it.remove();
        return upgrade;
    }

    @Override
    public void writeToByteBuff(ByteBuf buf) {
        buf.writeByte((int)this.maxUpgrades);
        buf.writeByte(this.upgrades.size());
        for (EnumMachineUpgrades upgrade : this.upgrades) {
            buf.writeByte(upgrade.ordinal());
        }
    }

    @Override
    public void readFromByteBuff(ByteBuf buf) {
        this.maxUpgrades = buf.readByte();
        this.upgrades.clear();
        byte installedUpgrades = buf.readByte();
        for (byte b = 0; b < installedUpgrades; b = (byte)(b + 1)) {
            this.upgrades.add(EnumMachineUpgrades.values()[buf.readByte()]);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74774_a("maxUpgrades", this.maxUpgrades);
        byte[] upgradeIDs = new byte[this.upgrades.size()];
        EnumMachineUpgrades[] upgradeArray = this.upgrades.toArray(new EnumMachineUpgrades[this.upgrades.size()]);
        for (int i = 0; i < upgradeIDs.length; ++i) {
            upgradeIDs[i] = (byte)(0xFF & upgradeArray[i].ordinal());
        }
        tag.func_74773_a("upgrades", upgradeIDs);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        Object[] upgradeIDs;
        if (tag.func_150297_b("maxUpgrades", 3)) {
            this.maxUpgrades = (byte)(0xFF & tag.func_74762_e("maxUpgrades"));
        }
        if (tag.func_150297_b("maxUpgrades", 1)) {
            this.maxUpgrades = tag.func_74771_c("maxUpgrades");
        }
        if (tag.func_150297_b("upgrades", 11)) {
            for (int i : upgradeIDs = tag.func_74759_k("upgrades")) {
                this.upgrades.add(EnumMachineUpgrades.values()[i]);
            }
        }
        if (tag.func_150297_b("upgrades", 7)) {
            for (int b : upgradeIDs = (Object[])tag.func_74770_j("upgrades")) {
                this.upgrades.add(EnumMachineUpgrades.values()[b]);
            }
        }
    }

    public void setMaxUpgrades(int maxUpgrades) {
        this.maxUpgrades = (byte)(0xFF & maxUpgrades);
    }

    public void invalidate() {
        this.upgrades.clear();
    }

    public String toString() {
        return "Upgrades: maxUpgrades = [" + this.maxUpgrades + "], upgrades = " + this.upgrades + ", whitelist = " + this.whitelist + ", blacklist = " + this.blacklist;
    }
}

