/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities.varHelpers;

import buildcraftAdditions.api.nbt.INBTSaveable;
import buildcraftAdditions.api.networking.ISyncObject;
import buildcraftAdditions.multiBlocks.MultiBlockPatern;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MultiBlockData
implements ISyncObject,
INBTSaveable {
    public int masterX;
    public int masterY;
    public int masterZ;
    public int rotationIndex;
    public int oldmasterX;
    public int oldmasterY;
    public int oldmasterZ;
    public boolean isMaster = false;
    public boolean partOfMultiBlock = false;
    public boolean moved;
    public MultiBlockPatern patern;

    public MultiBlockData invalidate() {
        this.masterX = 0;
        this.masterY = 0;
        this.masterZ = 0;
        this.isMaster = false;
        this.partOfMultiBlock = false;
        return this;
    }

    public void invalidataMultiblock(World world) {
        this.patern.destroyMultiblock(world, this.masterX, this.masterY, this.masterZ, this.rotationIndex);
    }

    public MultiBlockData formMultiBlock(int masterX, int masterY, int masterZ, int rotationIndex) {
        this.masterX = masterX;
        this.masterY = masterY;
        this.masterZ = masterZ;
        this.partOfMultiBlock = true;
        this.rotationIndex = rotationIndex;
        return this;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("masterX", this.masterX);
        tag.func_74768_a("masterY", this.masterY);
        tag.func_74768_a("masterZ", this.masterZ);
        tag.func_74768_a("rotationIndex", this.rotationIndex);
        tag.func_74757_a("isMaster", this.isMaster);
        tag.func_74757_a("partOfMultiBlock", this.partOfMultiBlock);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.masterX = tag.func_74762_e("masterX");
        this.masterY = tag.func_74762_e("masterY");
        this.masterZ = tag.func_74762_e("masterZ");
        this.rotationIndex = tag.func_74762_e("rotationIndex");
        this.isMaster = tag.func_74767_n("isMaster");
        this.partOfMultiBlock = tag.func_74767_n("partOfMultiBlock");
    }

    public MultiBlockData setPatern(MultiBlockPatern patern) {
        this.patern = patern;
        return this;
    }

    public MultiBlockData onMove(ForgeDirection direction) {
        if (this.isMaster) {
            this.oldmasterX = this.masterX;
            this.oldmasterY = this.masterY;
            this.oldmasterZ = this.masterZ;
            this.masterX += direction.offsetX;
            this.masterY += direction.offsetY;
            this.masterZ += direction.offsetZ;
            this.moved = true;
        } else {
            this.oldmasterX = this.masterX;
            this.oldmasterY = this.masterY;
            this.oldmasterZ = this.masterZ;
            this.moved = true;
            this.masterX += direction.offsetX;
            this.masterY += direction.offsetY;
            this.masterZ += direction.offsetZ;
        }
        return this;
    }

    public void afterMoveCheck(World world) {
        if (!this.patern.isPaternValid(world, this.masterX, this.masterY, this.masterZ, this.rotationIndex)) {
            this.patern.destroyMultiblock(world, this.masterX, this.masterY, this.masterZ, this.rotationIndex);
            this.patern.destroyMultiblock(world, this.oldmasterX, this.oldmasterY, this.oldmasterZ, this.rotationIndex);
        }
        this.moved = false;
    }

    @Override
    public void writeToByteBuff(ByteBuf buf) {
        buf.writeBoolean(this.isMaster);
        buf.writeBoolean(this.partOfMultiBlock);
        buf.writeInt(this.masterX);
        buf.writeInt(this.masterY);
        buf.writeInt(this.masterZ);
    }

    @Override
    public void readFromByteBuff(ByteBuf buf) {
        this.isMaster = buf.readBoolean();
        this.partOfMultiBlock = buf.readBoolean();
        this.masterX = buf.readInt();
        this.masterY = buf.readInt();
        this.masterZ = buf.readInt();
    }
}

