/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraftAdditions.BuildcraftAdditions;
import buildcraftAdditions.api.recipe.BCARecipeManager;
import buildcraftAdditions.api.recipe.refinery.IRefineryRecipe;
import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.core.Logger;
import buildcraftAdditions.multiBlocks.IMultiBlockTile;
import buildcraftAdditions.reference.Variables;
import buildcraftAdditions.reference.enums.EnumMachineUpgrades;
import buildcraftAdditions.tileEntities.Bases.TileBase;
import buildcraftAdditions.tileEntities.interfaces.IUpgradableMachine;
import buildcraftAdditions.tileEntities.varHelpers.MultiBlockData;
import buildcraftAdditions.tileEntities.varHelpers.Upgrades;
import buildcraftAdditions.utils.Location;
import buildcraftAdditions.utils.RotationUtils;
import buildcraftAdditions.utils.Utils;
import buildcraftAdditions.utils.fluids.ITankHolder;
import buildcraftAdditions.utils.fluids.RefineryRecipeTank;
import buildcraftAdditions.utils.fluids.Tank;
import cofh.api.energy.IEnergyReceiver;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileRefinery
extends TileBase
implements IMultiBlockTile,
IFluidHandler,
IEnergyReceiver,
ITankHolder,
IPipeConnection,
IUpgradableMachine {
    public final int maxEnergy;
    public final int maxTransfer;
    public final Tank input = new RefineryRecipeTank("Input", 3000, this);
    public final Tank output = new Tank(3000, this, "Output");
    protected final Upgrades upgrades = new Upgrades(0);
    private final MultiBlockData data = new MultiBlockData().setPatern(Variables.Paterns.REFINERY);
    public int energy;
    public int currentHeat = 20;
    public int requiredHeat;
    public int energyCost;
    public int heatTimer;
    public int lastRequiredHeat = 20;
    public boolean valve;
    public boolean isCooling;
    public boolean moved;
    public TileRefinery master;
    private boolean firstTick = true;
    private FluidStack outputFluidStack;
    private FluidStack inputFluidStack;
    private String inputFluid = "";
    private String outputFluid = "";

    public TileRefinery() {
        super(Variables.SyncIDs.REFINERY.ordinal());
        this.maxEnergy = ConfigurationHandler.capacityRefinery;
        this.maxTransfer = ConfigurationHandler.maxTransferRefinery;
    }

    public void func_145845_h() {
        IFluidHandler tank;
        Location location;
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.data.moved) {
            this.data.afterMoveCheck(this.field_145850_b);
            this.field_145850_b.func_147464_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 80);
        }
        if (this.valve && this.upgrades.hasUpgrade(EnumMachineUpgrades.AUTO_OUTPUT)) {
            if (this.master == null) {
                this.findMaster();
            }
            if (this.master == null) {
                return;
            }
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                location = new Location(this).move(direction);
                TileEntity entity = location.getTileEntity();
                if (entity == null || !(entity instanceof IFluidHandler) || entity instanceof TileRefinery || this.master.output.getFluidType() == null) continue;
                tank = (IFluidHandler)entity;
                int drain = tank.fill(direction.getOpposite(), new FluidStack(this.master.output.getFluidType(), ConfigurationHandler.refineryAutoExportMaxTransfer), false);
                FluidStack stack = this.master.drain(direction, drain, true);
                tank.fill(direction.getOpposite(), stack, true);
            }
        }
        if (this.valve && this.upgrades.hasUpgrade(EnumMachineUpgrades.AUTO_IMPORT)) {
            if (this.master == null) {
                this.findMaster();
            }
            if (this.master == null) {
                return;
            }
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                FluidStack drain;
                int fill;
                location = new Location(this).move(direction);
                TileEntity tile = location.getTileEntity();
                if (tile == null || !(tile instanceof IFluidHandler) || this.master.input.isFull() || (fill = this.fill(ForgeDirection.UNKNOWN, drain = (tank = (IFluidHandler)tile).drain(direction.getOpposite(), ConfigurationHandler.refineryAutoImportMaxTransfer, false), true)) <= 0) continue;
                tank.drain(direction.getOpposite(), fill, true);
            }
        }
        if (!this.data.isMaster) {
            return;
        }
        if (this.input.getFluid() != null && this.input.getFluid().amount <= 0) {
            this.input.setFluid(null);
        }
        if (this.output.getFluid() != null && this.output.getFluid().amount <= 0) {
            this.output.setFluid(null);
        }
        if (this.input.getFluid() == null) {
            this.updateRecipe();
        }
        this.updateHeat();
        if (this.firstTick) {
            this.firstTick = false;
        }
        int pEnergyCost = (int)(50.0 + 50.0 * ((double)this.currentHeat / 100.0));
        int n = this.energyCost = this.input.getFluid() == null || this.isCooling || this.energy < pEnergyCost ? 0 : pEnergyCost;
        if (this.output.isFull()) {
            this.energyCost = 0;
        }
        double factor = 0.0;
        if (this.upgrades.hasUpgrade(EnumMachineUpgrades.EFFICIENCY_1)) {
            factor += ConfigurationHandler.refineryEfficiency1EnergyCostModifier;
        }
        if (this.upgrades.hasUpgrade(EnumMachineUpgrades.EFFICIENCY_2)) {
            factor += ConfigurationHandler.refineryEfficiency2EnergyCostModifier;
        }
        if (this.upgrades.hasUpgrade(EnumMachineUpgrades.EFFICIENCY_3)) {
            factor += ConfigurationHandler.refineryEfficiency3EnergyCostModifier;
        }
        if (this.upgrades.hasUpgrade(EnumMachineUpgrades.SPEED_1)) {
            factor += ConfigurationHandler.refinerySpeed1EnergyCostModifier;
        }
        if (this.upgrades.hasUpgrade(EnumMachineUpgrades.SPEED_2)) {
            factor += ConfigurationHandler.refinerySpeed2EnergyCostModifier;
        }
        if (this.upgrades.hasUpgrade(EnumMachineUpgrades.SPEED_3)) {
            factor += ConfigurationHandler.refinerySpeed3EnergyCostModifier;
        }
        this.energyCost = (int)((double)this.energyCost + (double)this.energyCost * factor);
        this.energy -= this.energyCost * ConfigurationHandler.energyUseRefineryMultiplier;
        if (this.currentHeat < this.requiredHeat) {
            return;
        }
        int count = 1;
        if (this.upgrades.hasUpgrade(EnumMachineUpgrades.SPEED_1)) {
            count += ConfigurationHandler.refinerySpeed1SpeedModifier;
        }
        if (this.upgrades.hasUpgrade(EnumMachineUpgrades.SPEED_2)) {
            count += ConfigurationHandler.refinerySpeed2SpeedModifier;
        }
        if (this.upgrades.hasUpgrade(EnumMachineUpgrades.SPEED_3)) {
            count += ConfigurationHandler.refinerySpeed3SpeedModifier;
        }
        for (int i = 0; i < count; ++i) {
            if (this.energyCost == 0 || this.input.isEmpty() || this.output.isFull() || !this.input.getFluid().isFluidEqual(this.inputFluidStack) || this.input.getFluidAmount() < this.inputFluidStack.amount || !this.output.isEmpty() && !this.output.getFluid().isFluidEqual(this.outputFluidStack) || this.output.getFreeSpace() < this.outputFluidStack.amount) {
                return;
            }
            this.input.drain(this.inputFluidStack.amount, true);
            this.output.fill(this.outputFluidStack, true);
        }
    }

    private void updateHeat() {
        if (this.field_145850_b.field_72995_K || this.firstTick) {
            return;
        }
        if (this.heatTimer == 0) {
            if ((this.currentHeat > this.requiredHeat || this.energy < this.energyCost || this.energyCost == 0) && this.currentHeat > 20 || this.output.isFull() && this.currentHeat > 20) {
                --this.currentHeat;
                this.isCooling = true;
            }
            if (this.currentHeat < this.requiredHeat && this.energy >= this.energyCost && this.energyCost != 0 && !this.output.isFull()) {
                ++this.currentHeat;
                this.isCooling = false;
            }
            this.heatTimer = 10;
        }
        if (this.currentHeat == 20) {
            this.isCooling = false;
        }
        --this.heatTimer;
    }

    private void updateRecipe() {
        if (!this.isPartOfMultiblock()) {
            return;
        }
        if (!this.input.isEmpty()) {
            IRefineryRecipe recipe = BCARecipeManager.refinery.getRecipe(this.input.getFluid());
            if (recipe != null) {
                this.lastRequiredHeat = this.requiredHeat = recipe.getRequiredHeat();
                this.outputFluidStack = recipe.getOutput();
                this.inputFluidStack = recipe.getInput();
                this.inputFluid = this.inputFluidStack.getLocalizedName();
                this.outputFluid = this.outputFluidStack.getLocalizedName();
            }
        } else {
            this.requiredHeat = 0;
        }
    }

    @Override
    public void makeMaster(int rotationIndex) {
        this.data.isMaster = true;
        this.data.partOfMultiBlock = true;
        this.data.rotationIndex = rotationIndex;
        this.upgrades.blacklistUpgrade(EnumMachineUpgrades.AUTO_OUTPUT).blacklistUpgrade(EnumMachineUpgrades.AUTO_IMPORT).setMaxUpgrades(4);
    }

    public void findMaster() {
        TileEntity entity = this.field_145850_b.func_147438_o(this.data.masterX, this.data.masterY, this.data.masterZ);
        if (entity instanceof TileRefinery) {
            this.master = (TileRefinery)entity;
        }
        if (this.master == null || !this.master.data.isMaster) {
            this.master = null;
            this.invalidateMultiblock();
        }
    }

    @Override
    public void invalidateMultiblock() {
        if (this.isMaster()) {
            this.data.patern.destroyMultiblock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.data.rotationIndex);
        } else {
            this.data.patern.destroyMultiblock(this.field_145850_b, this.data.masterX, this.data.masterY, this.data.masterZ, this.data.rotationIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emptyTanks() {
        if (this.input.getFluid() == null || this.input.getFluid().amount < 1000 || this.input.getFluidType() == null) {
            return;
        }
        ForgeDirection[] directions = RotationUtils.rotateDirections(this.data.rotationIndex, ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.UP);
        Location location = new Location(this);
        location.move(directions);
        try {
            while (this.input.getFluid().amount >= 1000) {
                if (this.input.getFluidType().getBlock() != null) {
                    location.setBlock(this.input.getFluidType().getBlock());
                }
                this.input.drain(1000, true);
                location.move(RotationUtils.rotatateDirection(ForgeDirection.NORTH, this.data.rotationIndex));
            }
        }
        catch (Exception e) {
            Logger.error("Error while trying to empty the tank of a refinery");
        }
        finally {
            this.input.setFluid(null);
        }
        location.move(RotationUtils.rotatateDirection(ForgeDirection.NORTH, this.data.rotationIndex));
        if (this.output.getFluid() == null || this.output.getFluid().amount < 1000 || this.output.getFluidType() == null) {
            return;
        }
        try {
            while (this.output.getFluid().amount >= 1000) {
                location.setBlock(this.output.getFluidType().getBlock());
                this.output.drain(1000, true);
                location.move(RotationUtils.rotatateDirection(ForgeDirection.NORTH, this.data.rotationIndex));
            }
        }
        catch (Exception e) {
            Logger.error("Error while trying to empty the tank of a refinery");
        }
        finally {
            this.input.setFluid(null);
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player) {
        if (this.data.isMaster) {
            this.sync();
            if (!this.field_145850_b.field_72995_K) {
                player.openGui((Object)BuildcraftAdditions.instance, Variables.Gui.REFINERY.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return true;
        }
        if (this.data.partOfMultiBlock) {
            if (this.master == null) {
                this.findMaster();
            }
            if (this.master != null) {
                return this.master.onBlockActivated(player);
            }
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.data.readFromNBT(tag);
        this.valve = tag.func_74767_n("valve");
        this.energy = tag.func_74762_e("energy");
        this.currentHeat = tag.func_74762_e("currentHeat");
        this.requiredHeat = tag.func_74762_e("requiredHeat");
        this.lastRequiredHeat = tag.func_74762_e("lastRequiredHeat");
        if (tag.func_150297_b("input", 10)) {
            this.input.readFromNBT(tag.func_74775_l("input"));
        }
        if (tag.func_150297_b("output", 10)) {
            this.output.readFromNBT(tag.func_74775_l("output"));
        }
        this.updateRecipe();
        this.upgrades.readFromNBT(tag);
        if (this.valve) {
            this.upgrades.whitelistUpgrade(EnumMachineUpgrades.AUTO_OUTPUT).whitelistUpgrade(EnumMachineUpgrades.AUTO_IMPORT);
        }
        if (this.isMaster()) {
            this.upgrades.blacklistUpgrade(EnumMachineUpgrades.AUTO_OUTPUT).blacklistUpgrade(EnumMachineUpgrades.AUTO_IMPORT);
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("valve", this.valve);
        tag.func_74768_a("energy", this.energy);
        tag.func_74768_a("currentHeat", this.currentHeat);
        tag.func_74768_a("requiredHeat", this.requiredHeat);
        tag.func_74768_a("lastRequiredHeat", this.lastRequiredHeat);
        tag.func_74782_a("input", (NBTBase)this.input.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("output", (NBTBase)this.output.writeToNBT(new NBTTagCompound()));
        this.data.writeToNBT(tag);
        this.upgrades.writeToNBT(tag);
    }

    @Override
    public void formMultiblock(int masterX, int masterY, int masterZ, int rotationIndex) {
        this.data.formMultiBlock(masterX, masterY, masterZ, rotationIndex);
        if (this.valve) {
            this.upgrades.whitelistUpgrade(EnumMachineUpgrades.AUTO_OUTPUT).whitelistUpgrade(EnumMachineUpgrades.AUTO_IMPORT).setMaxUpgrades(1);
        }
        this.sync();
    }

    @Override
    public void invalidateBlock() {
        if (this.data.isMaster) {
            this.emptyTanks();
        }
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
        this.field_145850_b.func_147464_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 80);
        this.input.setFluid(null);
        this.output.setFluid(null);
        this.energy = 0;
        this.currentHeat = 0;
        this.requiredHeat = 0;
        this.energyCost = 0;
        this.heatTimer = 0;
        this.lastRequiredHeat = 0;
        this.outputFluidStack = null;
        this.inputFluidStack = null;
        this.inputFluid = "";
        this.outputFluid = "";
        this.data.invalidate();
        this.upgrades.invalidate();
        this.sync();
    }

    @Override
    public void moved(ForgeDirection direction) {
        this.data.onMove(direction);
        this.master = null;
    }

    @Override
    public int getMasterX() {
        return this.data.masterX;
    }

    @Override
    public void setMasterX(int masterX) {
        this.data.masterX = masterX;
    }

    @Override
    public int getMasterY() {
        return this.data.masterY;
    }

    @Override
    public void setMasterY(int masterY) {
        this.data.masterY = masterY;
    }

    @Override
    public int getMasterZ() {
        return this.data.masterZ;
    }

    @Override
    public void setMasterZ(int masterZ) {
        this.data.masterZ = masterZ;
    }

    @Override
    public int getRotationIndex() {
        return this.data.rotationIndex;
    }

    @Override
    public void setRotationIndex(int rotationIndex) {
        this.data.rotationIndex = rotationIndex;
    }

    @Override
    public boolean isMaster() {
        return this.data.isMaster;
    }

    @Override
    public boolean isPartOfMultiblock() {
        return this.data.partOfMultiBlock;
    }

    @Override
    public void setIsMaster(boolean isMaster) {
        this.data.isMaster = isMaster;
    }

    @Override
    public void setPartOfMultiBlock(boolean partOfMultiBlock) {
        this.data.partOfMultiBlock = partOfMultiBlock;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.valve) {
            return 0;
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master != null) {
            return this.master.realFill(resource, doFill);
        }
        return 0;
    }

    public int realFill(FluidStack resource, boolean doFill) {
        int result = this.input.fill(resource, doFill);
        this.updateRecipe();
        return result;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.isMaster()) {
            return this.realDrain(resource, doDrain);
        }
        if (!this.valve) {
            return null;
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master != null) {
            return this.master.realDrain(resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.isMaster()) {
            return this.realDrain(maxDrain, doDrain);
        }
        if (!this.valve) {
            return null;
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master != null) {
            return this.master.realDrain(maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack realDrain(int maxDrain, boolean doDrain) {
        FluidStack result = this.output.drain(maxDrain, doDrain);
        this.updateRecipe();
        return result;
    }

    public FluidStack realDrain(FluidStack fluid, boolean doDrain) {
        FluidStack result = this.output.drain(fluid, doDrain);
        this.updateRecipe();
        return result;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.data.partOfMultiBlock && this.valve;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.data.partOfMultiBlock && this.valve;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (!this.valve) {
            return null;
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master != null) {
            return this.master.realGetTankInfo();
        }
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.input), new FluidTankInfo((IFluidTank)this.output)};
    }

    public FluidTankInfo[] realGetTankInfo() {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.input), new FluidTankInfo((IFluidTank)this.output)};
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.isMaster()) {
            int energyReceived = Math.min(this.maxEnergy - this.energy, Math.min(this.maxTransfer, maxReceive));
            if (!simulate) {
                this.energy += energyReceived;
            }
            return energyReceived;
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master != null) {
            return this.master.receiveEnergy(from, maxReceive, simulate);
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.data.isMaster) {
            return this.energy;
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master != null) {
            return this.master.getEnergyStored(from);
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.data.isMaster) {
            return this.maxEnergy;
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master != null) {
            return this.master.getMaxEnergyStored(from);
        }
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public Tank[] getTanks() {
        return new Tank[]{this.input, this.output};
    }

    @Override
    public void writeToByteBuff(ByteBuf buf) {
        buf.writeBoolean(this.valve);
        buf.writeInt(this.currentHeat);
        buf.writeInt(this.lastRequiredHeat);
        buf.writeInt(this.energyCost);
        buf.writeInt(this.requiredHeat);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.inputFluid);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.outputFluid);
        this.input.writeToByteBuff(buf);
        this.output.writeToByteBuff(buf);
        this.data.writeToByteBuff(buf);
        this.upgrades.writeToByteBuff(buf);
    }

    @Override
    public void readFromByteBuff(ByteBuf buf) {
        this.valve = buf.readBoolean();
        this.currentHeat = buf.readInt();
        this.lastRequiredHeat = buf.readInt();
        this.energyCost = buf.readInt();
        this.requiredHeat = buf.readInt();
        this.inputFluid = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.outputFluid = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.input.readFromByteBuff(buf);
        this.output.readFromByteBuff(buf);
        this.data.readFromByteBuff(buf);
        this.upgrades.readFromByteBuff(buf);
    }

    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return this.valve && type == IPipeTile.PipeType.FLUID || type == IPipeTile.PipeType.POWER ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
    }

    @Override
    public boolean canAcceptUpgrade(EnumMachineUpgrades upgrade) {
        if (this.valve || this.isMaster()) {
            return this.upgrades.canInstallUpgrade(upgrade);
        }
        if (this.master == null) {
            this.findMaster();
        }
        return this.master != null && this.master.canAcceptUpgrade(upgrade);
    }

    @Override
    public void installUpgrade(EnumMachineUpgrades upgrade) {
        if (this.valve || this.isMaster()) {
            this.upgrades.installUpgrade(upgrade);
        } else {
            if (this.master == null) {
                this.findMaster();
            }
            if (this.master == null) {
                return;
            }
            this.master.installUpgrade(upgrade);
        }
    }

    @Override
    public Set<EnumMachineUpgrades> getInstalledUpgrades() {
        if (this.isMaster()) {
            return this.upgrades.getUpgrades();
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master == null) {
            return EnumSet.noneOf(EnumMachineUpgrades.class);
        }
        EnumSet<EnumMachineUpgrades> set = EnumSet.noneOf(EnumMachineUpgrades.class);
        set.addAll(this.master.getInstalledUpgrades());
        if (this.valve) {
            set.addAll(this.upgrades.getUpgrades());
        }
        return ImmutableSet.copyOf(set);
    }

    @Override
    public void removeUpgrade() {
        if (this.valve || this.isMaster()) {
            EnumMachineUpgrades upgrade = this.upgrades.removeUpgrade();
            if (upgrade == null) {
                return;
            }
            ItemStack stack = upgrade.getItemStack();
            Utils.dropItemstack(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, stack);
        } else {
            if (this.master == null) {
                this.findMaster();
            }
            if (this.master == null) {
                return;
            }
            EnumMachineUpgrades upgrade = this.master.upgrades.removeUpgrade();
            if (upgrade == null) {
                return;
            }
            ItemStack stack = upgrade.getItemStack();
            Utils.dropItemstack(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, stack);
        }
    }

    public String getOutput() {
        return this.outputFluid;
    }

    public String getInput() {
        return this.inputFluid;
    }
}

