/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities;

import buildcraftAdditions.api.recipe.BCARecipeManager;
import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.reference.Variables;
import buildcraftAdditions.tileEntities.Bases.TileBaseDuster;
import buildcraftAdditions.utils.Utils;
import cofh.api.energy.IEnergyReceiver;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileMechanicalDuster
extends TileBaseDuster
implements IEnergyReceiver {
    public final int capacity = ConfigurationHandler.capacityMechanicalDuster;
    public final int maxTransfer = ConfigurationHandler.maxTransferMechanicalDuster;
    public int progressStage;
    public int oldProgressStage;
    public int energy;
    public EntityPlayer player;

    public TileMechanicalDuster() {
        super("dusterTier2-2", Variables.SyncIDs.MECHANIC_DUSTER.ordinal());
        this.particles /= 20;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.energy >= ConfigurationHandler.energyUseMechanicalDuster) {
            if (BCARecipeManager.duster.getRecipe(this.func_70301_a(0)) != null) {
                ++this.progress;
                this.energy -= ConfigurationHandler.energyUseMechanicalDuster;
                this.spawnDustingParticles();
                this.oldProgressStage = this.progressStage;
                if (this.progress > 25) {
                    this.progressStage = 1;
                }
                if (this.progress > 50) {
                    this.progressStage = 2;
                }
                if (this.progress > 75) {
                    this.progressStage = 3;
                }
                if (this.progress >= 100) {
                    this.dust();
                    if (this.player != null) {
                        this.makeEurekaProgress(this.player);
                    }
                    this.progress = 0;
                    this.progressStage = 0;
                }
            } else {
                this.progress = 0;
                this.progressStage = 0;
            }
        }
        if (this.oldProgressStage != this.progressStage) {
            this.sync();
            this.oldProgressStage = this.progressStage;
        }
    }

    @Override
    public double getProgress() {
        return (double)this.progress / 100.0;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("energy", this.energy);
        tag.func_74768_a("progressStage", this.progressStage);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.energy = tag.func_74762_e("energy");
        this.progressStage = tag.func_74762_e("progressStage");
    }

    @Override
    public void dust() {
        Utils.dropItemstack(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, BCARecipeManager.duster.getRecipe(this.func_70301_a(0)).getOutput(this.func_70301_a(0)));
        this.func_70299_a(0, null);
        this.sync();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxTransfer, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energy;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.capacity;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public void readFromByteBuff(ByteBuf buf) {
        super.readFromByteBuff(buf);
        this.energy = buf.readInt();
        this.progressStage = buf.readInt();
    }

    @Override
    public void writeToByteBuff(ByteBuf buf) {
        super.writeToByteBuff(buf);
        buf.writeInt(this.energy);
        buf.writeInt(this.progressStage);
    }
}

