/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities;

import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.reference.Variables;
import buildcraftAdditions.tileEntities.Bases.TileCoilBase;
import buildcraftAdditions.utils.fluids.RestrictedTank;
import buildcraftAdditions.utils.fluids.WhitelistedTank;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileLavaCoil
extends TileCoilBase
implements IFluidHandler {
    private final RestrictedTank tank = new WhitelistedTank("LavaTank", 3000, (TileEntity)this, FluidRegistry.LAVA);

    public TileLavaCoil() {
        super(Variables.SyncIDs.LAVA_COIL.ordinal());
        this.burnTime = 0;
        this.fullBurnTime = 0;
        this.shouldHeat = false;
        this.burning = false;
    }

    public int getLavaAmount() {
        return this.tank.getFluidAmount();
    }

    public int getLavaCapacity() {
        return this.tank.getCapacity();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_150297_b("LavaTank", 10)) {
            this.tank.readFromNBT(tag.func_74775_l("LavaTank"));
        }
        if (tag.func_150297_b("lava", 3)) {
            this.tank.setFluid(new FluidStack(FluidRegistry.LAVA, tag.func_74762_e("lava")));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74782_a("LavaTank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.isBurning() && this.burnTime > 0) {
            --this.burnTime;
        }
        if (this.burnTime == 0) {
            this.burning = false;
        }
        if (!this.isBurning() && this.shouldHeat && this.tank.getFluidAmount() >= 100) {
            this.tank.drain(100, true);
            this.burnTime = 5000;
            this.increment = ConfigurationHandler.lavaCoilHeat;
            this.burning = true;
        }
        if (!this.isBurning()) {
            this.increment = 0;
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tank.drain(resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tank.canFill(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

