/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities;

import buildcraftAdditions.api.configurableOutput.EnumPriority;
import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.reference.BlockLoader;
import buildcraftAdditions.reference.Variables;
import buildcraftAdditions.tileEntities.Bases.TileKineticEnergyBufferBase;
import buildcraftAdditions.utils.Location;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileKineticEnergyBufferTier1
extends TileKineticEnergyBufferBase {
    public int energyState;
    public int lastEnergyState;
    private boolean creative = false;
    private boolean init = false;

    public TileKineticEnergyBufferTier1() {
        super(ConfigurationHandler.capacityKEBTier1, ConfigurationHandler.maxTransferKEBTier1, ConfigurationHandler.KEB1powerloss, 1, Variables.SyncIDs.KEBT1.ordinal());
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.creative) {
            if (!this.init) {
                this.energy = this.capacity;
                this.energyState = 9;
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 9, 2);
                this.init = true;
            }
            this.outputEnergy();
            return;
        }
        super.func_145845_h();
        if (this.capacity == 0) {
            return;
        }
        this.energyState = this.energy * 8 / this.capacity;
        if (this.lastEnergyState != this.energyState && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) == BlockLoader.kebT1) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.energyState, 2);
        }
        this.lastEnergyState = this.energyState;
    }

    @Override
    public int getEnergyLevel() {
        return this.creative ? 100 : super.getEnergyLevel();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.creative = tag.func_74767_n("creative");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("creative", this.creative);
    }

    @Override
    public void outputEnergy() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            for (EnumPriority priority : EnumPriority.values()) {
                if (this.configuration.getPriority(direction) != priority || !this.configuration.canSend(direction)) continue;
                Location location = new Location(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                location.move(direction);
                IEnergyReceiver energyHandler = null;
                if (location.getTileEntity() != null && location.getTileEntity() instanceof IEnergyReceiver) {
                    energyHandler = (IEnergyReceiver)location.getTileEntity();
                }
                if (energyHandler == null) continue;
                int sendEnergy = this.energy;
                if (this.canSharePower(location.getTileEntity(), direction)) {
                    TileKineticEnergyBufferTier1 keb = (TileKineticEnergyBufferTier1)location.getTileEntity();
                    sendEnergy = (this.energy + keb.energy) / 2 - keb.energy;
                }
                if (sendEnergy < 0) {
                    sendEnergy = 0;
                }
                if (sendEnergy > this.maxTransfer) {
                    sendEnergy = this.maxTransfer;
                }
                int output = energyHandler.receiveEnergy(direction.getOpposite(), sendEnergy, false);
                if (this.creative) continue;
                this.energy -= output;
            }
        }
    }

    public boolean isCreative() {
        return this.creative;
    }
}

