/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities;

import buildcraft.api.power.ILaserTarget;
import buildcraftAdditions.api.recipe.BCARecipeManager;
import buildcraftAdditions.reference.Variables;
import buildcraftAdditions.tileEntities.Bases.TileDusterWithConfigurableOutput;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;

public class TileKineticDuster
extends TileDusterWithConfigurableOutput
implements ILaserTarget {
    public int progressStage;
    public int oldProgressStage;
    private boolean receivedLaserEnergy = false;

    public TileKineticDuster() {
        super("", Variables.SyncIDs.KINETIC_DUSTER.ordinal());
    }

    public boolean requiresLaserEnergy() {
        return BCARecipeManager.duster.getRecipe(this.func_70301_a(0)) != null;
    }

    public void receiveLaserEnergy(int energy) {
        this.progress += energy;
        this.receivedLaserEnergy = true;
        if (this.progress >= 20000) {
            this.progress = 0;
            this.progressStage = 0;
            this.dust();
        } else {
            this.progressStage = this.progress >= 15000 ? 3 : (this.progress >= 10000 ? 2 : (this.progress >= 5000 ? 1 : 0));
        }
        if (this.progressStage != this.oldProgressStage) {
            this.sync();
            this.oldProgressStage = this.progressStage;
        }
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.receivedLaserEnergy) {
            this.spawnDustingParticles();
            this.receivedLaserEnergy = false;
        }
    }

    @Override
    public double getProgress() {
        return (double)this.progress / 20000.0;
    }

    @Override
    protected double getParticleOffset() {
        return 0.0;
    }

    public boolean isInvalidTarget() {
        return this.func_145837_r();
    }

    public double getXCoord() {
        return this.field_145851_c;
    }

    public double getYCoord() {
        return (double)this.field_145848_d + 0.08;
    }

    public double getZCoord() {
        return this.field_145849_e;
    }

    @Override
    public void writeToByteBuff(ByteBuf buf) {
        super.writeToByteBuff(buf);
        buf.writeInt(this.progressStage);
    }

    @Override
    public void readFromByteBuff(ByteBuf buf) {
        super.readFromByteBuff(buf);
        this.progressStage = buf.readInt();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.progressStage = tag.func_74762_e("progressStage");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("progressStage", this.progressStage);
    }
}

