/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities;

import buildcraftAdditions.BuildcraftAdditions;
import buildcraftAdditions.api.configurableOutput.EnumPriority;
import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.multiBlocks.IMultiBlockTile;
import buildcraftAdditions.reference.BlockLoader;
import buildcraftAdditions.reference.Variables;
import buildcraftAdditions.tileEntities.Bases.TileKineticEnergyBufferBase;
import buildcraftAdditions.tileEntities.varHelpers.MultiBlockData;
import buildcraftAdditions.utils.Location;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileKEBT3
extends TileKineticEnergyBufferBase
implements IMultiBlockTile {
    private final MultiBlockData data = new MultiBlockData().setPatern(Variables.Paterns.KEBT3);
    public int energyState;
    public TileKEBT3 master;

    public TileKEBT3() {
        super(ConfigurationHandler.capacityKEBTier3, ConfigurationHandler.maxTransferKEBTier3, ConfigurationHandler.KEB3powerloss, 3, Variables.SyncIDs.KEBT3.ordinal());
    }

    @Override
    public void func_145845_h() {
        if (this.data.moved) {
            this.data.afterMoveCheck(this.field_145850_b);
            this.field_145850_b.func_147464_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 80);
        }
        if (!this.data.isMaster || this.field_145850_b.field_72995_K) {
            return;
        }
        super.func_145845_h();
        this.energyState = (int)((long)this.energy * 4L) / this.capacity;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!this.data.partOfMultiBlock) {
            return 0;
        }
        if (this.data.isMaster) {
            return super.receiveEnergy(from, maxReceive, simulate);
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master == null) {
            return 0;
        }
        return this.master.receiveEnergy(from, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (!this.data.partOfMultiBlock) {
            return 0;
        }
        if (this.data.isMaster) {
            return super.extractEnergy(from, maxExtract, simulate);
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master == null) {
            return 0;
        }
        return this.master.extractEnergy(from, maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (!this.data.partOfMultiBlock) {
            return 0;
        }
        if (this.data.isMaster) {
            return super.getEnergyStored(from);
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master == null) {
            return 0;
        }
        return this.master.getEnergyStored(from);
    }

    @Override
    public int getEnergyLevel() {
        if (!this.data.partOfMultiBlock) {
            return 0;
        }
        if (this.data.isMaster) {
            return super.getEnergyLevel();
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master == null) {
            return 0;
        }
        return this.master.getEnergyLevel();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (!this.data.partOfMultiBlock) {
            return 0;
        }
        if (this.data.isMaster) {
            return super.getMaxEnergyStored(from);
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master == null) {
            return 0;
        }
        return this.master.getMaxEnergyStored(from);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.data.readFromNBT(tag);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.data.writeToNBT(tag);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        if (!this.data.partOfMultiBlock) {
            return false;
        }
        if (this.data.isMaster) {
            return super.canConnectEnergy(from);
        }
        if (this.master == null) {
            this.findMaster();
        }
        return this.master != null && this.master.canConnectEnergy(from);
    }

    @Override
    public void outputEnergy() {
        if (this.energy == 0 || !this.isMaster()) {
            return;
        }
        ArrayList<Location> list = this.data.patern.getLocations(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.data.rotationIndex);
        for (Location from : list) {
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                for (EnumPriority priority : EnumPriority.values()) {
                    IEnergyReceiver target;
                    if (this.configuration.getPriority(direction) != priority || !this.configuration.canSend(direction)) continue;
                    Location location = from.copy();
                    location.move(direction);
                    if (location.getTileEntity() == null || !(location.getTileEntity() instanceof IEnergyReceiver) || (target = (IEnergyReceiver)location.getTileEntity()) instanceof IMultiBlockTile && this.isPartOfSameMultiblock((IMultiBlockTile)((Object)target))) continue;
                    long output = this.maxTransfer;
                    if (location.getTileEntity() instanceof TileKEBT3) {
                        TileKEBT3 keb2;
                        TileKEBT3 keb = (TileKEBT3)location.getTileEntity();
                        if (keb.isMaster()) {
                            keb2 = keb;
                        } else {
                            keb.findMaster();
                            if (keb.master == null) continue;
                            keb2 = keb.master;
                        }
                        if (keb2.configuration.canSend(direction.getOpposite()) && keb2.configuration.canReceive(direction.getOpposite())) {
                            if (this.blocked[direction.ordinal()]) {
                                this.blocked[direction.ordinal()] = false;
                            } else {
                                output = (this.energy + keb2.energy) / 2 - keb2.energy;
                                this.blocked[direction.ordinal()] = true;
                            }
                        }
                    }
                    if (output < 0L) {
                        output = 0L;
                    }
                    if (output > (long)this.energy) {
                        output = this.energy;
                    }
                    this.energy -= target.receiveEnergy(direction.getOpposite(), (int)output, false);
                }
            }
        }
    }

    private boolean isPartOfSameMultiblock(IMultiBlockTile tile) {
        return tile.getMasterX() == this.field_145851_c && tile.getMasterY() == this.field_145848_d && tile.getMasterZ() == this.field_145849_e;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
        if (!this.data.partOfMultiBlock) {
            return false;
        }
        if (this.data.isMaster) {
            player.openGui((Object)BuildcraftAdditions.instance, Variables.Gui.KEB.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else {
            if (this.master == null) {
                this.findMaster();
            }
            if (this.master != null) {
                this.master.onBlockActivated(player);
            }
        }
        return true;
    }

    public void destroyMultiblock() {
        this.data.patern.destroyMultiblock(this.field_145850_b, this.data.masterX, this.data.masterY, this.data.masterZ, this.data.rotationIndex);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)(this.field_145848_d - 2), (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
    }

    private void findMaster() {
        TileEntity tileEntity;
        if (this.data.isMaster) {
            this.master = (TileKEBT3)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if ((tileEntity = this.field_145850_b.func_147438_o(this.data.masterX, this.data.masterY, this.data.masterZ)) != null && tileEntity instanceof TileKEBT3 && ((TileKEBT3)tileEntity).isMaster()) {
            this.master = (TileKEBT3)tileEntity;
        } else {
            this.data.invalidataMultiblock(this.field_145850_b);
        }
    }

    @Override
    public void makeMaster(int rotationIndex) {
        this.data.isMaster = true;
        this.data.partOfMultiBlock = true;
        this.data.rotationIndex = rotationIndex;
    }

    @Override
    public void writeToByteBuff(ByteBuf buf) {
        super.writeToByteBuff(buf);
        buf.writeInt(this.energyState);
        this.data.writeToByteBuff(buf);
    }

    @Override
    public void readFromByteBuff(ByteBuf buf) {
        super.readFromByteBuff(buf);
        this.energyState = buf.readInt();
        this.data.readFromByteBuff(buf);
    }

    @Override
    public void formMultiblock(int masterX, int masterY, int masterZ, int rotationIndex) {
        this.data.formMultiBlock(masterX, masterY, masterZ, rotationIndex);
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
    }

    @Override
    public void invalidateMultiblock() {
        if (this.data.isMaster) {
            this.data.patern.destroyMultiblock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.data.rotationIndex);
        } else {
            this.data.patern.destroyMultiblock(this.field_145850_b, this.data.masterX, this.data.masterY, this.data.masterZ, this.data.rotationIndex);
        }
    }

    @Override
    public void invalidateBlock() {
        if (this.data.isMaster) {
            this.field_145850_b.func_147464_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, BlockLoader.kebT3Core, 80);
        }
        this.data.invalidate();
        this.energy = 0;
        this.configuration.invalidate();
        this.energyState = 0;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
        this.sync();
    }

    @Override
    public void moved(ForgeDirection direction) {
        this.field_145850_b.func_147464_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 80);
        this.data.onMove(direction);
        this.master = null;
    }

    @Override
    public int getMasterX() {
        return this.data.masterX;
    }

    @Override
    public void setMasterX(int masterX) {
        this.data.masterX = masterX;
    }

    @Override
    public int getMasterY() {
        return this.data.masterY;
    }

    @Override
    public void setMasterY(int masterY) {
        this.data.masterY = masterY;
    }

    @Override
    public int getMasterZ() {
        return this.data.masterZ;
    }

    @Override
    public void setMasterZ(int masterZ) {
        this.data.masterZ = masterZ;
    }

    @Override
    public int getRotationIndex() {
        return this.data.rotationIndex;
    }

    @Override
    public void setRotationIndex(int rotationIndex) {
        this.data.rotationIndex = rotationIndex;
    }

    @Override
    public boolean isMaster() {
        return this.data.isMaster;
    }

    @Override
    public boolean isPartOfMultiblock() {
        return this.data.partOfMultiBlock;
    }

    @Override
    public void setIsMaster(boolean isMaster) {
        this.data.isMaster = isMaster;
    }

    @Override
    public void setPartOfMultiBlock(boolean partOfMultiBlock) {
        this.data.partOfMultiBlock = partOfMultiBlock;
    }

    public void destruction() {
        if (this.data.isMaster) {
            this.byeBye();
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master != null) {
            this.master.byeBye();
        }
    }
}

