/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities;

import buildcraft.api.core.EnumColor;
import buildcraft.api.items.IList;
import buildcraft.api.transport.IInjectable;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraftAdditions.inventories.CustomInventory;
import buildcraftAdditions.reference.Variables;
import buildcraftAdditions.tileEntities.Bases.TileBase;
import buildcraftAdditions.tileEntities.interfaces.IWidgetListener;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileItemSorter
extends TileBase
implements ISidedInventory,
IPipeConnection,
IWidgetListener {
    private final CustomInventory inventory = new CustomInventory("ItemSorter", 49, 64, this);
    public byte[] colors = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    private ForgeDirection rotation = ForgeDirection.UP;
    private boolean reloadRotation = false;

    public TileItemSorter() {
        super(Variables.SyncIDs.ITEM_SORTER.ordinal());
    }

    public void func_145845_h() {
        ItemStack stack;
        super.func_145845_h();
        if (this.reloadRotation) {
            this.setRotation(ForgeDirection.getOrientation((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)));
            this.reloadRotation = false;
        }
        if ((stack = this.inventory.func_70301_a(0)) == null) {
            return;
        }
        TileEntity outputTile = this.getTileFromDirection(this.getExitSide());
        if (outputTile == null || !(outputTile instanceof IInjectable)) {
            return;
        }
        IInjectable injectable = (IInjectable)outputTile;
        if (!injectable.canInjectItems(this.getExitSide().getOpposite())) {
            return;
        }
        EnumColor color = null;
        for (int i = 1; i < this.inventory.func_70302_i_(); ++i) {
            if (!this.areStacksEqual(this.inventory.func_70301_a(i), stack)) continue;
            color = EnumColor.values()[15 - this.colors[1 + (i - 1) / 6]];
            break;
        }
        if (color == null) {
            color = EnumColor.values()[15 - this.colors[0]];
        }
        injectable.injectItem(stack, true, this.getExitSide().getOpposite(), color);
        this.func_70299_a(0, null);
        this.func_70296_d();
    }

    private boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack1.func_77973_b() instanceof IList && ((IList)stack1.func_77973_b()).matches(stack1, stack2) || stack1 == null && stack2 == null || stack1 != null && stack2 != null && stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77960_j() == stack2.func_77960_j() && (stack1.field_77990_d != null || stack2.field_77990_d == null) && (stack1.field_77990_d == null || stack1.field_77990_d.equals((Object)stack2.field_77990_d));
    }

    private TileEntity getTileFromDirection(ForgeDirection dir) {
        return this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
    }

    public ForgeDirection getRotation() {
        return this.rotation;
    }

    public void setRotation(ForgeDirection dir) {
        this.rotation = dir;
        if (this.field_145850_b != null) {
            this.updateBlock();
            this.notifyNeighborBlockUpdate();
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, dir.ordinal(), 3);
        }
    }

    public ForgeDirection getEnterSide() {
        return this.rotation.getOpposite();
    }

    public ForgeDirection getExitSide() {
        return this.rotation;
    }

    protected void updateBlock() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    protected void notifyNeighborBlockUpdate() {
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
    }

    protected void updateRender() {
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void onWidgetPressed(int id, int value) {
        this.colors[id] = (byte)value;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.rotation = ForgeDirection.getOrientation((int)tag.func_74771_c("Rotation"));
        this.colors = tag.func_74770_j("Colors");
        this.inventory.readFromNBT(tag);
        if (tag.func_74764_b("reloadRotation")) {
            this.reloadRotation = true;
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74774_a("Rotation", (byte)this.rotation.ordinal());
        tag.func_74773_a("Colors", this.colors);
        this.inventory.writeToNBT(tag);
    }

    @Override
    public void writeToByteBuff(ByteBuf buf) {
        buf.writeByte(this.rotation.ordinal());
        buf.writeBytes(this.colors);
    }

    @Override
    public void readFromByteBuff(ByteBuf buf) {
        this.rotation = ForgeDirection.getOrientation((int)buf.readByte());
        buf.readBytes(this.colors);
        this.updateRender();
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == this.getEnterSide().ordinal()) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return side == this.getEnterSide().ordinal() && slot == 0;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return false;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection side) {
        if ((side == this.getExitSide() || side == this.getEnterSide()) && type.equals((Object)IPipeTile.PipeType.ITEM)) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }
}

