/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities;

import buildcraftAdditions.api.configurableOutput.EnumPriority;
import buildcraftAdditions.api.configurableOutput.EnumSideStatus;
import buildcraftAdditions.api.configurableOutput.IConfigurableOutput;
import buildcraftAdditions.api.configurableOutput.SideConfiguration;
import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.inventories.CustomInventory;
import buildcraftAdditions.reference.Variables;
import buildcraftAdditions.reference.enums.EnumMachineUpgrades;
import buildcraftAdditions.tileEntities.Bases.TileBase;
import buildcraftAdditions.tileEntities.Bases.TileCoilBase;
import buildcraftAdditions.tileEntities.interfaces.IUpgradableMachine;
import buildcraftAdditions.tileEntities.varHelpers.Upgrades;
import buildcraftAdditions.utils.Location;
import buildcraftAdditions.utils.Utils;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileHeatedFurnace
extends TileBase
implements ISidedInventory,
IUpgradableMachine,
IConfigurableOutput {
    public final TileCoilBase[] coils;
    private final CustomInventory inventory = new CustomInventory("HeatedFurnace", 2, 64, this);
    private final Upgrades upgrades = new Upgrades(1).whitelistUpgrade(EnumMachineUpgrades.AUTO_OUTPUT);
    public int progress = 0;
    public boolean isCooking = false;
    public boolean shouldUpdateCoils;
    private SideConfiguration configuration = new SideConfiguration(EnumSideStatus.BOTH);

    public TileHeatedFurnace() {
        super(Variables.SyncIDs.HEATED_FURNACE.ordinal());
        this.coils = new TileCoilBase[6];
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.upgrades.hasUpgrade(EnumMachineUpgrades.AUTO_OUTPUT)) {
            this.output();
        }
        if (this.inventory.func_70301_a(0) == null && !this.isCooking) {
            return;
        }
        if (this.shouldUpdateCoils) {
            this.updateCoils();
            this.shouldUpdateCoils = false;
        }
        if (this.canCook()) {
            if (!this.isCooking) {
                for (TileCoilBase coil : this.coils) {
                    if (coil == null) continue;
                    coil.startHeating();
                    if (!coil.isBurning()) continue;
                    this.isCooking = true;
                }
            }
            if (this.progress > 0) {
                this.isCooking = true;
            }
            if (this.progress >= ConfigurationHandler.heatedFurnaceHeatRequired) {
                ItemStack inputStack = this.func_70301_a(0);
                ItemStack outputStack = this.func_70301_a(1);
                ItemStack result = this.getResult(inputStack);
                if (outputStack == null) {
                    this.func_70299_a(1, result.func_77946_l());
                } else {
                    outputStack.field_77994_a += result.field_77994_a;
                }
                if (inputStack.field_77994_a <= 1) {
                    this.func_70299_a(0, null);
                } else {
                    --inputStack.field_77994_a;
                }
                this.progress = 0;
            } else {
                for (TileCoilBase coil : this.coils) {
                    if (coil == null) continue;
                    this.progress += coil.getIncrement();
                }
            }
        } else {
            this.stop();
        }
    }

    public void stop() {
        this.isCooking = false;
        this.progress = 0;
        this.sync();
        for (TileCoilBase coil : this.coils) {
            if (coil == null) continue;
            coil.stopHeating();
        }
    }

    @Override
    public void sync() {
        super.sync();
        this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void output() {
        if (this.func_70301_a(1) == null) {
            return;
        }
        this.func_70299_a(1, Utils.outputStack(new Location(this), this.func_70301_a(1), this.configuration));
    }

    public boolean canCook() {
        ItemStack stack0 = this.func_70301_a(0);
        ItemStack stack1 = this.func_70301_a(1);
        if (stack0 == null || stack0.func_77973_b() == null || stack0.field_77994_a <= 0) {
            return false;
        }
        ItemStack result = this.getResult(stack0);
        if (result == null || result.func_77973_b() == null || result.field_77994_a <= 0) {
            return false;
        }
        return Utils.areItemStacksMergeableStrict(stack1, result);
    }

    public ItemStack getResult(ItemStack stack) {
        return FurnaceRecipes.func_77602_a().func_151395_a(stack);
    }

    public void updateCoils() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            Location location = new Location(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).move(direction);
            TileEntity entity = location.getTileEntity();
            if (!(entity instanceof TileCoilBase)) continue;
            this.coils[direction.ordinal()] = (TileCoilBase)entity;
        }
        this.isCooking = false;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.inventory.readFromNBT(nbtTagCompound);
        this.progress = nbtTagCompound.func_74762_e("progress");
        this.isCooking = nbtTagCompound.func_74767_n("isCooking");
        this.shouldUpdateCoils = true;
        this.configuration.readFromNBT(nbtTagCompound);
        this.upgrades.readFromNBT(nbtTagCompound);
    }

    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        this.inventory.writeToNBT(nbtTagCompound);
        nbtTagCompound.func_74768_a("progress", this.progress);
        nbtTagCompound.func_74757_a("isCooking", this.isCooking);
        this.configuration.writeToNBT(nbtTagCompound);
        this.upgrades.writeToNBT(nbtTagCompound);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.getResult(stack) != null && slot == 0;
    }

    public int getScaledProgress() {
        return this.progress * 23 / ConfigurationHandler.heatedFurnaceHeatRequired + 1;
    }

    public int[] func_94128_d(int side) {
        return Utils.createSlotArray(0, 2);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return slot == 0 && this.getStatus(ForgeDirection.getOrientation((int)side)).canReceive();
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1 && this.getStatus(ForgeDirection.getOrientation((int)side)).canSend();
    }

    @Override
    public void writeToByteBuff(ByteBuf buf) {
        buf.writeInt(this.progress);
        buf.writeBoolean(this.isCooking);
        this.upgrades.writeToByteBuff(buf);
        this.configuration.writeToByteBuff(buf);
    }

    @Override
    public void readFromByteBuff(ByteBuf buf) {
        this.progress = buf.readInt();
        this.isCooking = buf.readBoolean();
        this.upgrades.readFromByteBuff(buf);
        this.configuration.readFromByteBuff(buf);
    }

    @Override
    public boolean canAcceptUpgrade(EnumMachineUpgrades upgrade) {
        return this.upgrades.canInstallUpgrade(upgrade);
    }

    @Override
    public void installUpgrade(EnumMachineUpgrades upgrade) {
        this.upgrades.installUpgrade(upgrade);
    }

    @Override
    public Set<EnumMachineUpgrades> getInstalledUpgrades() {
        return this.upgrades.getUpgrades();
    }

    @Override
    public void removeUpgrade() {
        EnumMachineUpgrades upgrade = this.upgrades.removeUpgrade();
        if (upgrade == null) {
            return;
        }
        ItemStack stack = upgrade.getItemStack();
        Utils.dropItemstack(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, stack);
    }

    @Override
    public SideConfiguration getSideConfiguration() {
        return this.configuration;
    }

    @Override
    public void setSideConfiguration(SideConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public EnumSideStatus getStatus(ForgeDirection side) {
        return this.configuration.getStatus(side);
    }

    @Override
    public void changeStatus(ForgeDirection side) {
        this.configuration.changeStatus(side);
    }

    @Override
    public EnumPriority getPriority(ForgeDirection side) {
        return this.configuration.getPriority(side);
    }

    @Override
    public void changePriority(ForgeDirection side) {
        this.configuration.changePriority(side);
    }
}

