/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities;

import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.inventories.CustomInventory;
import buildcraftAdditions.reference.Variables;
import buildcraftAdditions.tileEntities.Bases.TileMachineBase;
import buildcraftAdditions.tileEntities.interfaces.IWidgetListener;
import buildcraftAdditions.utils.Utils;
import buildcraftAdditions.utils.fluids.Tank;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileFluidicCompressor
extends TileMachineBase
implements ISidedInventory,
IFluidHandler,
IWidgetListener {
    public final Tank tank = new Tank(10000, this, "Tank");
    private final CustomInventory inventory = new CustomInventory("FluidicCompressor", 2, 1, this);
    public boolean fill;

    public TileFluidicCompressor() {
        super(ConfigurationHandler.capacityFluidicCompressor, ConfigurationHandler.maxTransferFluidicCompressor, Variables.SyncIDs.FLUIDIC_COMPRESSOR.ordinal());
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack stack = this.inventory.func_70301_a(0);
        if (stack != null) {
            ItemStack outputStack;
            Item stackItem = stack.func_77973_b();
            if (stackItem instanceof IFluidContainerItem) {
                IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)stackItem;
                if (this.fill) {
                    if (!this.tank.isEmpty()) {
                        int amount = 128;
                        if (this.tank.getFluidAmount() < amount) {
                            amount = this.tank.getFluidAmount();
                        }
                        if (this.energy >= amount) {
                            this.drain(ForgeDirection.UNKNOWN, iFluidContainerItem.fill(stack, new FluidStack(this.tank.getFluid(), amount), true), true);
                            this.energy -= amount;
                        }
                    }
                } else {
                    FluidStack contained = iFluidContainerItem.getFluid(stack);
                    if (!this.fill && !this.tank.isFull() && contained != null && contained.amount > 0) {
                        int amount = 64;
                        if (this.tank.getFreeSpace() < amount) {
                            amount = this.tank.getFreeSpace();
                        }
                        if (amount > contained.amount) {
                            amount = contained.amount;
                        }
                        iFluidContainerItem.drain(stack, this.fill(ForgeDirection.UNKNOWN, new FluidStack(contained, amount), true), true);
                    }
                }
            } else if (FluidContainerRegistry.isContainer((ItemStack)stack)) {
                if (this.fill) {
                    ItemStack filledContainer;
                    int amount;
                    if (!this.tank.isEmpty() && (amount = FluidContainerRegistry.getContainerCapacity((FluidStack)this.tank.getFluid(), (ItemStack)stack)) > 0 && this.energy >= amount && this.tank.getFluidAmount() >= amount && (filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(this.tank.getFluid(), amount), (ItemStack)stack)) != null && filledContainer.func_77973_b() != null && filledContainer.field_77994_a > 0) {
                        this.energy -= amount;
                        this.drain(ForgeDirection.UNKNOWN, amount, true);
                        this.inventory.func_70299_a(0, filledContainer.func_77946_l());
                    }
                } else {
                    FluidStack contained = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
                    if (contained != null && contained.amount > 0 && this.tank.getFreeSpace() >= contained.amount && this.fill(ForgeDirection.UNKNOWN, contained, false) == contained.amount) {
                        this.fill(ForgeDirection.UNKNOWN, contained, true);
                        ItemStack drainedContainer = FluidContainerRegistry.drainFluidContainer((ItemStack)stack);
                        if (drainedContainer != null && drainedContainer.func_77973_b() != null && drainedContainer.field_77994_a > 0) {
                            this.inventory.func_70299_a(0, drainedContainer.func_77946_l());
                        }
                    }
                }
            }
            if (this.getProgress() >= 16 && (stack = this.func_70301_a(0)) != null && ((outputStack = this.func_70301_a(1)) == null || outputStack.func_77973_b() == null || outputStack.field_77994_a <= 0)) {
                ItemStack copyStack = stack.func_77946_l();
                copyStack.field_77994_a = 1;
                this.inventory.func_70299_a(1, copyStack);
                this.inventory.func_70298_a(0, 1);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.fill = nbtTagCompound.func_74767_n("fill");
        this.inventory.readFromNBT(nbtTagCompound);
        if (nbtTagCompound.func_150297_b("tank", 10)) {
            this.tank.readFromNBT(nbtTagCompound.func_74775_l("tank"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("fill", this.fill);
        this.inventory.writeToNBT(nbtTagCompound);
        nbtTagCompound.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slotId) {
        return this.inventory.func_70301_a(slotId);
    }

    public ItemStack func_70298_a(int slotId, int count) {
        return this.inventory.func_70298_a(slotId, count);
    }

    public ItemStack func_70304_b(int var1) {
        return this.inventory.func_70304_b(var1);
    }

    public void func_70299_a(int slotId, ItemStack itemstack) {
        this.inventory.func_70299_a(slotId, itemstack);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
        this.inventory.func_70295_k_();
    }

    public void func_70305_f() {
        this.inventory.func_70295_k_();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack != null && stack.func_77973_b() != null && slot == 0 && (stack.func_77973_b() instanceof IFluidContainerItem || FluidContainerRegistry.isContainer((ItemStack)stack));
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tank.drain(resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tank.getFluidType() == fluid;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.tank)};
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public int getProgress() {
        ItemStack stack = this.inventory.func_70301_a(0);
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        FluidStack fluidstack = null;
        int capacity = 0;
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)stack.func_77973_b();
            fluidstack = iFluidContainerItem.getFluid(stack);
            capacity = iFluidContainerItem.getCapacity(stack);
        } else if (FluidContainerRegistry.isContainer((ItemStack)stack)) {
            fluidstack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            capacity = FluidContainerRegistry.getContainerCapacity((FluidStack)(this.fill ? this.tank.getFluid() : fluidstack), (ItemStack)stack);
        }
        if (fluidstack == null || capacity <= 0) {
            if (this.fill) {
                return 0;
            }
            return 16;
        }
        if (this.fill) {
            return (int)((double)fluidstack.amount * 16.0 / (double)capacity);
        }
        return (int)((double)(capacity - fluidstack.amount) * 16.0 / (double)capacity);
    }

    public int[] func_94128_d(int side) {
        return Utils.createSlotArray(0, 2);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return slot == 0 && this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    @Override
    public void writeToByteBuff(ByteBuf buf) {
        super.writeToByteBuff(buf);
        buf.writeBoolean(this.fill);
        this.tank.writeToByteBuff(buf);
        this.inventory.writeToByteBuff(buf);
    }

    @Override
    public void readFromByteBuff(ByteBuf buf) {
        super.readFromByteBuff(buf);
        this.fill = buf.readBoolean();
        this.tank.readFromByteBuff(buf);
        this.inventory.readFromByteBuff(buf);
    }

    @Override
    public void onWidgetPressed(int id, int value) {
        this.fill = value == 1;
    }
}

