/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities;

import buildcraft.api.fuels.ICoolant;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.energy.fuels.CoolantManager;
import buildcraftAdditions.BuildcraftAdditions;
import buildcraftAdditions.api.networking.ISynchronizedTile;
import buildcraftAdditions.api.recipe.BCARecipeManager;
import buildcraftAdditions.api.recipe.refinery.ICoolingTowerRecipe;
import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.multiBlocks.IMultiBlockTile;
import buildcraftAdditions.reference.Variables;
import buildcraftAdditions.reference.enums.EnumMachineUpgrades;
import buildcraftAdditions.tileEntities.Bases.TileBase;
import buildcraftAdditions.tileEntities.interfaces.IUpgradableMachine;
import buildcraftAdditions.tileEntities.varHelpers.MultiBlockData;
import buildcraftAdditions.tileEntities.varHelpers.Upgrades;
import buildcraftAdditions.utils.Location;
import buildcraftAdditions.utils.Utils;
import buildcraftAdditions.utils.fluids.CoolantTank;
import buildcraftAdditions.utils.fluids.CoolingRecipeTank;
import buildcraftAdditions.utils.fluids.ITankHolder;
import buildcraftAdditions.utils.fluids.Tank;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileCoolingTower
extends TileBase
implements IMultiBlockTile,
IFluidHandler,
ITankHolder,
ISynchronizedTile,
IPipeConnection,
IUpgradableMachine {
    public final Tank input = new CoolingRecipeTank("input", 2000, this);
    public final Tank output = new Tank(2000, this, "output");
    public final Tank coolant = new CoolantTank("coolant", 10000, this);
    private final MultiBlockData data = new MultiBlockData().setPatern(Variables.Paterns.COOLING_TOWER);
    private final Upgrades upgrades = new Upgrades(0);
    public int tank;
    public boolean valve;
    public float heat;
    private TileCoolingTower master;
    private ICoolingTowerRecipe recipe;

    public TileCoolingTower() {
        super(Variables.SyncIDs.COOLING_TOWER.ordinal());
    }

    public void func_145845_h() {
        ICoolant cooling;
        IFluidHandler tank;
        Location location;
        super.func_145845_h();
        if (this.getMasterX() == this.field_145851_c && this.getMasterY() == this.field_145848_d && this.getMasterZ() == this.field_145849_e && !this.isMaster()) {
            this.data.invalidataMultiblock(this.field_145850_b);
            this.master = null;
            return;
        }
        if (this.data.moved) {
            this.data.afterMoveCheck(this.field_145850_b);
            this.field_145850_b.func_147464_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 80);
        }
        if (this.master == null && !this.isMaster()) {
            this.findMaster();
        }
        if (this.master == null && !this.isMaster()) {
            return;
        }
        if (this.valve && this.upgrades.hasUpgrade(EnumMachineUpgrades.AUTO_OUTPUT)) {
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                location = new Location(this).move(direction);
                TileEntity entity = location.getTileEntity();
                if (entity == null || !(entity instanceof IFluidHandler) || entity instanceof TileCoolingTower || this.master.output.getFluidType() == null) continue;
                tank = (IFluidHandler)entity;
                int drain = tank.fill(direction.getOpposite(), new FluidStack(this.master.output.getFluidType(), ConfigurationHandler.coolingTowerAutoExportMaxTransfer), false);
                FluidStack stack = this.master.drain(drain, true, 1);
                tank.fill(direction.getOpposite(), stack, true);
            }
        }
        if (this.valve && this.upgrades.hasUpgrade(EnumMachineUpgrades.AUTO_IMPORT)) {
            if (this.master == null) {
                this.findMaster();
            }
            if (this.master == null) {
                return;
            }
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                location = new Location(this).move(direction);
                TileEntity tile = location.getTileEntity();
                if (tile == null || !(tile instanceof IFluidHandler)) continue;
                tank = (IFluidHandler)tile;
                FluidStack drain = tank.drain(direction.getOpposite(), ConfigurationHandler.coolingTowerAutoImportMaxTransfer, false);
                int fill = this.fill(direction.getOpposite(), drain, true);
                if (fill <= 0) continue;
                tank.drain(direction.getOpposite(), fill, true);
            }
        }
        if (!this.isMaster()) {
            return;
        }
        if (this.input.getFluid() != null && this.input.getFluid().amount <= 0) {
            this.input.setFluid(null);
        }
        if (this.output.getFluid() != null && this.output.getFluid().amount <= 0) {
            this.output.setFluid(null);
        }
        while (!this.coolant.isEmpty() && this.heat > 0.0f && (cooling = CoolantManager.INSTANCE.getCoolant(this.coolant.getFluid().getFluid())) != null) {
            this.coolant.drain(1, true);
            float factor = 1.0f;
            if (this.upgrades.hasUpgrade(EnumMachineUpgrades.EFFICIENCY_1)) {
                factor += ConfigurationHandler.coolingTowerEfficiency1CoolingModifier;
            }
            if (this.upgrades.hasUpgrade(EnumMachineUpgrades.EFFICIENCY_2)) {
                factor += ConfigurationHandler.coolingTowerEfficiency2CoolingModifier;
            }
            if (this.upgrades.hasUpgrade(EnumMachineUpgrades.EFFICIENCY_3)) {
                factor += ConfigurationHandler.coolingTowerEfficiency3CoolingModifier;
            }
            this.heat -= cooling.getDegreesCoolingPerMB(this.heat) * factor;
        }
        int count = 1;
        if (this.upgrades.hasUpgrade(EnumMachineUpgrades.SPEED_1)) {
            count += ConfigurationHandler.coolingTowerSpeed1SpeedModifier;
        }
        if (this.upgrades.hasUpgrade(EnumMachineUpgrades.SPEED_2)) {
            count += ConfigurationHandler.coolingTowerSpeed2SpeedModifier;
        }
        if (this.upgrades.hasUpgrade(EnumMachineUpgrades.SPEED_3)) {
            count += ConfigurationHandler.coolingTowerSpeed3SpeedModifier;
        }
        for (int i = 0; i < count; ++i) {
            if (this.heat > 80.0f || this.recipe == null || this.output.isFull() || this.input.isEmpty() || !this.input.getFluid().isFluidEqual(this.recipe.getInput()) || this.input.getFluidAmount() < this.recipe.getInput().amount || !this.output.isEmpty() && !this.output.getFluid().isFluidEqual(this.recipe.getOutput()) || this.output.getFreeSpace() < this.recipe.getOutput().amount) {
                return;
            }
            this.input.drain(this.recipe.getInput().amount, true);
            this.output.fill(this.recipe.getOutput(), true);
            this.heat += this.recipe.getHeat();
        }
    }

    private void updateRecipe() {
        this.recipe = this.input.getFluid() == null || this.input.getFluidAmount() == 0 ? null : BCARecipeManager.cooling.getRecipe(this.input.getFluid());
    }

    @Override
    public void makeMaster(int rotationIndex) {
        this.data.isMaster = true;
        this.data.rotationIndex = rotationIndex;
        this.upgrades.blacklistUpgrade(EnumMachineUpgrades.AUTO_OUTPUT).blacklistUpgrade(EnumMachineUpgrades.AUTO_IMPORT).setMaxUpgrades(4);
    }

    @Override
    public void invalidateMultiblock() {
        if (this.isMaster()) {
            this.data.patern.destroyMultiblock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.data.rotationIndex);
        } else {
            this.data.patern.destroyMultiblock(this.field_145850_b, this.data.masterX, this.data.masterY, this.data.masterZ, this.data.rotationIndex);
        }
        this.recipe = null;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player) {
        if (this.isMaster()) {
            player.openGui((Object)BuildcraftAdditions.instance, Variables.Gui.COOLING_TOWER.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        if (this.masterCheck()) {
            return this.master.onBlockActivated(player);
        }
        return this.isPartOfMultiblock();
    }

    @Override
    public void formMultiblock(int masterX, int masterY, int masterZ, int rotationIndex) {
        this.data.formMultiBlock(masterX, masterY, masterZ, rotationIndex);
        if (this.valve) {
            this.upgrades.whitelistUpgrade(EnumMachineUpgrades.AUTO_OUTPUT).whitelistUpgrade(EnumMachineUpgrades.AUTO_IMPORT).setMaxUpgrades(1);
        }
        this.sync();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.valve = tag.func_74767_n("valve");
        this.heat = tag.func_74760_g("heat");
        this.tank = tag.func_74762_e("tank");
        this.data.readFromNBT(tag);
        if (tag.func_150297_b("input", 10)) {
            this.input.readFromNBT(tag.func_74775_l("input"));
        }
        if (tag.func_150297_b("output", 10)) {
            this.output.readFromNBT(tag.func_74775_l("output"));
        }
        if (tag.func_150297_b("coolant", 10)) {
            this.coolant.readFromNBT(tag.func_74775_l("coolant"));
        }
        this.updateRecipe();
        this.upgrades.readFromNBT(tag);
        if (this.valve) {
            this.upgrades.whitelistUpgrade(EnumMachineUpgrades.AUTO_OUTPUT).whitelistUpgrade(EnumMachineUpgrades.AUTO_IMPORT);
        }
        if (this.isMaster()) {
            this.upgrades.blacklistUpgrade(EnumMachineUpgrades.AUTO_OUTPUT).blacklistUpgrade(EnumMachineUpgrades.AUTO_IMPORT);
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74776_a("heat", this.heat);
        tag.func_74757_a("valve", this.valve);
        tag.func_74768_a("tank", this.tank);
        this.data.writeToNBT(tag);
        tag.func_74782_a("input", (NBTBase)this.input.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("output", (NBTBase)this.output.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("coolant", (NBTBase)this.coolant.writeToNBT(new NBTTagCompound()));
        this.upgrades.writeToNBT(tag);
    }

    @Override
    public void invalidateBlock() {
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
        this.field_145850_b.func_147464_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 80);
        this.data.invalidate();
        this.input.setFluid(null);
        this.output.setFluid(null);
        this.coolant.setFluid(null);
        this.heat = 0.0f;
        this.recipe = null;
        this.sync();
    }

    private void findMaster() {
        if (this.getMasterX() == this.field_145851_c && this.getMasterY() == this.field_145848_d && this.getMasterZ() == this.field_145849_e) {
            this.data.invalidataMultiblock(this.field_145850_b);
            this.master = null;
            return;
        }
        TileEntity entity = this.field_145850_b.func_147438_o(this.data.masterX, this.data.masterY, this.data.masterZ);
        if (entity instanceof TileCoolingTower && ((TileCoolingTower)entity).isMaster()) {
            this.master = (TileCoolingTower)entity;
        } else {
            this.data.invalidataMultiblock(this.field_145850_b);
        }
    }

    @Override
    public void moved(ForgeDirection direction) {
        this.data.onMove(direction);
    }

    @Override
    public int getMasterX() {
        return this.data.masterX;
    }

    @Override
    public void setMasterX(int masterX) {
        this.data.masterX = masterX;
    }

    @Override
    public int getMasterY() {
        return this.data.masterY;
    }

    @Override
    public void setMasterY(int masterY) {
        this.data.masterY = masterY;
    }

    @Override
    public int getMasterZ() {
        return this.data.masterZ;
    }

    @Override
    public void setMasterZ(int masterZ) {
        this.data.masterZ = masterZ;
    }

    @Override
    public int getRotationIndex() {
        return this.data.rotationIndex;
    }

    @Override
    public void setRotationIndex(int rotationIndex) {
        this.data.rotationIndex = rotationIndex;
    }

    @Override
    public boolean isMaster() {
        return this.data.isMaster;
    }

    @Override
    public boolean isPartOfMultiblock() {
        return this.data.partOfMultiBlock;
    }

    @Override
    public void setIsMaster(boolean isMaster) {
        this.data.isMaster = isMaster;
    }

    @Override
    public void setPartOfMultiBlock(boolean partOfMultiBlock) {
        this.data.partOfMultiBlock = partOfMultiBlock;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.isPartOfMultiblock() && this.valve && this.masterCheck()) {
            return this.master.fill(resource, doFill, this.tank);
        }
        return 0;
    }

    private int fill(FluidStack resouce, boolean doFill, int tankID) {
        Tank tank = this.getTanks()[tankID];
        int filled = tank.fill(resouce, doFill);
        if (doFill) {
            this.updateRecipe();
        }
        return filled;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.isMaster()) {
            return this.drain(resource, doDrain, this.tank);
        }
        if (this.isPartOfMultiblock() && this.valve && this.masterCheck()) {
            return this.master.drain(resource, doDrain, this.tank);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.isMaster()) {
            return this.drain(maxDrain, doDrain, this.tank);
        }
        if (this.isPartOfMultiblock() && this.valve && this.masterCheck()) {
            return this.master.drain(maxDrain, doDrain, this.tank);
        }
        return null;
    }

    private FluidStack drain(int maxDrain, boolean doDrain, int tankID) {
        Tank tank = this.getTanks()[tankID];
        FluidStack drained = tank.drain(maxDrain, doDrain);
        this.updateRecipe();
        return drained;
    }

    private FluidStack drain(FluidStack fluid, boolean doDrain, int tankID) {
        Tank tank = this.getTanks()[tankID];
        FluidStack drained = tank.drain(fluid, doDrain);
        this.updateRecipe();
        return drained;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.valve;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.valve;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.valve) {
            if (this.masterCheck()) {
                return this.master.getRealInfo();
            }
            return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.input), new FluidTankInfo((IFluidTank)this.output)};
        }
        return new FluidTankInfo[0];
    }

    private FluidTankInfo[] getRealInfo() {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.input), new FluidTankInfo((IFluidTank)this.output)};
    }

    @Override
    public Tank[] getTanks() {
        return new Tank[]{this.input, this.output, this.coolant};
    }

    private boolean masterCheck() {
        if (this.master == null) {
            this.findMaster();
        }
        return this.master != null;
    }

    @Override
    public void writeToByteBuff(ByteBuf buf) {
        buf.writeBoolean(this.valve);
        buf.writeFloat(this.heat);
        this.input.writeToByteBuff(buf);
        this.output.writeToByteBuff(buf);
        this.coolant.writeToByteBuff(buf);
        this.data.writeToByteBuff(buf);
        this.upgrades.writeToByteBuff(buf);
    }

    @Override
    public void readFromByteBuff(ByteBuf buf) {
        this.valve = buf.readBoolean();
        this.heat = buf.readFloat();
        this.input.readFromByteBuff(buf);
        this.output.readFromByteBuff(buf);
        this.coolant.readFromByteBuff(buf);
        this.data.readFromByteBuff(buf);
        this.upgrades.readFromByteBuff(buf);
    }

    @Override
    public int getX() {
        return this.field_145851_c;
    }

    @Override
    public int getY() {
        return this.field_145848_d;
    }

    @Override
    public int getZ() {
        return this.field_145849_e;
    }

    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return this.valve && type == IPipeTile.PipeType.FLUID ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
    }

    @Override
    public boolean canAcceptUpgrade(EnumMachineUpgrades upgrade) {
        if (this.valve || this.isMaster()) {
            return this.upgrades.canInstallUpgrade(upgrade);
        }
        if (this.master == null) {
            this.findMaster();
        }
        return this.master != null && this.master.canAcceptUpgrade(upgrade);
    }

    @Override
    public void installUpgrade(EnumMachineUpgrades upgrade) {
        if (this.valve || this.isMaster()) {
            this.upgrades.installUpgrade(upgrade);
        } else {
            if (this.master == null) {
                this.findMaster();
            }
            if (this.master == null) {
                return;
            }
            this.master.installUpgrade(upgrade);
        }
    }

    @Override
    public Set<EnumMachineUpgrades> getInstalledUpgrades() {
        if (this.isMaster()) {
            return this.upgrades.getUpgrades();
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master == null) {
            return EnumSet.noneOf(EnumMachineUpgrades.class);
        }
        EnumSet<EnumMachineUpgrades> set = EnumSet.noneOf(EnumMachineUpgrades.class);
        set.addAll(this.master.getInstalledUpgrades());
        if (this.valve) {
            set.addAll(this.upgrades.getUpgrades());
        }
        return ImmutableSet.copyOf(set);
    }

    @Override
    public void removeUpgrade() {
        if (this.valve || this.isMaster()) {
            EnumMachineUpgrades upgrade = this.upgrades.removeUpgrade();
            if (upgrade == null) {
                return;
            }
            ItemStack stack = upgrade.getItemStack();
            Utils.dropItemstack(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, stack);
        } else {
            if (this.master == null) {
                this.findMaster();
            }
            if (this.master == null) {
                return;
            }
            EnumMachineUpgrades upgrade = this.master.upgrades.removeUpgrade();
            if (upgrade == null) {
                return;
            }
            ItemStack stack = upgrade.getItemStack();
            Utils.dropItemstack(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, stack);
        }
    }
}

